/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IProgressViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.SystemColor;

public class IProgressBar
extends Panel
implements IProgressViewer {
    private Color NORMAL_COLOR = SystemColor.activeCaption;
    private Color GOOD_COLOR = new Color(80, 177, 100);
    private Color BAD_COLOR = new Color(237, 100, 100);
    private int value = 0;
    private int stateChangeValue = 0;
    private int state = 0;

    public IProgressBar() {
        this.setBackground(SystemColor.control);
        this.setVisible(true);
        this.value = 0;
    }

    public IProgressBar(int n) {
        this();
        this.value = n;
    }

    @Override
    public void setState(int n) {
        if (n == 2) {
            Thread.currentThread().setPriority(10);
        }
        if (this.state != n) {
            this.stateChangeValue = this.value;
            this.state = n;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 15);
    }

    @Override
    public void paint(Graphics graphics) {
        block9: {
            if (graphics == null) break block9;
            Dimension dimension = this.getSize();
            graphics.setColor(SystemColor.control);
            if (this.value == 0) {
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
            graphics.clipRect(2, 2, dimension.width - 4, dimension.height - 4);
            float f = (float)dimension.width / 25.0f;
            graphics.setColor(this.NORMAL_COLOR);
            if (this.state != 0) {
                int n;
                for (n = 0; n < this.stateChangeValue * 25 / 100; ++n) {
                    graphics.fillRect((int)((float)n * f + 2.0f), 2, (int)(f - 2.0f), dimension.height - 4);
                }
                if (this.state == 1) {
                    graphics.setColor(this.GOOD_COLOR);
                } else if (this.state == 2) {
                    graphics.setColor(this.BAD_COLOR);
                }
                for (n = this.stateChangeValue * 25 / 100; n < this.value * 25 / 100; ++n) {
                    graphics.fillRect((int)((float)n * f + 2.0f), 2, (int)(f - 2.0f), dimension.height - 4);
                }
            } else {
                for (int i = 0; i < this.value * 25 / 100; ++i) {
                    graphics.fillRect((int)((float)i * f + 2.0f), 2, (int)(f - 2.0f), dimension.height - 4);
                }
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void setValue(int n) {
        if (this.value != n) {
            this.value = n;
            this.paint(this.getGraphics());
        }
    }

    @Override
    public void setProgress(int n) {
        this.setValue(n);
    }

    @Override
    public void setProgress(String string) {
    }
}

