/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IProgressBar;
import java.awt.CardLayout;
import java.awt.Panel;

public abstract class IProgressDialog
extends IDialog {
    protected IProgressBar progressBar;
    protected ExceptionList exceptions;
    protected int PROGRESS_BREAK = 10;
    private boolean autoMode = false;

    public IProgressDialog(IFrame iFrame, String string) {
        this(iFrame, string, false);
    }

    public IProgressDialog(IFrame iFrame, String string, boolean bl) {
        super(iFrame, string, true);
        this.autoMode = bl;
        this.exceptions = new ExceptionList();
        this.setLayout(new CardLayout(15, 15));
        Panel panel = new Panel();
        this.progressBar = new IProgressBar();
        panel.add(this.progressBar);
        this.add("p", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    public boolean isAutoMode() {
        return this.autoMode;
    }

    public void setExceptionList(ExceptionList exceptionList) {
        this.exceptions = exceptionList;
    }

    public ExceptionList getExceptionList() {
        return this.exceptions;
    }

    protected void setProgress(int n) {
        if (this.progressBar != null) {
            this.progressBar.setValue(n);
        }
    }

    protected void setProgressBreak(int n) {
        if (n > 0) {
            this.PROGRESS_BREAK = n;
        } else {
            n = 10;
        }
    }

    protected void addException(Exception exception) {
        if (this.exceptions != null) {
            this.exceptions.addException(exception);
        }
    }

    @Override
    protected void endDialog() {
        ErrorDialog errorDialog = null;
        if (!this.autoMode && this.exceptions != null && !this.exceptions.isEmpty()) {
            errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Einlesen der Daten aufgetreten, \ndie fehlerhafte Daten wurden ignoriert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
        if (errorDialog != null) {
            errorDialog.requestFocus();
        }
    }
}

