/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IProgressBar;
import java.awt.Label;

public class IProgressElement {
    public static final long NO_VALUE = -1L;
    public static final boolean EMPTY = false;
    public static final boolean FULL = true;
    private IProgressBar progressBar;
    private Label progressLabel;
    private String labelText;
    private long labelValue = -1L;
    private long startValue = 0L;
    private long endValue = 100L;
    private long aktValue = 0L;
    private long progressBreak = 1L;

    public IProgressElement() {
        this(null, null);
    }

    public IProgressElement(IProgressBar iProgressBar) {
        this(iProgressBar, null);
    }

    public IProgressElement(IProgressBar iProgressBar, Label label) {
        this.progressBar = iProgressBar;
        this.progressLabel = label;
        if (label != null) {
            this.setLabelText(label.getText());
        }
    }

    public void setProgressBar(IProgressBar iProgressBar) {
        this.progressBar = iProgressBar;
    }

    public IProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressLabel(Label label) {
        this.progressLabel = label;
        if (label != null) {
            this.setLabelText(label.getText());
        }
    }

    public Label getProgressLabel() {
        return this.progressLabel;
    }

    protected void setLabelText(String string) {
        this.labelText = string;
    }

    protected String getLabelText() {
        return this.labelText;
    }

    protected void setLabelValue(long l) {
        this.labelValue = l;
    }

    protected long getLabelValue() {
        return this.labelValue;
    }

    protected void setBorderValues(long l, long l2) {
        this.startValue = l;
        this.setEndValue(l2);
    }

    protected long getStartValue() {
        return this.startValue;
    }

    public void setEndValue(long l) {
        this.endValue = Math.max(l, this.startValue + 1L);
    }

    protected long getEndValue() {
        return this.endValue;
    }

    protected void setValue(long l) {
        this.aktValue = l;
    }

    protected long getValue() {
        return this.aktValue;
    }

    protected void setProgressBreak() {
        this.setProgressBreak((this.endValue - this.startValue) / 25L);
    }

    protected void setProgressBreak(long l) {
        this.progressBreak = Math.max(l, 1L);
    }

    protected long getProgressBreak() {
        return this.progressBreak;
    }

    protected void showProgress(boolean bl) {
        if (bl) {
            this.progressBar.setValue(100);
        } else {
            this.progressBar.setValue(0);
        }
        this.showProgress();
    }

    public void showProgress(long l) {
        this.setValue(l);
        this.showProgress();
    }

    public void showProgress(long l, String string) {
        this.setValue(l);
        this.setLabelText(string);
        this.showProgress();
    }

    protected void showProgress() {
        if (this.progressBar != null) {
            this.progressBar.setValue((int)((this.aktValue - this.startValue) * 100L / Math.max(this.endValue - this.startValue, 1L)));
        }
        if (this.progressLabel != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLabelText() != null) {
                stringBuffer.append(this.getLabelText());
            }
            if (this.getLabelValue() != -1L) {
                stringBuffer.append(this.getLabelValue());
            }
            this.progressLabel.setText(stringBuffer.toString());
        }
    }
}

