/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class IQuestionDialog
extends IDialog
implements ActionListener {
    private static final String YES_COMMAND = "Ja";
    private static final String NO_COMMAND = "Nein";
    private static final String ABORT_COMMAND = "Abbrechen";
    public static final int ANSWER_YES = 3;
    public static final int ANSWER_NO = 2;
    public static final int ANSWER_ABORT = 1;
    private int answer = 0;
    protected String message;
    protected int align;
    protected boolean abortPossible = true;

    public IQuestionDialog(IFrame iFrame, String string, String string2) {
        this(iFrame, string, string2, 0);
    }

    public IQuestionDialog(IFrame iFrame, String string, String string2, boolean bl) {
        this(iFrame, string, string2, 0, bl);
    }

    public IQuestionDialog(IFrame iFrame, String string, String string2, int n) {
        this(iFrame, string, string2, n, true);
    }

    public IQuestionDialog(IFrame iFrame, String string, String string2, int n, boolean bl) {
        super(iFrame, string, true);
        this.message = string2;
        this.align = n;
        this.abortPossible = bl;
        this.setLayout(new BorderLayout());
        this.add("North", this.createInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    protected IPanel createInfoPanel() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.message, "\n");
        IPanel iPanel = new IPanel(new FlowLayout(1, 10, 10));
        iPanel.setBorder(new IBorder(1));
        IPanel iPanel2 = new IPanel(new GridLayout(stringTokenizer.countTokens(), 1, 5, 5));
        while (stringTokenizer.hasMoreTokens()) {
            iPanel2.add(new Label(stringTokenizer.nextToken(), this.align));
        }
        iPanel.add(iPanel2);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(YES_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(NO_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        if (this.abortPossible) {
            Button button3 = new Button(ABORT_COMMAND);
            button3.addActionListener(this);
            panel.add(button3);
        }
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(YES_COMMAND)) {
            this.setAnswer(3);
        } else if (string.equals(NO_COMMAND)) {
            this.setAnswer(2);
        } else if (string.equals(ABORT_COMMAND)) {
            this.setAnswer(1);
        }
        this.endDialog();
    }

    private void setAnswer(int n) {
        this.answer = n;
    }

    public int getAnswer() {
        return this.answer;
    }

    @Override
    protected void doStandardAction() {
        this.setAnswer(3);
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.setAnswer(1);
        this.endDialog();
    }
}

