/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class IScrollTable
extends IPanel
implements AdjustmentListener,
KeyListener,
MouseWheelListener,
ITableListener {
    private ITable table;
    private ScrollPane pane;
    private Scrollbar vScrollbar;
    private Scrollbar hScrollbar;
    private int prefLines = 0;
    int lastH = -1;
    int lastV = -1;

    public IScrollTable(ITable iTable) {
        super(new BorderLayout());
        this.addKeyListener(this);
        this.table = iTable;
        this.table.addTableListener(this);
        this.table.addKeyListener(this);
        this.pane = new ScrollPane(2);
        this.add((Component)this.pane, "Center");
        this.pane.addMouseWheelListener(this);
        this.pane.setWheelScrollingEnabled(false);
        this.pane.add(iTable);
        this.vScrollbar = new Scrollbar(1);
        this.add((Component)this.vScrollbar, "East");
        this.hScrollbar = new Scrollbar(0);
        this.add((Component)this.hScrollbar, "South");
        this.vScrollbar.addAdjustmentListener(this);
        this.hScrollbar.addAdjustmentListener(this);
        this.validate();
    }

    public void setPreferredLines(int n) {
        this.prefLines = n;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.table.getMinimumSize();
        Insets insets = this.getInsets();
        dimension.width += insets.left + this.vScrollbar.getPreferredSize().width + insets.right;
        dimension.height += insets.top + this.hScrollbar.getPreferredSize().height + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.table.getPreferredSize();
        dimension.width += insets.left + this.vScrollbar.getPreferredSize().width + insets.right;
        dimension.height += insets.top + this.hScrollbar.getPreferredSize().height + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.table.getPreferredSize(this.prefLines);
        Insets insets = this.getInsets();
        dimension.width += insets.left + this.vScrollbar.getPreferredSize().width + insets.right;
        dimension.height += insets.top + this.hScrollbar.getPreferredSize().height + insets.bottom;
        if (dimension.width < 300) {
            dimension.width = 300;
        } else if (dimension.width > 600) {
            dimension.width = 600;
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        int n;
        super.doLayout();
        Dimension dimension = this.table.getPreferredSize();
        Dimension dimension2 = this.getSize();
        this.table.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        int n2 = this.vScrollbar.getValue();
        int n3 = this.hScrollbar.getValue();
        this.vScrollbar.setVisible(false);
        this.hScrollbar.setVisible(false);
        this.remove(this.vScrollbar);
        this.remove(this.hScrollbar);
        boolean bl = false;
        boolean bl2 = false;
        if (dimension.width > dimension2.width) {
            this.add((Component)this.hScrollbar, "South");
            dimension2.height -= this.hScrollbar.getSize().height;
            n = dimension.width - dimension2.width;
            this.hScrollbar.setMinimum(0);
            this.hScrollbar.setMaximum(n + this.hScrollbar.getVisibleAmount());
            this.hScrollbar.setUnitIncrement(10);
            this.hScrollbar.setBlockIncrement(30);
            this.hScrollbar.setValue(Math.min(n3, this.hScrollbar.getMaximum()));
            this.hScrollbar.setVisible(true);
            this.table.setLocation(-this.hScrollbar.getValue(), 0);
            bl2 = true;
        }
        n = this.table.createVisibleCount(dimension2.height);
        if (dimension.height > dimension2.height) {
            this.add((Component)this.vScrollbar, "East");
            dimension2.width -= this.vScrollbar.getSize().width;
            this.vScrollbar.setMinimum(0);
            this.vScrollbar.setMaximum(this.table.getCount());
            this.vScrollbar.setUnitIncrement(1);
            this.vScrollbar.setBlockIncrement(n);
            this.vScrollbar.setVisibleAmount(n);
            this.vScrollbar.setVisible(true);
            this.vScrollbar.setValue(this.table.getStartLine());
            bl = true;
        }
        if (bl2 && bl) {
            int n4 = dimension.width - dimension2.width;
            this.hScrollbar.setMaximum(n4 + this.hScrollbar.getVisibleAmount());
        }
        if (!bl2) {
            this.table.setLocation(0, 0);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof Scrollbar) {
            Scrollbar scrollbar = (Scrollbar)object;
            if (scrollbar == this.hScrollbar) {
                if (scrollbar.getValue() != this.lastH) {
                    this.table.setLocation(-scrollbar.getValue(), 0);
                    this.lastH = scrollbar.getValue();
                }
            } else if (scrollbar.getValue() != this.lastV) {
                this.table.show(scrollbar.getValue());
                this.lastV = scrollbar.getValue();
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (mouseWheelEvent.getModifiers() == 0) {
            if (this.vScrollbar.isVisible()) {
                if (n < 0) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() - this.vScrollbar.getUnitIncrement());
                } else if (n > 0) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() + this.vScrollbar.getUnitIncrement());
                }
                this.table.show(this.vScrollbar.getValue());
            }
        } else if (this.hScrollbar.isVisible()) {
            if (n < 0) {
                this.hScrollbar.setValue(this.hScrollbar.getValue() - this.hScrollbar.getBlockIncrement());
            } else if (n > 0) {
                this.hScrollbar.setValue(this.hScrollbar.getValue() + this.hScrollbar.getBlockIncrement());
            }
            this.table.setLocation(-this.hScrollbar.getValue(), 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (this.hScrollbar.isVisible()) {
                    this.hScrollbar.setValue(this.hScrollbar.getValue() - this.hScrollbar.getBlockIncrement());
                    this.table.setLocation(-this.hScrollbar.getValue(), 0);
                }
                keyEvent.consume();
                break;
            }
            case 39: {
                if (this.hScrollbar.isVisible()) {
                    this.hScrollbar.setValue(this.hScrollbar.getValue() + this.hScrollbar.getBlockIncrement());
                    this.table.setLocation(-this.hScrollbar.getValue(), 0);
                }
                keyEvent.consume();
                break;
            }
            case 38: {
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() - this.vScrollbar.getUnitIncrement());
                }
                this.table.select(this.table.getSelectedIndex() - 1);
                keyEvent.consume();
                break;
            }
            case 33: {
                int n = this.table.createVisibleCount(this.getSize().height);
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() - n);
                }
                this.table.select(this.table.getSelectedIndex() - n);
                keyEvent.consume();
                break;
            }
            case 36: {
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(0);
                }
                this.table.select(0);
                keyEvent.consume();
                break;
            }
            case 40: {
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() + this.vScrollbar.getUnitIncrement());
                }
                this.table.select(this.table.getSelectedIndex() + 1);
                keyEvent.consume();
                break;
            }
            case 34: {
                int n = this.table.createVisibleCount(this.getSize().height);
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(this.vScrollbar.getValue() + n);
                }
                this.table.select(this.table.getSelectedIndex() + n);
                keyEvent.consume();
                break;
            }
            case 35: {
                if (this.vScrollbar.isVisible()) {
                    this.vScrollbar.setValue(this.vScrollbar.getMaximum());
                }
                this.table.select(Integer.MAX_VALUE);
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
    }

    @Override
    public void cellChanged(ITableEvent iTableEvent) {
        this.doLayout();
    }
}

