/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import java.awt.AWTEventMulticaster;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class IScrollbar
extends IPanel
implements AdjustmentListener {
    Label nameLabel;
    Scrollbar bar;
    String name;
    String unit = "";
    transient AdjustmentListener adjustmentListener;

    public IScrollbar(int n, int n2, int n3, int n4, int n5, String string, String string2) {
        if (string2 != null) {
            this.unit = string2;
        }
        this.name = string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        super.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.bar = new Scrollbar(0, n2, n3, n4, n5 + n3);
        super.add(this.bar);
        this.bar.setUnitIncrement(n3);
        this.bar.setBlockIncrement(n3 * 4);
        this.bar.setValueIsAdjusting(false);
        this.bar.addAdjustmentListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.bar, gridBagConstraints);
        this.nameLabel = new Label("", 1);
        super.add(this.nameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        this.refreshLabel();
    }

    public int getValue() {
        return this.bar.getValue();
    }

    public void setValue(int n) {
        this.bar.setValue(n);
        this.refreshLabel();
    }

    private void refreshLabel() {
        this.nameLabel.setText(this.name + ": " + Integer.toString(this.bar.getValue()) + this.unit);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.refreshLabel();
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener != null) {
            this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
        }
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener != null) {
            this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
        }
    }
}

