/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.ISwitchColorizerSlider;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ISwitchColorizer
extends IColorizer {
    private Hashtable hash = new Hashtable();
    private Color defaultColor = null;
    private boolean isKeyShowing = true;

    public ISwitchColorizer() {
        this(true);
    }

    public ISwitchColorizer(boolean bl) {
        this.isKeyShowing = bl;
    }

    public boolean isKeyShowing() {
        return this.isKeyShowing;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public void add(Object object, String string, Color color) {
        Entry entry = (Entry)this.hash.get(object);
        int n = entry != null ? entry.id : this.hash.size();
        Entry entry2 = new Entry(n, string, color);
        this.hash.put(object, entry2);
    }

    @Override
    public IColorizerSlider getSlider() {
        return new ISwitchColorizerSlider(this);
    }

    @Override
    public Object clone() {
        ISwitchColorizer iSwitchColorizer = new ISwitchColorizer();
        this.copyParameters(iSwitchColorizer);
        return iSwitchColorizer;
    }

    @Override
    public void copyParameters(IColorizer iColorizer) {
        ISwitchColorizer iSwitchColorizer = (ISwitchColorizer)iColorizer;
        iSwitchColorizer.defaultColor = this.defaultColor;
        iSwitchColorizer.isKeyShowing = this.isKeyShowing;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            iSwitchColorizer.hash.put(k, ((Entry)this.hash.get(k)).clone());
        }
    }

    public int size() {
        return this.hash.size();
    }

    public Object getColorKey(int n) {
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Entry entry = (Entry)this.hash.get(k);
            if (entry.id != n) continue;
            return k;
        }
        return null;
    }

    public String getName(Object object) {
        Entry entry = (Entry)this.hash.get(object);
        return entry != null ? entry.name : null;
    }

    public Color getColor(Object object) {
        Entry entry = (Entry)this.hash.get(object);
        return entry != null ? entry.color : this.defaultColor;
    }

    public void setColor(Object object, Color color) {
        Entry entry = (Entry)this.hash.get(object);
        if (entry != null) {
            entry.color = color;
        }
    }

    @Override
    public String getParameterString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Entry entry = (Entry)this.hash.get(k);
            Color color = entry.color;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(k.toString());
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(color.getRed()));
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(color.getGreen()));
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(color.getBlue()));
        }
        if (this.defaultColor != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("DEFAULT");
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(this.defaultColor.getRed()));
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(this.defaultColor.getGreen()));
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(this.defaultColor.getBlue()));
        }
        return stringBuffer.toString();
    }

    @Override
    public void parseParameterString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                Enumeration enumeration = this.hash.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (string2.equals("DEFAULT")) {
                        this.defaultColor = new Color(n, n2, n3);
                        continue;
                    }
                    if (!string2.equals(k.toString())) continue;
                    Entry entry = (Entry)this.hash.get(k);
                    entry.color = new Color(n, n2, n3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Entry {
        String name;
        Color color;
        int id;

        Entry(int n, String string, Color color) {
            this.id = n;
            this.name = string;
            this.color = color;
        }

        public String toString() {
            return this.id + ":" + this.name + " " + String.valueOf(this.color);
        }

        public Object clone() {
            return new Entry(this.id, this.name, this.color);
        }
    }
}

