/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorButton;
import de.geocalc.awt.IColorSliderDialog;
import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ISwitchColorizer;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Hashtable;

public class ISwitchColorizerSlider
extends IColorizerSlider
implements ActionListener,
Adjustable {
    private static final String DEFAULT_NAME = "andere...";
    private Panel pane;
    private ISwitchColorizer colorizer;
    private AdjustmentListener adjustmentListener;
    private Hashtable entries;

    public ISwitchColorizerSlider(ISwitchColorizer iSwitchColorizer) {
        Object object;
        this.colorizer = iSwitchColorizer;
        this.setLayout(new GridLayout(1, 1));
        this.pane = new Panel();
        ScrollPane scrollPane = new ScrollPane();
        this.add(scrollPane);
        scrollPane.add(this.pane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.pane.setLayout(gridBagLayout);
        int n = 0;
        IColorButton iColorButton = null;
        Label label = null;
        this.entries = new Hashtable();
        for (int i = 0; i < iSwitchColorizer.size(); ++i) {
            object = iSwitchColorizer.getColorKey(i);
            if (object == null) continue;
            String string = iSwitchColorizer.getName(object);
            Color color = iSwitchColorizer.getColor(object);
            iColorButton = new IColorButton(color);
            this.pane.add(iColorButton);
            iColorButton.setActionCommand(object.toString());
            iColorButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagLayout.setConstraints(iColorButton, gridBagConstraints);
            if (iSwitchColorizer.isKeyShowing()) {
                label = new Label(object.toString());
                this.pane.add(label);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n;
                gridBagLayout.setConstraints(label, gridBagConstraints);
            }
            label = new Label(string);
            this.pane.add(label);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.entries.put(object.toString(), object);
        }
        Color color = iSwitchColorizer.getDefaultColor();
        if (color != null) {
            object = DEFAULT_NAME;
            iColorButton = new IColorButton(color);
            this.pane.add(iColorButton);
            iColorButton.setActionCommand((String)object);
            iColorButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagLayout.setConstraints(iColorButton, gridBagConstraints);
            label = new Label("");
            this.pane.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            label = new Label((String)object);
            this.pane.add(label);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.entries.put(object, object);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.pane == null) {
            return new Dimension(200, 200);
        }
        Dimension dimension = this.pane.getPreferredSize();
        return new Dimension(dimension.width + 10, Math.min(dimension.height + 10, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.7)));
    }

    public IFrame getParentFrame() {
        Container container;
        Object var1_1 = null;
        for (container = this.getParent(); container != null && !(container instanceof IFrame); container = container.getParent()) {
        }
        return container instanceof IFrame ? (IFrame)container : null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IFrame iFrame = this.getParentFrame();
        if (iFrame == null) {
            return;
        }
        if (actionEvent.getSource() instanceof IColorButton) {
            String string = actionEvent.getActionCommand();
            IColorSliderDialog iColorSliderDialog = new IColorSliderDialog(iFrame, "Farbwert (" + string + ")");
            if (string.equals(DEFAULT_NAME)) {
                iColorSliderDialog.setColor(this.colorizer.getDefaultColor());
            } else {
                iColorSliderDialog.setColor(this.colorizer.getColor(this.entries.get(string)));
            }
            iColorSliderDialog.setVisible(true);
            if (iColorSliderDialog.getReturnType() == 1) {
                Color color = iColorSliderDialog.getColor();
                ((IColorButton)actionEvent.getSource()).setColor(color);
                if (string.equals(DEFAULT_NAME)) {
                    this.colorizer.setDefaultColor(color);
                } else {
                    this.colorizer.setColor(this.entries.get(string), color);
                }
                if (this.adjustmentListener != null) {
                    this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, 0));
                }
            }
        }
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public int getMaximum() {
        return 1;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 1;
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public int getValue() {
        return 1;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    private void setColorizerParameter() {
    }

    @Override
    public void setColorizer(IColorizer iColorizer) {
    }
}

