/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IList;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;

public class ISwitchDialog
extends IDialog
implements ActionListener,
ItemListener {
    protected static final String SELECT_COMMAND = "Alle";
    protected static final String DESELECT_COMMAND = "Keine";
    protected static final String CHANGE_COMMAND = "Umkehren";
    protected static final String ABORT_COMMAND = "Abbrechen";
    protected static final String OK_COMMAND = "OK";
    private List objectList;
    private boolean multiSelect;

    public ISwitchDialog(IFrame iFrame, String string, String[] stringArray, boolean bl, boolean bl2) {
        super(iFrame, string, bl);
        this.multiSelect = bl2;
        this.createLayout();
        this.setListLayout(stringArray);
    }

    protected void createLayout() {
        this.setLayout(new BorderLayout());
        this.add("North", this.layoutDialogPanel());
        this.add("South", this.layoutButtonPanel());
        this.pack();
        this.setLocationOfParent(this.parent);
        this.setResizable(false);
    }

    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel(new BorderLayout(5, 5));
        iPanel.setBorder(new IBorder(1));
        this.objectList = new IList(10, this.multiSelect);
        iPanel.add("North", this.objectList);
        this.objectList.addItemListener(this);
        if (this.multiSelect) {
            iPanel.add("South", this.createSelectPanel());
        }
        return iPanel;
    }

    protected IPanel createSelectPanel() {
        IPanel iPanel = new IPanel(new FlowLayout(1));
        Button button = new Button(SELECT_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        button = new Button(DESELECT_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        button = new Button(CHANGE_COMMAND);
        iPanel.add(button);
        button.addActionListener(this);
        return iPanel;
    }

    protected IPanel layoutButtonPanel() {
        IPanel iPanel = new IPanel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        iPanel.add(button);
        return iPanel;
    }

    private void setListLayout(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.objectList.add(stringArray[i]);
        }
        this.objectList.makeVisible(0);
    }

    public String getSelectedItem() {
        return this.objectList.getSelectedItem();
    }

    public String[] getSelectedItems() {
        return this.objectList.getSelectedItems();
    }

    public void setSelectedItems(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.objectList.getItemCount(); ++j) {
                if (!stringArray[i].equals(this.objectList.getItem(j))) continue;
                this.objectList.select(j);
            }
        }
    }

    public void setSelectedItems(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                if (!string2.equals(this.objectList.getItem(i))) continue;
                this.objectList.select(i);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SELECT_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                this.objectList.select(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 1, this.objectList.getItem(0), 701));
        } else if (string.equals(DESELECT_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                this.objectList.deselect(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 2, this.objectList.getItem(0), 701));
        } else if (string.equals(CHANGE_COMMAND)) {
            for (int i = 0; i < this.objectList.getItemCount(); ++i) {
                if (this.objectList.isSelected(i)) {
                    this.objectList.deselect(i);
                    continue;
                }
                this.objectList.select(i);
            }
            this.itemStateChanged(new ItemEvent(this.objectList, 1, this.objectList.getItem(0), 701));
        } else if (string.equals(ABORT_COMMAND)) {
            this.doAbortAction();
        } else if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

