/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.SortableVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class ITable
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    private ITableLine header;
    private SortableVector elements;
    private Insets insets = new Insets(0, 0, 1, 1);
    private Vector listeners = new Vector();
    private int cols = 0;
    private int lines = 0;
    private int headerHeight = 0;
    private int[] width;
    private int[] oWidth;
    private int[] height;
    private int startLine;
    private int markLine = -1;
    private boolean changeLayout = false;
    long time = 0L;
    ITableCell lastHeaderCell = null;
    ITableCell lastLineCell = null;
    private Color moveColor = new Color(240, 240, 240);

    public ITable(int n) {
        this.elements = new SortableVector();
        this.cols = n;
        this.width = new int[n];
        this.height = new int[10];
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void addTableListener(ITableListener iTableListener) {
        this.listeners.addElement(iTableListener);
    }

    public void removeTableListener(ITableListener iTableListener) {
        this.listeners.removeElement(iTableListener);
    }

    public void setAlternate(int n, boolean bl) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ITableCell iTableCell = ((ITableLine)this.elements.elementAt(i)).getCell(n);
            iTableCell.setAlternate(bl);
        }
    }

    public void switchAlternate(int n) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ITableCell iTableCell = ((ITableLine)this.elements.elementAt(i)).getCell(n);
            iTableCell.switchAlternate();
        }
    }

    public void setHeader(ITableLine iTableLine) {
        this.header = iTableLine;
        ITableCell[] iTableCellArray = iTableLine.getCells();
        for (int i = 0; i < Math.min(this.cols, iTableCellArray.length); ++i) {
            iTableCellArray[i].setMarkable(true);
            Dimension dimension = iTableCellArray[i].getPreferredSize();
            this.width[i] = Math.max(this.width[i], dimension.width);
            this.headerHeight = Math.max(this.headerHeight, dimension.height);
        }
        this.changeLayout = true;
    }

    public void addLine(ITableLine iTableLine) {
        Object[] objectArray;
        if (this.lines == this.height.length) {
            objectArray = new int[this.lines * 2];
            System.arraycopy(this.height, 0, objectArray, 0, this.lines);
            this.height = (int[])objectArray;
        }
        objectArray = iTableLine.getCells();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            Dimension dimension = objectArray[i].getPreferredSize();
            this.width[i] = Math.max(this.width[i], dimension.width);
            this.height[this.lines] = Math.max(this.height[this.lines], dimension.height);
        }
        this.elements.addElement(iTableLine);
        ++this.lines;
        this.changeLayout = true;
    }

    public void removeLines() {
        this.elements.removeAllElements();
        for (int i = 0; i < this.header.length(); ++i) {
            if (this.header.getCell(i) == null) continue;
            this.header.getCell(i).setMarker(0);
        }
        this.height = new int[10];
        this.lines = 0;
        this.startLine = 0;
        this.markLine = -1;
        this.changeLayout = true;
    }

    public int getCount() {
        return this.elements.size();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int createVisibleCount(int n) {
        int n2 = this.getInsets().top + this.headerHeight + 1;
        for (int i = this.startLine; i < this.lines; ++i) {
            if ((n2 += this.height[i] + 1) <= n) continue;
            return i - 1 - this.startLine;
        }
        while (this.startLine > 0) {
            if ((n2 += this.height[this.startLine - 1] + 1) < n) {
                --this.startLine;
                continue;
            }
            if (n2 <= n) continue;
            break;
        }
        return this.lines - this.startLine;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.changeLayout) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ITableListener)enumeration.nextElement()).cellChanged(new ITableEvent(this, null, null, -1, 1002, -1, -1));
            }
        }
        this.changeLayout = false;
        this.lastLineCell = null;
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.markLine;
    }

    public Object getSelectedObject() {
        return this.markLine >= 0 && this.markLine <= this.lines ? ((ITableLine)this.elements.elementAt(this.markLine)).getObject() : null;
    }

    public void select(int n) {
        if (n > this.lines || n == this.markLine) {
            return;
        }
        this.markLine = n;
        if (this.markLine >= 0) {
            int n2;
            boolean bl = false;
            int n3 = this.getParent().getSize().height;
            int n4 = this.headerHeight + 1;
            for (n2 = this.startLine; n2 < this.elements.size(); ++n2) {
                n4 += this.height[n2] + 1;
                if (this.markLine == n2) {
                    bl = true;
                    break;
                }
                if (n4 <= n3 - this.height[n2]) continue;
                ++this.startLine;
            }
            if (!bl) {
                this.startLine = 0;
                n4 = 0;
                for (n2 = this.startLine; n2 < this.elements.size(); ++n2) {
                    n4 += this.height[n2] + 1;
                    if (this.markLine == n2) {
                        bl = true;
                        break;
                    }
                    if (n4 <= n3 - this.height[n2]) continue;
                    ++this.startLine;
                }
            }
        }
        this.repaint();
    }

    public void select(Object object) {
        this.select(this.indexOf(object));
    }

    public int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!object.equals(((ITableLine)this.elements.elementAt(i)).getObject())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public void sort(int n) {
        this.sort(n, true);
    }

    public void sort(int n, boolean bl) {
        if (n < 0 || n > this.cols - 1) {
            n = 0;
        }
        this.elements.sort(new LineComparator(this, n, bl));
        this.repaint();
    }

    public void show(int n) {
        this.startLine = n;
        this.repaint();
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getTableSize(1);
        dimension.height += this.headerHeight + 1;
        dimension.width = insets.left + 150 + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.elements.size());
    }

    public Dimension getPreferredSize(int n) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getTableSize(n);
        dimension.height = Math.max(dimension.height, this.headerHeight);
        dimension.height += this.headerHeight + 1;
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private Dimension getTableSize() {
        return this.getTableSize(this.elements.size());
    }

    private Dimension getTableSize(int n) {
        int n2;
        if (this.getFont() != null) {
            ITableCell.setTableFont(this.getFont());
        }
        for (int i = 0; i < Math.min(n, this.elements.size()); ++i) {
            ITableCell[] iTableCellArray = ((ITableLine)this.elements.elementAt(i)).getCells();
            for (int j = 0; j < iTableCellArray.length; ++j) {
                if (iTableCellArray[j] == null) continue;
                Dimension dimension = iTableCellArray[j].getPreferredSize();
                this.width[j] = Math.max(this.width[j], dimension.width);
                this.height[i] = Math.max(this.height[i], dimension.height);
            }
        }
        Dimension dimension = new Dimension(0, 0);
        for (n2 = 0; n2 < this.cols; ++n2) {
            dimension.width += this.width[n2] + 2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            dimension.height += this.height[n2] + 1;
        }
        return dimension;
    }

    private void optimizeWidths() {
        if (this.oWidth == null || this.oWidth.length != this.width.length) {
            this.oWidth = new int[this.width.length];
        }
        Insets insets = this.getInsets();
        double d = (double)this.getSize().width / ((double)this.getPreferredSize().width + (double)insets.left + (double)insets.right);
        for (int i = 0; i < this.cols; ++i) {
            this.oWidth[i] = Math.max((int)Math.rint((double)this.width[i] * d), this.width[i]);
        }
    }

    @Override
    public void repaint() {
        this.paint(this.getGraphics());
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.changeLayout) {
            this.doLayout();
        }
        this.optimizeWidths();
        Insets insets = this.getInsets();
        int n3 = this.getParent().getSize().height;
        Dimension dimension = this.getSize();
        int n4 = insets.top;
        ITableCell[] iTableCellArray = null;
        if (this.header != null) {
            iTableCellArray = this.header.getCells();
            n2 = insets.left;
            for (n = 0; n < iTableCellArray.length; ++n) {
                if (iTableCellArray[n] != null) {
                    iTableCellArray[n].setBackground(SystemColor.control);
                    iTableCellArray[n].setForeground(SystemColor.controlText);
                    iTableCellArray[n].setLocation(n2, n4);
                    iTableCellArray[n].setSize(this.oWidth[n], this.headerHeight);
                    iTableCellArray[n].paint(graphics);
                }
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine((n2 += this.oWidth[n] + 2) - 2, n4, n2 - 2, n4 + this.headerHeight);
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n2 - 1, n4, n2 - 1, n4 + this.headerHeight);
            }
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(0, this.headerHeight, dimension.width, this.headerHeight);
        }
        n4 += this.headerHeight + 1;
        for (n2 = this.startLine; n2 < this.elements.size(); ++n2) {
            iTableCellArray = ((ITableLine)this.elements.elementAt(n2)).getCells();
            n = insets.left;
            for (int i = 0; i < iTableCellArray.length; ++i) {
                if (iTableCellArray[i] != null) {
                    iTableCellArray[i].setHighlight(this.markLine == n2);
                    iTableCellArray[i].setLocation(n, n4);
                    iTableCellArray[i].setSize(this.oWidth[i] + 1, this.height[n2]);
                    iTableCellArray[i].paint(graphics);
                }
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine((n += this.oWidth[i] + 2) - 1, n4, n - 1, n4 + this.height[n2]);
            }
            graphics.drawLine(0, n4 + this.height[n2], n - 1, n4 + this.height[n2]);
            if ((n4 += this.height[n2] + 1) > n3) break;
        }
        if (n4 < dimension.height) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(0, n4, dimension.width, dimension.height - n4);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.markLine >= 0) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ITableLine iTableLine = (ITableLine)this.elements.elementAt(this.markLine);
                ((ITableListener)enumeration.nextElement()).cellClicked(new ITableEvent(this, iTableLine.getObject(), iTableLine.getCell(0).getText(), 0, 1001, 2, keyEvent.getModifiers()));
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        block10: {
            Point point;
            block8: {
                ITableCell iTableCell;
                int n;
                block9: {
                    point = mouseEvent.getPoint();
                    if (System.currentTimeMillis() - this.time < 100L) {
                        return;
                    }
                    this.time = System.currentTimeMillis();
                    if (point.y >= this.headerHeight) break block8;
                    n = this.getCol(point.x);
                    iTableCell = this.header.getCell(n);
                    if (!mouseEvent.isMetaDown() && (mouseEvent.getModifiers() & 4) != 4) break block9;
                    ITableLine iTableLine = this.header;
                    Enumeration enumeration = this.listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((ITableListener)enumeration.nextElement()).cellClicked(new ITableEvent(this, iTableLine.getObject(), iTableLine.getCell(n).getText(), n, 2001, mouseEvent.getClickCount(), mouseEvent.getModifiers()));
                    }
                    break block10;
                }
                if (!iTableCell.isMarkable()) break block10;
                if (!iTableCell.equals(this.lastHeaderCell)) {
                    if (this.lastHeaderCell != null) {
                        this.lastHeaderCell.setMarker(0);
                    }
                    this.lastHeaderCell = iTableCell;
                }
                if (iTableCell.getMarker() == 2) {
                    iTableCell.setMarker(1);
                    this.sort(n, false);
                } else {
                    iTableCell.setMarker(2);
                    this.sort(n, true);
                }
                break block10;
            }
            int n = this.getLine(point.y);
            int n2 = this.getCol(point.x);
            if (n >= 0 && n2 >= 0) {
                this.select(n);
                this.lastLineCell = null;
                ITableLine iTableLine = (ITableLine)this.elements.elementAt(n);
                Enumeration enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ITableListener)enumeration.nextElement()).cellClicked(new ITableEvent(this, iTableLine.getObject(), iTableLine.getCell(n2).getText(), n2, 1001, mouseEvent.getClickCount(), mouseEvent.getModifiers()));
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.y >= this.headerHeight) {
            ITableCell iTableCell;
            int n = this.getCol(point.x);
            int n2 = this.getLine(point.y);
            if (n >= 0 && n2 >= 0 && n2 != this.markLine && this.lastLineCell != (iTableCell = ((ITableLine)this.elements.elementAt(n2)).getCell(n))) {
                if (this.lastLineCell != null) {
                    this.lastLineCell.setBackground(Color.white);
                    this.lastLineCell.setForeground(SystemColor.textText);
                    this.lastLineCell.paint(this.getGraphics());
                    this.lastLineCell = null;
                }
                if (iTableCell.isEventable()) {
                    iTableCell.setBackground(this.moveColor);
                    iTableCell.setForeground(SystemColor.textText);
                    iTableCell.paint(this.getGraphics(), 1);
                    this.lastLineCell = iTableCell;
                }
            }
        }
    }

    private int getLine(int n) {
        int n2 = this.getInsets().top + this.headerHeight + 1;
        if (n < this.headerHeight) {
            return -1;
        }
        for (int i = this.startLine; i < this.elements.size(); ++i) {
            if (n >= (n2 += this.height[i] + 1)) continue;
            return i;
        }
        return -1;
    }

    private int getCol(int n) {
        if (this.oWidth == null) {
            return -1;
        }
        int n2 = this.getInsets().left;
        for (int i = 0; i < this.cols; ++i) {
            if (n >= (n2 += this.oWidth[i] + 2)) continue;
            return i;
        }
        return -1;
    }

    private class LineComparator
    implements Comparator {
        private int col;
        private boolean up;

        LineComparator(ITable iTable, int n, boolean bl) {
            this.col = n;
            this.up = bl;
        }

        @Override
        public int compare(Object object, Object object2) {
            int n;
            block14: {
                n = 0;
                String string = ((ITableLine)object).getCell(this.col).getText();
                String string2 = ((ITableLine)object2).getCell(this.col).getText();
                if (string == null && string2 == null) {
                    n = 0;
                } else if (string == null) {
                    n = -1;
                } else if (string2 == null) {
                    n = 1;
                } else if (IFormat.hasOnlyFloats(string) && IFormat.hasOnlyFloats(string2)) {
                    try {
                        double d;
                        double d2;
                        if (string.length() == 0) {
                            string = "0";
                        }
                        if (string2.length() == 0) {
                            string2 = "0";
                        }
                        if ((d2 = new Double(string).doubleValue()) > (d = new Double(string2).doubleValue())) {
                            n = 1;
                            break block14;
                        }
                        if (d2 < d) {
                            n = -1;
                            break block14;
                        }
                        n = 0;
                    }
                    catch (Exception exception) {
                        n = string.compareTo(string2);
                    }
                } else {
                    n = string.compareTo(string2);
                }
            }
            return this.up ? n : -n;
        }
    }
}

