/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.util.StringTokenizer;

public class ITableCell
extends Canvas {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_UP = 1;
    public static final int MARKER_DOWN = 2;
    public static final int BG_NONE = 0;
    public static final int BG_INFO = 1;
    private static final int MARKER_WIDTH = 8;
    private static final int MARKER_HEIGHT = 4;
    private static final int MARKER_INSET = 4;
    private static final Insets insets = new Insets(3, 3, 3, 3);
    private static Font font = new Font("SansSerif", 0, 12);
    private String text = null;
    private String aText = null;
    private int location = 10;
    private int marker = 0;
    private boolean markable = false;
    private boolean eventable = false;
    private boolean alternable = false;
    private boolean isHighlight = false;
    private boolean alternate = false;

    public static void setTableFont(Font font) {
        ITableCell.font = font;
    }

    public ITableCell(String string) {
        this(string, 10, false, false, 0);
    }

    public ITableCell(String string, int n) {
        this(string, null, n, false, false, 0);
    }

    public ITableCell(String string, String string2, int n) {
        this(string, string2, n, false, false, 0);
    }

    public ITableCell(String string, int n, boolean bl) {
        this(string, null, n, bl, false, 0);
    }

    public ITableCell(String string, int n, boolean bl, boolean bl2, int n2) {
        this(string, null, n, bl, bl2, n2);
    }

    public ITableCell(String string, String string2, int n, boolean bl, boolean bl2, int n2) {
        this.location = n;
        this.eventable = bl;
        this.markable = bl2;
        this.marker = n2;
        this.setText(string);
        this.aText = string2;
        this.setBackground(Color.white);
        this.setForeground(SystemColor.textText);
    }

    public void setText(String string) {
        this.text = string != null ? string : "";
    }

    public String getText() {
        return this.text;
    }

    public void setLoc(int n) {
        this.location = n;
    }

    public int getLoc() {
        return this.location;
    }

    public void setEventable(boolean bl) {
        this.eventable = bl;
    }

    public boolean isEventable() {
        return this.eventable;
    }

    public void setMarkable(boolean bl) {
        this.markable = bl;
    }

    public boolean isMarkable() {
        return this.markable;
    }

    public void setMarker(int n) {
        this.marker = n;
    }

    public int getMarker() {
        return this.marker;
    }

    public void setHighlight(boolean bl) {
        this.isHighlight = bl;
    }

    public void setAlternable(boolean bl) {
        this.alternable = bl;
    }

    public boolean isAlternable() {
        return this.alternable;
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }

    public void switchAlternate() {
        this.alternate = !this.alternate;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        if (this.text == null) {
            dimension.width = ITableCell.insets.left + ITableCell.insets.right;
            dimension.height = ITableCell.insets.top + ITableCell.insets.bottom;
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                dimension.height += fontMetrics.getHeight();
                dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(string));
            }
            if (this.aText != null) {
                stringTokenizer = new StringTokenizer(this.aText, "\n");
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    n += fontMetrics.getHeight();
                    dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(string));
                }
                dimension.height = Math.max(dimension.height, n);
            }
            dimension.width += ITableCell.insets.left + ITableCell.insets.right;
            dimension.height += ITableCell.insets.top + ITableCell.insets.bottom;
        }
        if (this.markable) {
            dimension.width += 12;
            dimension.height = Math.max(dimension.height, 12);
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, 0);
    }

    public void paint(Graphics graphics, int n) {
        Object object;
        int n2;
        Object object2;
        Dimension dimension = this.getSize();
        Point point = this.getLocation();
        Dimension dimension2 = this.getPreferredSize();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setColor(this.isHighlight ? SystemColor.textHighlight : this.getBackground());
        graphics.fillRect(point.x, point.y, dimension.width, dimension.height);
        graphics.setColor(this.isHighlight ? SystemColor.textHighlightText : this.getForeground());
        graphics.setFont(font);
        int n3 = 0;
        int n4 = 0;
        if (n != 0) {
            object2 = null;
            switch (n) {
                case 1: {
                    object2 = "(i)";
                }
            }
            n2 = fontMetrics.stringWidth((String)object2);
            switch (this.location) {
                case -10: 
                case -9: 
                case 0: 
                case 1: 
                case 10: 
                case 11: {
                    n4 = ITableCell.insets.top;
                    break;
                }
                default: {
                    n4 = ITableCell.insets.top + dimension.height - dimension2.height;
                }
            }
            n4 += fontMetrics.getAscent();
            switch (this.location) {
                case -1: 
                case 0: 
                case 1: 
                case 9: 
                case 10: 
                case 11: {
                    n3 = ITableCell.insets.left;
                    break;
                }
                default: {
                    n3 = dimension.width - ITableCell.insets.right - n2;
                }
            }
            graphics.setColor(this.getBackground().darker());
            graphics.drawString((String)object2, point.x + n3, point.y + n4);
        }
        n3 = 0;
        n4 = 0;
        switch (this.location) {
            case -10: 
            case 0: 
            case 10: {
                n4 = ITableCell.insets.top + (dimension.height - dimension2.height) / 2;
                break;
            }
            case -9: 
            case 1: 
            case 11: {
                n4 = ITableCell.insets.top + dimension.height - dimension2.height;
                break;
            }
            default: {
                n4 = ITableCell.insets.top;
            }
        }
        graphics.setColor(this.isHighlight ? SystemColor.textHighlightText : this.getForeground());
        n4 += fontMetrics.getAscent();
        object2 = new StringTokenizer(this.aText != null && this.alternate ? this.aText : this.text, "\n", true);
        n2 = this.markable && this.marker != 0 ? 12 : 0;
        int n5 = 0;
        while (((StringTokenizer)object2).hasMoreElements()) {
            object = ((StringTokenizer)object2).nextToken();
            int n6 = fontMetrics.stringWidth((String)object);
            if (((String)object).equals("\n")) {
                n4 += fontMetrics.getHeight();
            } else {
                switch (this.location) {
                    case -1: 
                    case 0: 
                    case 1: {
                        n3 = (dimension.width - n6 - n2) / 2;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n3 = dimension.width - ITableCell.insets.right - n6;
                        break;
                    }
                    default: {
                        n3 = ITableCell.insets.left;
                    }
                }
                graphics.drawString((String)object, point.x + n3, point.y + n4);
            }
            n5 = Math.max(n5, n3 + n6);
        }
        if (this.markable && this.marker != 0) {
            n3 = point.x + n5 + 4;
            n4 = point.y + dimension.height / 2;
            graphics.setColor(this.getBackground().darker());
            if (this.marker == 2) {
                object = new int[]{n3, n3 + 8, n3 + 4};
                int[] nArray = new int[]{n4 - 2, n4 - 2, n4 + 2};
                graphics.fillPolygon((int[])object, nArray, ((Object)object).length);
                graphics.drawLine((int)object[0], nArray[0], (int)object[2], nArray[2]);
                graphics.setColor(this.getBackground().brighter());
                graphics.drawLine((int)object[2], nArray[2], (int)object[1], nArray[1]);
                graphics.setColor(this.getBackground().darker().darker());
                graphics.drawLine((int)(object[0] + true), nArray[0], (int)(object[1] - true), nArray[1]);
                graphics.setColor(this.getBackground());
                graphics.drawLine((int)object[1], nArray[1], (int)object[1], nArray[1]);
            } else if (this.marker == 1) {
                object = new int[]{n3, n3 + 8, n3 + 4};
                int[] nArray = new int[]{n4 + 2 + 1, n4 + 2 + 1, n4 - 2};
                graphics.fillPolygon((int[])object, nArray, ((Object)object).length);
                graphics.drawLine((int)object[2], nArray[2], (int)object[1], nArray[1]);
                graphics.setColor(this.getBackground().brighter());
                graphics.drawLine((int)object[0], nArray[0], (int)object[1], nArray[1]);
                graphics.setColor(this.getBackground().darker().darker());
                graphics.drawLine((int)object[0], nArray[0], (int)object[2], nArray[2]);
                graphics.setColor(this.getBackground());
                graphics.drawLine((int)object[0], nArray[0], (int)object[0], nArray[0]);
            }
        }
    }
}

