/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;

public class ITextField
extends TextField {
    private boolean autoMark = true;
    private boolean isTextEnabled = true;
    private boolean absoluteLength = false;
    private String akceptChars = null;
    private String replaceChars = null;
    private String buffer = null;

    public ITextField() {
        this("", 0, true);
    }

    public ITextField(int n) {
        this("", n, true);
    }

    public ITextField(String string) {
        this(string, string.length(), true);
    }

    public ITextField(String string, int n) {
        this(string, n, true);
    }

    public ITextField(String string, int n, boolean bl) {
        super(string, n);
        this.autoMark = bl;
        this.enableEvents(4L);
        this.enableEvents(16L);
        this.enableEvents(1024L);
    }

    public void setAbsoluteLength(boolean bl) {
        this.absoluteLength = bl;
    }

    public boolean isAbsoluteLength() {
        return this.absoluteLength;
    }

    public void setAkceptChars(String string) {
        this.akceptChars = string;
    }

    public String getAkceptChars() {
        return this.akceptChars;
    }

    public void setReplaceChars(String string) {
        this.replaceChars = string;
    }

    public String getReplaceChars() {
        return this.replaceChars;
    }

    public void setAutoMark(boolean bl) {
        this.autoMark = bl;
    }

    public boolean isAutoMark() {
        return this.autoMark;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        super.setEditable(bl);
    }

    private boolean hasText() {
        String string = super.getText();
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return true;
        }
        return false;
    }

    public void setText(boolean bl) {
        if (bl) {
            if (!this.hasText()) {
                super.setText(this.buffer);
            }
        } else {
            if (this.hasText()) {
                this.buffer = super.getText();
            }
            super.setText(null);
        }
    }

    public void setTextEnabled(boolean bl) {
        this.setEnabled(bl);
        this.setText(bl);
        this.isTextEnabled = bl;
    }

    public boolean isTextEnabled() {
        return this.isTextEnabled;
    }

    @Override
    public void processTextEvent(TextEvent textEvent) {
        String string = this.getText();
        boolean bl = false;
        int n = this.getCaretPosition();
        int n2 = this.getColumns();
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (string != null && string.length() > 0) {
            int n3;
            char c;
            if (this.akceptChars != null && n > 0 && this.akceptChars.indexOf(c = this.getText().charAt(n - 1)) < 0) {
                if (n >= string.length()) {
                    stringBuffer.append(string.substring(0, n - 1));
                } else {
                    stringBuffer.append(string.substring(0, n - 1));
                    stringBuffer.append(string.substring(n));
                }
                string = stringBuffer.toString();
                --n;
                bl = true;
            }
            if (this.replaceChars != null && n > 0 && (n3 = this.replaceChars.indexOf(c = this.getText().charAt(n - 1))) % 2 == 0) {
                if (n >= string.length()) {
                    stringBuffer.append(string.substring(0, n - 1));
                    stringBuffer.append(this.replaceChars.charAt(n3 + 1));
                } else {
                    stringBuffer.append(string.substring(0, n - 1));
                    stringBuffer.append(this.replaceChars.charAt(n3 + 1));
                    stringBuffer.append(string.substring(n));
                }
                string = stringBuffer.toString();
                bl = true;
            }
            if (this.absoluteLength && string.length() > n2) {
                if (n > n2) {
                    stringBuffer.append(string.substring(0, n - 1));
                } else {
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(string.substring(n + 1));
                }
                bl = true;
                --n;
            }
            if (bl) {
                this.setText(stringBuffer.toString());
                this.setCaretPosition(n);
            }
        }
        super.processTextEvent(textEvent);
    }

    protected void formatText() {
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.autoMark && this.isEditable()) {
            if (focusEvent.getID() == 1004) {
                if (this.getText() != null) {
                    this.selectAll();
                }
            } else if (focusEvent.getID() == 1005) {
                this.formatText();
                if (this.getText() != null) {
                    this.select(0, 0);
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }
}

