/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IButton;
import de.geocalc.awt.ICheckboxButton;
import de.geocalc.awt.ICheckboxButtonGroup;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class IToolBar
extends Panel
implements ActionListener,
KeyListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LAYOUT_FLOW = 0;
    public static final int LAYOUT_FIX = 1;
    private static final int HDIST = 2;
    private static final int VDIST = 2;
    protected ActionListener actionListener;
    protected KeyListener keyListener;
    private int orientation;
    private int layout;
    private boolean delimLine;
    Insets insets = new Insets(2, 0, 3, 3);

    public IToolBar() {
        this(0, 0, true);
    }

    public IToolBar(int n) {
        this(n, 0, true);
    }

    public IToolBar(int n, int n2, boolean bl) {
        this.orientation = n;
        this.layout = n2;
        this.delimLine = bl;
        this.setLayout(new FlowLayout(0, 2, 2));
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension();
        Dimension dimension2 = null;
        Component[] componentArray = this.getComponents();
        if (this.orientation == 0) {
            Dimension dimension3 = new Dimension();
            dimension2 = this.getParent().getSize();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension4 = componentArray[i].getPreferredSize();
                if (this.layout == 1 || dimension2.width == 0 || dimension3.width + dimension4.width + 2 < dimension2.width) {
                    dimension3.width += dimension4.width + 2;
                    dimension3.height = Math.max(dimension3.height, dimension4.height + 2);
                    continue;
                }
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height += dimension3.height;
                dimension3.width = dimension4.width + 2;
                dimension3.height = dimension4.height + 2;
            }
            dimension.width = Math.max(dimension.width, dimension3.width) + insets.left + insets.right;
            dimension.height += dimension3.height + insets.top + insets.bottom;
        } else {
            Dimension dimension5 = new Dimension();
            dimension2 = this.getSize();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension6 = componentArray[i].getPreferredSize();
                if (this.layout == 1 || dimension5.height + dimension6.height + 2 < dimension2.height) {
                    dimension5.height += dimension6.height + 2;
                    dimension5.width = Math.max(dimension5.width, dimension6.width + 2);
                    continue;
                }
                dimension.width += dimension5.width;
                dimension.height = Math.max(dimension.height, dimension5.height);
                dimension5.width = dimension6.width + 2;
                dimension5.height = dimension6.height + 2;
            }
            dimension.width += dimension5.width + insets.left + insets.right;
            dimension.height = Math.max(dimension.height, dimension5.height) + insets.top + insets.bottom;
        }
        return dimension;
    }

    public int getButtonCount() {
        return this.getComponentCount();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.delimLine) {
            graphics.draw3DRect(0, 0, this.getSize().width, 1, false);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            this.keyListener.keyTyped(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            this.keyListener.keyReleased(keyEvent);
        }
    }

    protected IButton createIButton(int n, String string) {
        IButton iButton = new IButton(n, string);
        iButton.addActionListener(this);
        iButton.addKeyListener(this);
        iButton.setToolTipText(string);
        return iButton;
    }

    protected IButton createIButton(String string, String string2) {
        IButton iButton = new IButton(string, string2);
        iButton.addActionListener(this);
        iButton.addKeyListener(this);
        iButton.setToolTipText(string2);
        return iButton;
    }

    protected ICheckboxButton createICheckboxButton(int n, String string, boolean bl) {
        ICheckboxButton iCheckboxButton = new ICheckboxButton(n, string);
        iCheckboxButton.addActionListener(this);
        iCheckboxButton.addKeyListener(this);
        iCheckboxButton.setState(bl);
        iCheckboxButton.setToolTipText(string);
        return iCheckboxButton;
    }

    protected ICheckboxButton createICheckboxButton(int n, String string, ICheckboxButtonGroup iCheckboxButtonGroup) {
        ICheckboxButton iCheckboxButton = new ICheckboxButton(n, string, iCheckboxButtonGroup);
        iCheckboxButton.addActionListener(this);
        iCheckboxButton.addKeyListener(this);
        iCheckboxButton.setToolTipText(string);
        return iCheckboxButton;
    }

    protected ICheckboxButton createICheckboxButton(String string, String string2, ICheckboxButtonGroup iCheckboxButtonGroup) {
        ICheckboxButton iCheckboxButton = new ICheckboxButton(string, string2, iCheckboxButtonGroup);
        iCheckboxButton.addActionListener(this);
        iCheckboxButton.addKeyListener(this);
        iCheckboxButton.setToolTipText(string2);
        return iCheckboxButton;
    }
}

