/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Window;

public class IToolTip
extends Window {
    private String toolTipText;

    public IToolTip(Frame frame) {
        super(frame);
        this.setBackground(SystemColor.info);
        this.setForeground(SystemColor.infoText);
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), 12);
        this.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.setSize(fontMetrics.stringWidth(string) + 4, fontMetrics.getHeight() + 4);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(SystemColor.infoText);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics.drawString(this.toolTipText, 2, this.getSize().height - 5);
    }
}

