/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ICanvas;
import de.geocalc.awt.IComponent;
import de.geocalc.awt.ITimer;
import de.geocalc.awt.IToolTip;
import de.geocalc.awt.event.ITimerEvent;
import de.geocalc.awt.event.ITimerListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class IToolTipManager
implements MouseListener,
ITimerListener {
    private boolean enabled = true;
    private Component insideComponent;
    private IToolTip toolTip;
    private String toolTipText;
    private ITimer enterTimer;
    private ITimer exitTimer;
    private Frame parent;
    private Point frameCenter;
    private boolean tipVisible = false;
    private int ENTER_TIME = 2000;
    private int EXIT_TIME = 500;

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setParent(Frame frame) {
        this.parent = frame;
        this.toolTip = new IToolTip(frame);
        this.toolTip.addMouseListener(this);
        this.enterTimer = new ITimer();
        this.exitTimer = new ITimer();
    }

    public void unregisterComponent(Component component) {
        component.removeMouseListener(this);
    }

    public void registerComponent(Component component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Serializable serializable;
        Component component;
        if (!this.isEnabled()) {
            return;
        }
        this.tipVisible = true;
        if (!this.enterTimer.isAlive()) {
            this.enterTimer = new ITimer(this.ENTER_TIME);
            this.enterTimer.addTimerListener(this);
            this.enterTimer.start();
        }
        if ((component = (Component)mouseEvent.getSource()) instanceof ICanvas) {
            serializable = (ICanvas)component;
            this.toolTip.setToolTipText(serializable.getToolTipText());
            this.insideComponent = serializable;
        } else {
            serializable = this.getToolTipComponent((Component)mouseEvent.getSource());
            if (serializable != null && serializable != this.insideComponent) {
                this.toolTip.setToolTipText(((IComponent)serializable).getToolTipText());
                this.insideComponent = serializable;
            }
        }
        serializable = new Point(this.parent.getLocationOnScreen().x + this.parent.getSize().width / 2, this.parent.getLocationOnScreen().y + this.parent.getSize().height / 2);
        Point point = this.insideComponent.getLocationOnScreen();
        Dimension dimension = this.insideComponent.getSize();
        Dimension dimension2 = this.toolTip.getSize();
        Point point2 = new Point(point);
        point2.x = point.x - ((Point)serializable).x > 0 ? (point2.x -= dimension2.width) : (point2.x += dimension.width);
        point2.y = point.y - ((Point)serializable).y > 0 ? (point2.y -= dimension2.height) : (point2.y += dimension.height);
        this.toolTip.setLocation(point2);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.tipVisible = false;
        if (!this.exitTimer.isAlive()) {
            this.exitTimer = new ITimer(this.EXIT_TIME);
            this.exitTimer.addTimerListener(this);
            this.exitTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void timePerformed(ITimerEvent iTimerEvent) {
        if (!this.isEnabled()) {
            return;
        }
        ITimer iTimer = (ITimer)iTimerEvent.getSource();
        if (iTimerEvent.getID() == 1002) {
            if (iTimer.equals(this.enterTimer)) {
                if (this.tipVisible) {
                    this.toolTip.show();
                }
            } else if (iTimer.equals(this.exitTimer) && !this.tipVisible) {
                this.toolTip.setVisible(false);
            }
        }
    }

    private IComponent getToolTipComponent(Component component) {
        if (component instanceof IComponent && ((IComponent)component).getToolTipText() != null) {
            return (IComponent)component;
        }
        Container container = component.getParent();
        while (!(container instanceof IComponent) || ((IComponent)container).getToolTipText() == null) {
            try {
                container = container.getParent();
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return (IComponent)container;
    }
}

