/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import java.awt.Point;

public class IViewport
extends DRectangle {
    private Point ul;
    private Point ur;
    private Point ol;
    private Point or;
    private double scale;
    private double scaleSqr;
    private double minGeomSize;
    private boolean scaleOpt = true;

    public IViewport(double d, double d2, double d3, double d4, Point point, Point point2, Point point3, Point point4, double d5, double d6) {
        super(d, d2, d3, d4);
        this.ul = point;
        this.ur = point2;
        this.ol = point3;
        this.or = point4;
        this.scale = d5;
        this.scaleSqr = d5 * d5;
        this.minGeomSize = d6;
        this.scaleOpt = d6 > 0.0;
    }

    public void setMinGeomSize(double d) {
        this.minGeomSize = d;
        this.scaleOpt = d > 0.0;
    }

    public Point getUL() {
        return this.ul;
    }

    public Point getUR() {
        return this.ur;
    }

    public Point getOL() {
        return this.ol;
    }

    public Point getOR() {
        return this.or;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.y, this.x, this.width, this.height);
    }

    @Override
    public boolean intersects(DRectangle dRectangle) {
        if (super.intersects(dRectangle)) {
            return this.scaleOpt && dRectangle.width != 0.0 && dRectangle.height != 0.0 ? dRectangle.width * dRectangle.height * this.scaleSqr > this.minGeomSize : true;
        }
        return false;
    }

    @Override
    public boolean contains(double d, double d2) {
        return d >= this.y && d2 >= this.x && d <= this.y + this.width && d2 <= this.x + this.height;
    }

    public DLine intersectLine(DPoint dPoint, DPoint dPoint2) {
        return this.intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
    }

    public DLine intersectLine(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        while (((n2 = this.outcode(d, d2)) & (n = this.outcode(d3, d4))) == 0) {
            double d5;
            if (n2 == 0 && n == 0) {
                return new DLine(d, d2, d3, d4);
            }
            if ((n2 & 5) != 0) {
                d5 = this.y;
                if ((n2 & 4) != 0) {
                    d5 += this.width;
                }
                if (d == d3) {
                    return null;
                }
                d2 += (d5 - d) * (d4 - d2) / (d3 - d);
                d = d5;
            } else if ((n2 & 0xA) != 0) {
                d5 = this.x;
                if ((n2 & 2) != 0) {
                    d5 += this.height;
                }
                if (d2 == d4) {
                    return null;
                }
                d += (d5 - d2) * (d3 - d) / (d4 - d2);
                d2 = d5;
            }
            if ((n & 5) != 0) {
                d5 = this.y;
                if ((n & 4) != 0) {
                    d5 += this.width;
                }
                if (d == d3) {
                    return null;
                }
                d4 += (d5 - d3) * (d2 - d4) / (d - d3);
                d3 = d5;
                continue;
            }
            if ((n & 0xA) == 0) continue;
            d5 = this.x;
            if ((n & 2) != 0) {
                d5 += this.height;
            }
            if (d2 == d4) {
                return null;
            }
            d3 += (d5 - d4) * (d - d3) / (d2 - d4);
            d4 = d5;
        }
        return null;
    }
}

