/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class Konsole
extends IDialog
implements ActionListener {
    public static final String TITLE = "Konsole";
    private static final String OK_COMMAND = "Ok";
    private static TextArea textArea = null;
    private static final Vector elements = new Vector();
    private static final int MAX_ELEMENTS = 100;
    private static final GregorianCalendar calendar = new GregorianCalendar();
    private static boolean isVisible = false;

    public Konsole(IFrame iFrame) {
        super(iFrame, TITLE, false);
        this.setResizable(true);
        calendar.setTimeZone(TimeZone.getTimeZone("ECT"));
        this.setLayout(new BorderLayout());
        textArea = new TextArea();
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        this.add("Center", textArea);
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        this.add("South", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    @Override
    protected void endDialog() {
        this.setVisible(false);
    }

    public static void addElement(String string) {
        if (elements.size() >= 100) {
            elements.removeElementAt(0);
        }
        elements.addElement(string);
    }

    public static void addElement(Object object, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            stringBuffer.append("*** ");
            stringBuffer.append(object.getClass().getName());
            stringBuffer.append(" --- ");
            stringBuffer.append(calendar.get(10));
            stringBuffer.append(":");
            stringBuffer.append(calendar.get(12));
            stringBuffer.append(":");
            stringBuffer.append(calendar.get(13));
            stringBuffer.append(" ***\n");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(string);
        }
        if (elements.size() >= 100) {
            elements.removeElementAt(0);
        }
        elements.addElement(stringBuffer.toString());
    }

    public static void showElements() {
        textArea.setText("");
        for (int i = 0; i < elements.size(); ++i) {
            textArea.append((String)elements.elementAt(i) + "\n");
        }
    }

    public static void clear() {
        elements.clear();
        textArea.setText("");
    }

    @Override
    public void setVisible(boolean bl) {
        isVisible = bl;
        super.setVisible(bl);
    }
}

