/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TextDialog
extends IDialog
implements ActionListener {
    public static final String TITLE = "TextDialog";
    public static final String VERSION = "1.0.0";
    private static final String OK_COMMAND = "ok";
    private static final String DIALOG_TITLE = "Text";
    private TextArea textArea;

    public TextDialog(IFrame iFrame) {
        this(iFrame, DIALOG_TITLE, null);
    }

    public TextDialog(IFrame iFrame, String string) {
        this(iFrame, string, null);
    }

    public TextDialog(IFrame iFrame, String string, String string2) {
        super(iFrame, string, true);
        CardLayout cardLayout = new CardLayout(5, 5);
        IPanel iPanel = new IPanel(cardLayout);
        this.textArea = new TextArea(20, 50);
        if (string2 != null) {
            this.textArea.setText(string2);
        }
        iPanel.add("P1", this.textArea);
        this.add("North", iPanel);
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button("OK");
        button.setActionCommand(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        this.add("South", panel);
        this.pack();
        this.setResizable(false);
        this.setLocationOfParent(iFrame);
    }

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void appendText(String string) {
        this.textArea.append(string);
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

