/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt.image;

import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private static final int BYTE = 256;
    private int alpha;
    private int bright;
    private int contrast;
    private int[] alphaTable;
    private int[] brightTable;
    private int[] contrastTable;
    private boolean alphaAlternate = false;

    public ColorFilter(int n, int n2, int n3, boolean bl) {
        int n4;
        this.alpha = n;
        this.bright = n2;
        this.contrast = n3;
        this.alphaAlternate = bl;
        if (bl) {
            this.alpha = 255 - 255 * (n + 100) / 200;
        } else if (n != 0) {
            int n5 = -255 * n / 100;
            this.alphaTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                n4 = i + n5;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
                this.alphaTable[i] = n4;
            }
        }
        if (n2 != 0) {
            double d = 1.0 - (double)Math.abs(n2) / 100.0;
            if (n2 < 0) {
                d = 1.0 / d;
            }
            this.brightTable = new int[256];
            for (n4 = 0; n4 < 256; ++n4) {
                int n6 = (int)(255.0 * Math.pow((double)n4 / 255.0, d) + 0.5);
                if (n6 > 255) {
                    n6 = 255;
                }
                this.brightTable[n4] = n6;
            }
        }
        if (n3 != 0) {
            double d = 1.0 - (double)Math.abs(n3) / 100.0;
            if (n3 < 0) {
                d = 1.0 / d;
            }
            this.contrastTable = new int[256];
            for (n4 = 1; n4 < 129; ++n4) {
                double d2 = 127.5 * Math.pow((double)n4 / 127.5, d);
                this.contrastTable[127 + n4] = Math.min((int)Math.rint(127.5 + d2), 255);
                this.contrastTable[128 - n4] = Math.max((int)Math.rint(127.5 - d2), 0);
            }
        }
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        if (this.bright != 0) {
            n5 = this.brightTable[n5];
            n6 = this.brightTable[n6];
            n7 = this.brightTable[n7];
        }
        if (this.contrast != 0) {
            n5 = this.contrastTable[n5];
            n6 = this.contrastTable[n6];
            n7 = this.contrastTable[n7];
        }
        if (this.alphaAlternate) {
            if (n5 >= this.alpha && n6 >= this.alpha && n7 >= this.alpha) {
                n4 = 0;
            }
        } else if (this.alpha != 0) {
            n4 = this.alphaTable[n4];
        }
        return n4 << 24 | n5 << 16 | n6 << 8 | n7;
    }
}

