/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt.image;

import de.geocalc.awt.image.RGBFilter;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public abstract class RGBAllFilter
extends RGBFilter {
    private int width = -1;
    private int height = -1;
    private int[][] rgbPixels = null;

    public RGBAllFilter(ImageProducer imageProducer) {
        super(imageProducer);
    }

    public abstract void filterRGBAll(int var1, int var2, int[][] var3);

    public synchronized void setPixels(int n, int n2, int[][] nArray) {
        this.consumer.setDimensions(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.consumer.setPixels(0, i, n, 1, rgbModel, nArray[i], 0, n);
        }
    }

    public synchronized void setPixels(int n, int n2, byte[][] byArray) {
        this.consumer.setDimensions(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.consumer.setPixels(0, i, n, 1, rgbModel, byArray[i], 0, n);
        }
    }

    @Override
    public synchronized void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(rgbModel);
    }

    @Override
    public synchronized void setDimensions(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.rgbPixels = new int[n2][n];
    }

    @Override
    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        for (int i = 0; i < n4; ++i) {
            int n7 = i * n6 + n5;
            for (int j = 0; j < n3; ++j) {
                this.rgbPixels[n2 + i][n + j] = colorModel.getRGB(byArray[n7 + j] & 0xFF);
            }
        }
    }

    @Override
    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        for (int i = 0; i < n4; ++i) {
            int n7 = i * n6 + n5;
            if (colorModel == rgbModel) {
                System.arraycopy(nArray, n7, this.rgbPixels[n2 + i], n, n3);
                continue;
            }
            for (int j = 0; j < n3; ++j) {
                this.rgbPixels[n2 + i][n + j] = colorModel.getRGB(nArray[n7 + j]);
            }
        }
    }

    @Override
    public synchronized void imageComplete(int n) {
        if (n == 1 || n == 4) {
            super.imageComplete(n);
            return;
        }
        this.filterRGBAll(this.width, this.height, this.rgbPixels);
        super.imageComplete(n);
    }
}

