/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.Transform;
import java.awt.Point;

public class BorderedGeoTransform
extends Transform {
    private double vx = 0.0;
    private double vy = 0.0;
    private double ox = 0.0;
    private double oy = 0.0;
    private double phi = 0.0;
    private double m = 1.0;
    private double r = 30000.0;
    private double msPhi;
    private double mcPhi;
    private double imsPhi;
    private double imcPhi;
    private double dx;
    private double dy;

    public BorderedGeoTransform() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public BorderedGeoTransform(double d, double d2, double d3, double d4) {
        this.vy = d;
        this.vx = d2;
        this.phi = this.getReduzedRotation(d3);
        this.m = d4;
        this.computeParam();
    }

    public void setOffset(double d, double d2) {
        this.oy = d;
        this.ox = d2;
    }

    private void computeParam() {
        this.msPhi = Math.sin(-this.phi) * this.m;
        this.mcPhi = Math.cos(-this.phi) * this.m;
        this.imsPhi = Math.sin(-this.phi) / this.m;
        this.imcPhi = Math.cos(-this.phi) / this.m;
    }

    public void setTranslation(double d, double d2) {
        this.vx = d2;
        this.vy = d;
        this.computeParam();
    }

    public double getXTranslation() {
        return this.vx;
    }

    public double getYTranslation() {
        return this.vy;
    }

    public void setRotation(double d) {
        this.phi = this.getReduzedRotation(d);
        this.computeParam();
    }

    private double getReduzedRotation(double d) {
        while (d < -Math.PI) {
            d += Math.PI;
        }
        while (d > Math.PI) {
            d -= Math.PI;
        }
        return d;
    }

    @Override
    public double getRotation() {
        return this.phi;
    }

    public void setScale(double d) {
        this.m = d;
        this.computeParam();
    }

    @Override
    public double getScale() {
        return this.m;
    }

    @Override
    public Point transform(DPoint dPoint, Point point) {
        this.dy = dPoint.y + this.vy;
        this.dx = dPoint.x + this.vx;
        double d = this.msPhi * this.dy + this.mcPhi * this.dx;
        double d2 = this.mcPhi * this.dy - this.msPhi * this.dx;
        double d3 = this.r / Math.sqrt(d2 * d2 + d * d + this.r * this.r);
        point.y = (int)Math.rint(this.oy - d * d3);
        point.x = (int)Math.rint(this.ox + d2 * d3);
        return point;
    }

    @Override
    public Point transform(double d, double d2, Point point) {
        this.dy = d + this.vy;
        this.dx = d2 + this.vx;
        double d3 = this.msPhi * this.dy + this.mcPhi * this.dx;
        double d4 = this.mcPhi * this.dy - this.msPhi * this.dx;
        double d5 = this.r / Math.sqrt(d4 * d4 + d3 * d3 + this.r * this.r);
        point.y = (int)Math.rint(this.oy - d3 * d5);
        point.x = (int)Math.rint(this.ox + d4 * d5);
        return point;
    }

    @Override
    public Point transform(double d, double d2) {
        this.dy = d + this.vy;
        this.dx = d2 + this.vx;
        double d3 = this.msPhi * this.dy + this.mcPhi * this.dx;
        double d4 = this.mcPhi * this.dy - this.msPhi * this.dx;
        double d5 = this.r / Math.sqrt(d4 * d4 + d3 * d3 + this.r * this.r);
        return new Point((int)Math.rint(this.ox + d4 * d5), (int)Math.rint(this.oy - d3 * d5));
    }

    @Override
    public Point transform(DPoint dPoint) {
        this.dy = dPoint.y + this.vy;
        this.dx = dPoint.x + this.vx;
        double d = this.msPhi * this.dy + this.mcPhi * this.dx;
        double d2 = this.mcPhi * this.dy - this.msPhi * this.dx;
        double d3 = this.r / Math.sqrt(d2 * d2 + d * d + this.r * this.r);
        return new Point((int)Math.rint(this.ox + d2 * d3), (int)Math.rint(this.oy - d * d3));
    }

    @Override
    public DPoint inverse(Point point, DPoint dPoint) {
        this.dy = (double)(-point.y) + this.oy;
        this.dx = (double)point.x - this.ox;
        dPoint.x = this.imcPhi * this.dy - this.imsPhi * this.dx - this.vx;
        dPoint.y = this.imsPhi * this.dy + this.imcPhi * this.dx - this.vy;
        return dPoint;
    }

    public String toString() {
        return this.getClass().getName() + "\nvx=" + this.vx + "\nvy=" + this.vy + "\nox=" + this.ox + "\noy=" + this.oy + "\nphi=" + this.phi + "\nm=" + this.m + "\nr=" + this.r;
    }
}

