/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;

public class DArc
extends DLine
implements GeomElement {
    public double r;

    public DArc() {
        this(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public DArc(DPoint dPoint, DPoint dPoint2, double d) {
        this(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, d);
    }

    public DArc(DArc dArc) {
        this(dArc.ya, dArc.xa, dArc.ye, dArc.xe, dArc.r);
    }

    public DArc(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d4);
        this.r = d5;
    }

    @Override
    public double getLength() {
        return this.getAngle() * Math.abs(this.r);
    }

    @Override
    public DPoint getPointAt(double d) {
        DPolygon dPolygon = new DPolygon(3);
        double d2 = this.getAngle();
        double d3 = Math.abs(this.r);
        dPolygon.addPoint(0.0, d3);
        dPolygon.addPoint(d3 * Math.sin(d / d3) * (this.r < 0.0 ? -1.0 : 1.0), d3 * Math.cos(d / d3));
        dPolygon.addPoint(d3 * Math.sin(d2) * (this.r < 0.0 ? -1.0 : 1.0), d3 * Math.cos(d2));
        dPolygon.transform(this.ya, this.xa, this.ye, this.xe);
        return new DPoint(dPolygon.ypoints[1], dPolygon.xpoints[1]);
    }

    @Override
    public double getOrientationAt(double d) {
        DPolygon dPolygon = new DPolygon(4);
        double d2 = this.getAngle();
        double d3 = Math.abs(this.r);
        dPolygon.addPoint(0.0, d3);
        dPolygon.addPoint(0.0, 0.0);
        dPolygon.addPoint(d3 * Math.sin(d / d3) * (this.r < 0.0 ? -1.0 : 1.0), d3 * Math.cos(d / d3));
        dPolygon.addPoint(d3 * Math.sin(d2) * (this.r < 0.0 ? -1.0 : 1.0), d3 * Math.cos(d2));
        dPolygon.transform(this.ya, this.xa, this.ye, this.xe);
        return Math.atan2(dPolygon.ypoints[2] - dPolygon.ypoints[1], dPolygon.xpoints[2] - dPolygon.xpoints[1]) + (this.r < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
    }

    public double getAngle() {
        return 2.0 * Math.asin(super.getLength() / (2.0 * Math.abs(this.r)));
    }

    public DPolygon getPolygon() {
        double d;
        double d2;
        DPolygon dPolygon = new DPolygon();
        double d3 = this.getAngle();
        double d4 = DArc.arcLenOfPrecision(this.r) / Math.abs(this.r);
        double d5 = 0.0;
        double d6 = Math.abs(this.r);
        do {
            d2 = d6 * Math.sin(d5);
            d = d6 * Math.cos(d5);
            if (this.r < 0.0) {
                d2 = -d2;
            }
            dPolygon.addPoint(d2, d);
        } while ((d5 += d4) < d3);
        d2 = d6 * Math.sin(d3);
        d = d6 * Math.cos(d3);
        if (this.r < 0.0) {
            d2 = -d2;
        }
        dPolygon.addPoint(d2, d);
        dPolygon.transform(this.ya, this.xa, this.ye, this.xe);
        return dPolygon;
    }

    @Override
    public DRectangle getBounds() {
        return DArc.getBounds(this.ya, this.xa, this.ye, this.xe, this.r);
    }

    public static DRectangle getBounds(double d, double d2, double d3, double d4, double d5) {
        DPoint dPoint = DArc.getCenter(d, d2, d3, d4, d5);
        double d6 = DLine.getOrientation(dPoint.y, dPoint.x, d, d2);
        double d7 = DLine.getOrientation(dPoint.y, dPoint.x, d3, d4);
        double d8 = Math.min(d2, d4);
        double d9 = Math.min(d, d3);
        double d10 = Math.max(d2, d4);
        double d11 = Math.max(d, d3);
        if (d5 < 0.0) {
            double d12 = d6;
            d6 = d7;
            d7 = d12;
            d5 = -d5;
        }
        if (d6 < -1.5707963267948966) {
            if (d7 > -1.5707963267948966) {
                d9 = dPoint.y - d5;
            }
            if (d7 > 0.0) {
                d10 = dPoint.x + d5;
            }
        } else if (d6 < 0.0) {
            if (d7 > 0.0) {
                d10 = dPoint.x + d5;
            }
            if (d7 > 1.5707963267948966) {
                d11 = dPoint.y + d5;
            }
        } else if (d6 < 1.5707963267948966) {
            if (d7 > 1.5707963267948966) {
                d11 = dPoint.y + d5;
            }
            if (d7 < -1.5707963267948966) {
                d8 = dPoint.x - d5;
            }
        } else if (d7 < -1.5707963267948966) {
            d8 = dPoint.x - d5;
        } else if (d7 < 0.0) {
            d9 = dPoint.y - d5;
        }
        return new DRectangle(d9, d8, d11 - d9, d10 - d8);
    }

    public static DPoint getCenter(double d, double d2, double d3, double d4, double d5) {
        double d6 = DLine.getDist(d, d2, d3, d4);
        double d7 = d6 / 2.0;
        double d8 = Math.sqrt(d5 * d5 - d7 * d7);
        if (d5 > 0.0) {
            return new DPoint(d + (d3 - d) / d6 * d7 + (d4 - d2) / d6 * d8, d2 + (d4 - d2) / d6 * d7 - (d3 - d) / d6 * d8);
        }
        if (d5 < 0.0) {
            return new DPoint(d3 + (d - d3) / d6 * d7 + (d2 - d4) / d6 * d8, d4 + (d2 - d4) / d6 * d7 - (d - d3) / d6 * d8);
        }
        return new DPoint((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public static void getSysSect(DPoint dPoint, DPoint dPoint2, DPoint dPoint3, double d, DPoint dPoint4, DPoint dPoint5) {
        double d2 = dPoint.y - dPoint2.y;
        double d3 = dPoint.x - dPoint2.x;
        double d4 = Math.atan2(dPoint3.y - dPoint2.y, dPoint3.x - dPoint2.x);
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = d3 * d5 - d2 * d6;
        double d8 = d3 * d6 + d2 * d5;
        double d9 = d * d - d7 * d7;
        if (d9 < 0.0) {
            return;
        }
        double d10 = d8 - Math.sqrt(d9);
        double d11 = d8 + Math.sqrt(d9);
        dPoint4.y = dPoint2.y + d10 * d5;
        dPoint4.x = dPoint2.x + d10 * d6;
        dPoint5.y = dPoint2.y + d11 * d5;
        dPoint5.x = dPoint2.x + d11 * d6;
    }

    public static boolean containsAngle(double d, double d2, double d3) {
        if (d2 > d3) {
            return (d >= 0.0 ? d > d2 : d + Math.PI * 2 > d2) && (d < 0.0 ? d < d3 : d - Math.PI * 2 < d3);
        }
        return d > d2 && d < d3;
    }

    public static double getRadiusFrom3Points(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = DLine.getDist(dPoint.y, dPoint.x, dPoint3.y, dPoint3.x);
        double d2 = DLine.getDistance(dPoint.y, dPoint.x, dPoint3.y, dPoint3.x, dPoint2.y, dPoint2.x);
        return (d * d + 4.0 * d2 * d2) / (8.0 * d2);
    }
}

