/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DLine
implements GeomElement {
    public double xa;
    public double ya;
    public double xe;
    public double ye;

    public DLine() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DLine(DPoint dPoint, DPoint dPoint2) {
        this(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
    }

    public DLine(DLine dLine) {
        this(dLine.ya, dLine.xa, dLine.ye, dLine.xe);
    }

    public DLine(double d, double d2, double d3, double d4) {
        this.ya = d;
        this.xa = d2;
        this.ye = d3;
        this.xe = d4;
    }

    public DPoint getP1() {
        return new DPoint(this.ya, this.xa);
    }

    public void setP1(DPoint dPoint) {
        this.ya = dPoint.y;
        this.xa = dPoint.x;
    }

    public DPoint getP2() {
        return new DPoint(this.ye, this.xe);
    }

    public void setP2(DPoint dPoint) {
        this.ye = dPoint.y;
        this.xe = dPoint.x;
    }

    public DPoint getStartLocation() {
        return new DPoint(this.ya, this.xa);
    }

    public void setStartLocation(DPoint dPoint) {
        this.ya = dPoint.y;
        this.xa = dPoint.x;
    }

    public DPoint getEndLocation() {
        return new DPoint(this.ye, this.xe);
    }

    public void setEndLocation(DPoint dPoint) {
        this.ye = dPoint.y;
        this.xe = dPoint.x;
    }

    public void setLocation(double d, double d2, double d3, double d4) {
        this.ya = d;
        this.xa = d2;
        this.ye = d3;
        this.xe = d4;
    }

    @Override
    public double getLength() {
        return Math.sqrt((this.ye - this.ya) * (this.ye - this.ya) + (this.xe - this.xa) * (this.xe - this.xa));
    }

    public DPoint getPointAt(double d) {
        double d2 = this.getOrientation();
        return new DPoint(this.ya + d * Math.sin(d2), this.xa + d * Math.cos(d2));
    }

    public double getOrientationAt(double d) {
        return this.getOrientation();
    }

    public double getOrientation() {
        return Math.atan2(this.ye - this.ya, this.xe - this.xa);
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(Math.min(this.ya, this.ye), Math.min(this.xa, this.xe), Math.abs(this.ya - this.ye), Math.abs(this.xa - this.xe));
    }

    @Override
    public Enumeration points() {
        return new Enumeration(){
            int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < 2;
            }

            public Object nextElement() {
                ++this.i;
                if (this.i == 1) {
                    return new DPoint(DLine.this.ya, DLine.this.xa);
                }
                if (this.i == 2) {
                    return new DPoint(DLine.this.ye, DLine.this.xe);
                }
                throw new NoSuchElementException("DLine Enumeration");
            }
        };
    }

    public String toString() {
        return new String("DLine: ya=" + this.ya + " xa=" + this.xa + " ye=" + this.ye + " xe=" + this.xe);
    }

    public static final double getInnerDistance(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint3.x - dPoint.x) - d2 * (dPoint3.y - dPoint.y);
        if (d4 < 0.0 || d4 * d4 > dPoint.getDistance2(dPoint2)) {
            return Double.NaN;
        }
        return d2 * (dPoint3.x - dPoint.x) + d3 * (dPoint3.y - dPoint.y);
    }

    public static final double getSegDistance(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint3.x - dPoint.x) - d2 * (dPoint3.y - dPoint.y);
        if (d4 < 0.0) {
            return DLine.getDist(dPoint.y, dPoint.x, dPoint3.y, dPoint3.x);
        }
        if (d4 * d4 > dPoint.getDistance2(dPoint2)) {
            return DLine.getDist(dPoint2.y, dPoint2.x, dPoint3.y, dPoint3.x);
        }
        return d2 * (dPoint3.x - dPoint.x) + d3 * (dPoint3.y - dPoint.y);
    }

    public static final DPoint getDistancePoint(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        return new DPoint(d2 * (dPoint3.x - dPoint.x) + d3 * (dPoint3.y - dPoint.y), d3 * (dPoint3.x - dPoint.x) - d2 * (dPoint3.y - dPoint.y));
    }

    public static final void moveIn(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint3.x - dPoint.x) - d2 * (dPoint3.y - dPoint.y);
        dPoint3.y = dPoint.y - d4 * d2;
        dPoint3.x = dPoint.x + d4 * d3;
    }

    public static final void setTo(DPoint dPoint, DPoint dPoint2, DPoint dPoint3, double d, double d2) {
        double d3 = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d4 = -Math.sin(d3);
        double d5 = Math.cos(d3);
        dPoint3.y = dPoint.y - d4 * d + d5 * d2;
        dPoint3.x = dPoint.x + d5 * d + d4 * d2;
    }

    public static final void moveInSeg(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        DLine.moveIn(dPoint, dPoint2, dPoint3);
        double d = DLine.getDistSq(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        double d2 = DLine.getDistSq(dPoint.y, dPoint.x, dPoint3.y, dPoint3.x);
        double d3 = DLine.getDistSq(dPoint2.y, dPoint2.x, dPoint3.y, dPoint3.x);
        if (d2 > d || d3 > d) {
            dPoint3.y = d2 < d3 ? dPoint.y : dPoint2.y;
            dPoint3.x = d2 < d3 ? dPoint.x : dPoint2.x;
        }
    }

    public static final double getDistance(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        return DLine.getDistance(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, dPoint3.y, dPoint3.x);
    }

    public static final double getDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.atan2(d3 - d, d4 - d2);
        double d8 = -Math.sin(d7);
        double d9 = Math.cos(d7);
        return d8 * (d6 - d2) + d9 * (d5 - d);
    }

    public static final boolean isInnerPoint(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        double d = Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d3 * (dPoint3.x - dPoint.x) - d2 * (dPoint3.y - dPoint.y);
        return d4 > 0.0 && d4 * d4 < dPoint.getDistance2(dPoint);
    }

    public static final double getAngle(DPoint dPoint, DPoint dPoint2) {
        return Math.atan2(dPoint2.y - dPoint.y, dPoint2.x - dPoint.x);
    }

    public static double getOrientation(double d, double d2, double d3, double d4) {
        return Math.atan2(d3 - d, d4 - d2);
    }

    public static double getDistSq(double d, double d2, double d3, double d4) {
        return (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
    }

    public static double getDist(double d, double d2, double d3, double d4) {
        return Math.sqrt(DLine.getDistSq(d, d2, d3, d4));
    }

    public static double ptLineDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d6 -= d2) * (d4 -= d2) + (d5 -= d) * (d3 -= d);
        double d8 = d7 * d7 / (d4 * d4 + d3 * d3);
        return d6 * d6 + d5 * d5 - d8;
    }

    public static double ptLineDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(DLine.ptLineDistSq(d, d2, d3, d4, d5, d6));
    }

    public static double ptSegDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d6 -= d2) * (d4 -= d2) + (d5 -= d) * (d3 -= d);
        if (d7 <= 0.0) {
            return Double.NaN;
        }
        d7 = (d6 = d4 - d6) * d4 + (d5 = d3 - d5) * d3;
        if (d7 <= 0.0) {
            return Double.NaN;
        }
        double d8 = d7 * d7 / (d4 * d4 + d3 * d3);
        return d6 * d6 + d5 * d5 - d8;
    }

    public static double ptSegDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(DLine.ptSegDistSq(d, d2, d3, d4, d5, d6));
    }

    public static double ptShortestDist(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = DLine.getDist(d, d2, d5, d6);
        double d8 = DLine.getDist(d3, d4, d5, d6);
        double d9 = DLine.ptSegDist(d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d9)) {
            return d7 < d8 ? d7 : d8;
        }
        return Math.abs(d9);
    }

    public static final DPoint getMidPoint(DPoint dPoint, DPoint dPoint2) {
        return new DPoint((dPoint.y + dPoint2.y) / 2.0, (dPoint.x + dPoint2.x) / 2.0);
    }

    public static final DPoint getIntersectPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = ((d8 - d2) * (d7 - d5) - (d8 - d6) * (d7 - d)) / ((d4 - d2) * (d7 - d5) - (d8 - d6) * (d3 - d));
        if (Double.isNaN(d9)) {
            return null;
        }
        return new DPoint(d + d9 * (d3 - d), d2 + d9 * (d4 - d2));
    }

    public static final DPoint getIntersectInPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        DPoint dPoint = DLine.getIntersectPoint(d, d2, d3, d4, d5, d6, d7, d8);
        if (dPoint != null) {
            if (DLine.getDist(d, d2, d3, d4) - DLine.getDist(d, d2, dPoint.y, dPoint.x) - DLine.getDist(d3, d4, dPoint.y, dPoint.x) < -1.0E-4) {
                return null;
            }
            if (DLine.getDist(d5, d6, d7, d8) - DLine.getDist(d5, d6, dPoint.y, dPoint.x) - DLine.getDist(d7, d8, dPoint.y, dPoint.x) < -1.0E-4) {
                return null;
            }
        }
        return dPoint;
    }

    public static double arcLenOfPrecision(double d) {
        d = Math.abs(d);
        return 2.0 * Math.acos(-0.001 / d + 1.0) * d;
    }

    public static double arcLenOfPrecision(double d, double d2) {
        d = Math.abs(d);
        return 2.0 * Math.acos(-Math.abs(d2) / d + 1.0) * d;
    }
}

