/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.Koordinate2D;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DPoint
implements GeomElement,
Koordinate2D {
    public double x;
    public double y;

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    public DPoint() {
        this(0.0, 0.0);
    }

    public DPoint(DPoint dPoint) {
        this(dPoint.y, dPoint.x);
    }

    public DPoint(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    public int hashCode() {
        long l = Math.round(this.y * 1000.0) + Math.round(this.y * 1000.0);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof DPoint) {
            DPoint dPoint = (DPoint)object;
            return Math.abs(dPoint.x - this.x) < 1.0E-4 && Math.abs(dPoint.y - this.y) < 1.0E-4;
        }
        return false;
    }

    public boolean isNull() {
        return this.y == 0.0 && this.x == 0.0;
    }

    public void setNull() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public DPoint getLocation() {
        return new DPoint(this.y, this.x);
    }

    public void setLocation(DPoint dPoint) {
        this.setLocation(dPoint.y, dPoint.x);
    }

    public void setLocation(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.y, this.x, 0.0, 0.0);
    }

    @Override
    public Enumeration points() {
        return new Enumeration(){
            boolean hasMore = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasMore;
            }

            public Object nextElement() {
                if (this.hasMore) {
                    this.hasMore = false;
                    return new DPoint(DPoint.this.y, DPoint.this.x);
                }
                throw new NoSuchElementException("DPoint Enumeration");
            }
        };
    }

    public final double getDistance(DPoint dPoint) {
        return Math.sqrt((this.y - dPoint.y) * (this.y - dPoint.y) + (this.x - dPoint.x) * (this.x - dPoint.x));
    }

    public final double getDistance(double d, double d2) {
        return Math.sqrt((this.y - d) * (this.y - d) + (this.x - d2) * (this.x - d2));
    }

    public final double getDistance2(DPoint dPoint) {
        return (this.y - dPoint.y) * (this.y - dPoint.y) + (this.x - dPoint.x) * (this.x - dPoint.x);
    }

    public double getOrientation(DPoint dPoint) {
        return Math.atan2(dPoint.y - this.y, dPoint.x - this.x);
    }

    public static double getOrientation(double d, double d2, double d3, double d4) {
        return Math.atan2(d3 - d, d4 - d2);
    }

    public double getAngle(DPoint dPoint, DPoint dPoint2) {
        double d = this.getOrientation(dPoint2) - this.getOrientation(dPoint);
        if (d < -Math.PI) {
            d += Math.PI;
        }
        if (d > Math.PI) {
            d -= Math.PI;
        }
        return d;
    }

    public static double getAngle(double d, double d2, double d3, double d4, double d5, double d6) {
        return DPoint.getOrientation(d3, d4, d, d2) - DPoint.getOrientation(d3, d4, d5, d6);
    }

    public DPoint round(int n) {
        return DPoint.round(this, n);
    }

    public static final DPoint getMiddle(DPoint dPoint, DPoint dPoint2) {
        return new DPoint((dPoint.y + dPoint2.y) / 2.0, (dPoint.x + dPoint2.x) / 2.0);
    }

    public static final double ptDistSq(DPoint dPoint, DPoint dPoint2) {
        return DPoint.ptDistSq(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
    }

    public static final double ptDistSq(double d, double d2, double d3, double d4) {
        return (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
    }

    public static final double ptDist(DPoint dPoint, DPoint dPoint2) {
        return DPoint.ptDist(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
    }

    public static final double ptDist(double d, double d2, double d3, double d4) {
        return Math.sqrt(DPoint.ptDistSq(d, d2, d3, d4));
    }

    public static final DPoint round(DPoint dPoint, int n) {
        if (dPoint == null) {
            return null;
        }
        double d = Math.pow(10.0, n);
        return new DPoint(Math.rint(dPoint.y * d) / d, Math.rint(dPoint.x * d) / d);
    }

    private static final double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return Math.rint(d * d2) / d2;
    }

    public String toString() {
        return new String("DPoint: y=" + this.y + " x=" + this.x);
    }
}

