/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.algorithm.Centroid;
import de.geocalc.text.IFormat;
import java.awt.geom.Path2D;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DPolygon
implements GeomElement {
    public int npoints = 0;
    public double[] xpoints = new double[4];
    public double[] ypoints = new double[4];
    protected DRectangle bounds = null;

    public DPolygon() {
    }

    public DPolygon(int n) {
        this.npoints = 0;
        this.ypoints = new double[n];
        this.xpoints = new double[n];
    }

    public DPolygon(double[] dArray, double[] dArray2, int n) {
        this.npoints = n;
        this.ypoints = new double[n];
        this.xpoints = new double[n];
        System.arraycopy(dArray, 0, this.ypoints, 0, n);
        System.arraycopy(dArray2, 0, this.xpoints, 0, n);
    }

    @Override
    public double getLength() {
        double d = 0.0;
        for (int i = 1; i < this.npoints; ++i) {
            d += DLine.getDist(this.ypoints[i], this.xpoints[i], this.ypoints[i - 1], this.xpoints[i - 1]);
        }
        return d;
    }

    public double[] interpolateZ(double d, double d2) {
        double[] dArray = new double[this.npoints];
        double d3 = d2 - d;
        double d4 = this.getLength();
        dArray[0] = d;
        dArray[this.npoints - 1] = d2;
        double d5 = 0.0;
        for (int i = 1; i < this.npoints - 1; ++i) {
            dArray[i] = d + d3 * (d5 += DLine.getDist(this.ypoints[i], this.xpoints[i], this.ypoints[i - 1], this.xpoints[i - 1])) / d4;
        }
        return dArray;
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.ypoints[n2] = this.ypoints[n2] + d;
            int n3 = n++;
            this.xpoints[n3] = this.xpoints[n3] + d2;
        }
        if (this.bounds != null) {
            this.bounds.translate(d, d2);
        }
    }

    public void transform(double d, double d2, double d3, double d4) {
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = this.xpoints[this.npoints - 1] - this.xpoints[0];
        double d8 = this.ypoints[this.npoints - 1] - this.ypoints[0];
        double d9 = d8 * d8 + d7 * d7;
        double d10 = (d7 * d6 - d8 * d5) / d9;
        double d11 = (d8 * d6 + d7 * d5) / d9;
        double d12 = this.ypoints[0];
        double d13 = this.xpoints[0];
        for (int i = 0; i < this.npoints; ++i) {
            double d14 = d + d10 * (this.xpoints[i] - d13) + d11 * (this.ypoints[i] - d12);
            double d15 = d2 + d11 * (this.xpoints[i] - d13) - d10 * (this.ypoints[i] - d12);
            this.ypoints[i] = d14;
            this.xpoints[i] = d15;
        }
        this.calculateBounds(this.ypoints, this.xpoints, this.npoints);
    }

    public void addPoint(DPoint dPoint) {
        this.addPoint(dPoint.y, dPoint.x);
    }

    public void addPoint(double d, double d2) {
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        this.xpoints[this.npoints] = d2;
        this.ypoints[this.npoints] = d;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(d, d2);
        }
    }

    public void insertPoint(double d, double d2, int n) {
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        System.arraycopy(this.xpoints, n, this.xpoints, n + 1, this.npoints - n);
        System.arraycopy(this.ypoints, n, this.ypoints, n + 1, this.npoints - n);
        this.ypoints[n] = d;
        this.xpoints[n] = d2;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(d, d2);
        }
    }

    public void setPointAt(DPoint dPoint, int n) {
        this.setPointAt(dPoint.y, dPoint.x, n);
    }

    public void setPointAt(double d, double d2, int n) {
        this.ypoints[n] = d;
        this.xpoints[n] = d2;
        this.npoints = Math.max(this.npoints, n + 1);
        if (this.bounds != null) {
            this.updateBounds(d, d2);
        }
    }

    public DPoint getPoint(int n) {
        return new DPoint(this.ypoints[n], this.xpoints[n]);
    }

    public void reverse() {
        this.skip();
    }

    public void skip() {
        int n = this.npoints / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.npoints - i - 1;
            double d = this.ypoints[n2];
            double d2 = this.xpoints[n2];
            this.ypoints[n2] = this.ypoints[i];
            this.xpoints[n2] = this.xpoints[i];
            this.ypoints[i] = d;
            this.xpoints[i] = d2;
        }
    }

    @Override
    public DRectangle getBounds() {
        if (this.bounds == null) {
            this.calculateBounds(this.ypoints, this.xpoints, this.npoints);
        }
        return this.bounds;
    }

    public DPolygon getBoundingBox() {
        if (this.bounds == null) {
            this.calculateBounds(this.ypoints, this.xpoints, this.npoints);
        }
        DPolygon dPolygon = new DPolygon(4);
        dPolygon.addPoint(this.bounds.y, this.bounds.x);
        dPolygon.addPoint(this.bounds.y, this.bounds.x + this.bounds.height);
        dPolygon.addPoint(this.bounds.y + this.bounds.width, this.bounds.x + this.bounds.height);
        dPolygon.addPoint(this.bounds.y + this.bounds.width, this.bounds.x);
        return dPolygon;
    }

    public DPolygon getRotatedBoundingBox() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        for (int i = 1; i < this.npoints; ++i) {
            double d7 = Math.atan2(this.ypoints[i] - this.ypoints[i - 1], this.xpoints[i] - this.xpoints[i - 1]);
            double d8 = Math.sin(d7);
            double d9 = Math.cos(d7);
            double d10 = Double.MAX_VALUE;
            double d11 = Double.MAX_VALUE;
            double d12 = -1.7976931348623157E308;
            double d13 = -1.7976931348623157E308;
            for (int j = 0; j < this.npoints; ++j) {
                double d14 = this.ypoints[j] - this.ypoints[0];
                double d15 = this.xpoints[j] - this.xpoints[0];
                double d16 = d14 * d9 - d15 * d8;
                double d17 = d14 * d8 + d15 * d9;
                d10 = Math.min(d16, d10);
                d11 = Math.min(d17, d11);
                d12 = Math.max(d16, d12);
                d13 = Math.max(d17, d13);
            }
            double d18 = (d12 - d10) * (d13 - d11);
            if (!(d18 < d6)) continue;
            d6 = d18;
            d = d7;
            d2 = d10;
            d3 = d11;
            d4 = d12;
            d5 = d13;
        }
        double d19 = Math.sin(-d);
        double d20 = Math.cos(-d);
        DPolygon dPolygon = new DPolygon(4);
        dPolygon.addPoint(this.ypoints[0] + d2 * d20 - d3 * d19, this.xpoints[0] + d2 * d19 + d3 * d20);
        dPolygon.addPoint(this.ypoints[0] + d2 * d20 - d5 * d19, this.xpoints[0] + d2 * d19 + d5 * d20);
        dPolygon.addPoint(this.ypoints[0] + d4 * d20 - d5 * d19, this.xpoints[0] + d4 * d19 + d5 * d20);
        dPolygon.addPoint(this.ypoints[0] + d4 * d20 - d3 * d19, this.xpoints[0] + d4 * d19 + d3 * d20);
        return dPolygon;
    }

    public DPoint getCentroid() {
        return new Centroid(this).getCentroid();
    }

    public DPoint getMidPoint() {
        return this.getPointAt(this.getLength() / 2.0);
    }

    public DPoint getPointAt(double d) {
        if (this.npoints == 0) {
            return new DPoint(this.ypoints[0], this.xpoints[0]);
        }
        DPoint dPoint = new DPoint();
        if (d < 0.0) {
            DLine.setTo(this.getPoint(0), this.getPoint(1), dPoint, d, 0.0);
        } else {
            double d2 = 0.0;
            for (int i = 1; i < this.npoints; ++i) {
                if (!((d2 += DPoint.ptDist(this.ypoints[i], this.xpoints[i], this.ypoints[i - 1], this.xpoints[i - 1])) > d)) continue;
                DLine.setTo(this.getPoint(i), this.getPoint(i - 1), dPoint, d2 - d, 0.0);
                break;
            }
            if (d > d2) {
                DLine.setTo(this.getPoint(this.npoints - 1), this.getPoint(this.npoints - 2), dPoint, d2 - d, 0.0);
            }
        }
        return dPoint;
    }

    @Override
    public Enumeration points() {
        return new Enumeration(){
            int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < DPolygon.this.npoints;
            }

            public Object nextElement() {
                if (this.i >= DPolygon.this.npoints) {
                    throw new NoSuchElementException("DPolygon Enumeration");
                }
                int n = this.i++;
                return new DPoint(DPolygon.this.ypoints[n], DPolygon.this.xpoints[n]);
            }
        };
    }

    public boolean contains(DPoint dPoint) {
        return this.contains(dPoint.y, dPoint.x);
    }

    public boolean contains(double d, double d2) {
        if (this.getBounds().contains(d, d2)) {
            int n;
            int n2 = 0;
            double d3 = 0.0;
            for (n = 0; n < this.npoints && this.ypoints[n] == d; ++n) {
            }
            for (int i = 0; i < this.npoints; ++i) {
                int n3 = (n + 1) % this.npoints;
                double d4 = this.xpoints[n3] - this.xpoints[n];
                double d5 = this.ypoints[n3] - this.ypoints[n];
                if (d5 != 0.0) {
                    double d6;
                    double d7 = d2 - this.xpoints[n];
                    double d8 = d - this.ypoints[n];
                    if (this.ypoints[n3] == d && this.xpoints[n3] >= d2) {
                        d3 = this.ypoints[n];
                    }
                    if (this.ypoints[n] == d && this.xpoints[n] >= d2 && d3 > d != this.ypoints[n3] > d) {
                        --n2;
                    }
                    if ((d6 = d8 / d5) >= 0.0 && d6 <= 1.0 && d6 * d4 >= d7) {
                        ++n2;
                    }
                }
                n = n3;
            }
            return n2 % 2 != 0;
        }
        return false;
    }

    public boolean contains(DPolygon dPolygon) {
        for (int i = 0; i < dPolygon.npoints; ++i) {
            if (this.contains(dPolygon.ypoints[i], dPolygon.xpoints[i])) continue;
            return false;
        }
        return true;
    }

    public int outcode(DPolygon dPolygon) {
        boolean bl;
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n = 0; n < dPolygon.npoints; ++n) {
            bl = this.contains(dPolygon.ypoints[n], dPolygon.xpoints[n]);
            if (bl) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        for (n = 0; n < this.npoints; ++n) {
            bl = dPolygon.contains(this.ypoints[n], this.xpoints[n]);
            if (bl) {
                bl4 = true;
                continue;
            }
            bl5 = true;
        }
        if (bl2 && bl3 || bl4 && bl5) {
            return 8;
        }
        if (bl2) {
            if (bl4) {
                return 8;
            }
            return 1;
        }
        if (bl3) {
            if (bl4) {
                return 4;
            }
            return 2;
        }
        return 0;
    }

    public double getArea() {
        if (this.npoints < 3) {
            return 0.0;
        }
        double d = this.ypoints[0] * (this.xpoints[this.npoints - 1] - this.xpoints[1]);
        for (int i = 1; i < this.npoints - 1; ++i) {
            d += this.ypoints[i] * (this.xpoints[i - 1] - this.xpoints[i + 1]);
        }
        return (d += this.ypoints[this.npoints - 1] * (this.xpoints[this.npoints - 2] - this.xpoints[0])) / 2.0;
    }

    public double getAngleSum() {
        if (this.npoints <= 2) {
            return 0.0;
        }
        double d = DPoint.getAngle(this.ypoints[this.npoints - 1], this.xpoints[this.npoints - 1], this.ypoints[0], this.xpoints[0], this.ypoints[1], this.xpoints[1]);
        if (d < 0.0) {
            d = Math.PI * 2 + d;
        }
        for (int i = 1; i < this.npoints - 1; ++i) {
            double d2 = DPoint.getAngle(this.ypoints[i - 1], this.xpoints[i - 1], this.ypoints[i], this.xpoints[i], this.ypoints[i + 1], this.xpoints[i + 1]);
            d += d2 < 0.0 ? Math.PI * 2 + d2 : d2;
        }
        double d3 = DPoint.getAngle(this.ypoints[this.npoints - 2], this.xpoints[this.npoints - 2], this.ypoints[this.npoints - 1], this.xpoints[this.npoints - 1], this.ypoints[0], this.xpoints[0]);
        return d += d3 < 0.0 ? Math.PI * 2 + d3 : d3;
    }

    public void setStartIndex(int n) {
        double[] dArray = new double[this.npoints];
        double[] dArray2 = new double[this.npoints];
        System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
        System.arraycopy(this.ypoints, 0, dArray2, 0, this.npoints);
        int n2 = 0;
        int n3 = n;
        while (n3 < this.npoints) {
            dArray[n2] = this.xpoints[n3];
            dArray2[n2] = this.ypoints[n3];
            ++n3;
            ++n2;
        }
        n3 = 1;
        while (n3 <= n) {
            dArray[n2] = this.xpoints[n3];
            dArray2[n2] = this.ypoints[n3];
            ++n3;
            ++n2;
        }
        this.xpoints = dArray;
        this.ypoints = dArray2;
    }

    private void calculateBounds(double[] dArray, double[] dArray2, int n) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            double d5 = dArray[i];
            d = Math.min(d, d5);
            d3 = Math.max(d3, d5);
            double d6 = dArray2[i];
            d2 = Math.min(d2, d6);
            d4 = Math.max(d4, d6);
        }
        this.bounds = new DRectangle(d, d2, d3 - d, d4 - d2);
    }

    private void updateBounds(double d, double d2) {
        double d3 = Math.max(d, this.bounds.y + this.bounds.width);
        double d4 = Math.max(d2, this.bounds.x + this.bounds.height);
        this.bounds.y = Math.min(this.bounds.y, d);
        this.bounds.width = d3 - this.bounds.y;
        this.bounds.x = Math.min(this.bounds.x, d2);
        this.bounds.height = d4 - this.bounds.x;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DPolygon: [");
        for (int i = 0; i < this.npoints; ++i) {
            stringBuffer.append("(");
            stringBuffer.append(IFormat.f_3.format(this.ypoints[i]));
            stringBuffer.append(",");
            stringBuffer.append(IFormat.f_3.format(this.xpoints[i]));
            stringBuffer.append("),");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public DPoint getCenter() {
        DRectangle dRectangle = this.getBounds();
        return new DPoint(dRectangle.y + dRectangle.width / 2.0, dRectangle.x + dRectangle.height / 2.0);
    }

    public Path2D.Double getPath() {
        if (this.npoints == 0) {
            return null;
        }
        Path2D.Double double_ = new Path2D.Double();
        double_.moveTo(this.ypoints[0], this.xpoints[0]);
        for (int i = 1; i < this.npoints; ++i) {
            double_.lineTo(this.ypoints[i], this.xpoints[i]);
        }
        return double_;
    }
}

