/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DRectangle
implements GeomElement {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public double x;
    public double y;
    public double width;
    public double height;

    public DRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DRectangle(DRectangle dRectangle) {
        this(dRectangle.y, dRectangle.x, dRectangle.width, dRectangle.height);
    }

    public DRectangle(double d, double d2, double d3, double d4) {
        this.y = d;
        this.x = d2;
        this.width = d3;
        this.height = d4;
    }

    @Override
    public double getLength() {
        return 2.0 * this.width + 2.0 * this.height;
    }

    @Override
    public DRectangle getBounds() {
        return new DRectangle(this.y, this.x, this.height, this.width);
    }

    @Override
    public Enumeration points() {
        return new Enumeration(){
            int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < 5;
            }

            public Object nextElement() {
                ++this.i;
                if (this.i == 1) {
                    return new DPoint(DRectangle.this.y, DRectangle.this.x);
                }
                if (this.i == 2) {
                    return new DPoint(DRectangle.this.y + DRectangle.this.width, DRectangle.this.x);
                }
                if (this.i == 3) {
                    return new DPoint(DRectangle.this.y + DRectangle.this.width, DRectangle.this.x + DRectangle.this.height);
                }
                if (this.i == 4) {
                    return new DPoint(DRectangle.this.y, DRectangle.this.x + DRectangle.this.height);
                }
                if (this.i == 5) {
                    return new DPoint(DRectangle.this.y, DRectangle.this.x);
                }
                throw new NoSuchElementException("DRectangle Enumeration");
            }
        };
    }

    public void setBounds(DRectangle dRectangle) {
        this.setBounds(dRectangle.y, dRectangle.x, dRectangle.width, dRectangle.height);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.y = d;
        this.x = d2;
        this.width = d3;
        this.height = d4;
    }

    public DPoint getLocation() {
        return new DPoint(this.y, this.x);
    }

    public void setLocation(DPoint dPoint) {
        this.setLocation(dPoint.y, dPoint.x);
    }

    public void setLocation(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    public void translate(double d, double d2) {
        this.setLocation(this.y + d, this.x + d2);
    }

    public DDimension getSize() {
        return new DDimension(this.width, this.height);
    }

    public void setSize(DDimension dDimension) {
        this.setSize(dDimension.width, dDimension.height);
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public boolean equals(Object object) {
        if (object instanceof DRectangle) {
            DRectangle dRectangle = (DRectangle)object;
            return this.y == dRectangle.y && this.x == dRectangle.x && this.width == dRectangle.width && this.height == dRectangle.height;
        }
        return false;
    }

    public boolean contains(DPoint dPoint) {
        return this.contains(dPoint.y, dPoint.x);
    }

    public boolean contains(double d, double d2) {
        return d >= this.y && d - this.y <= this.width && d2 >= this.x && d2 - this.x <= this.height;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return d2 >= this.x && d >= this.y && d2 + d4 <= this.x + this.height && d + d3 <= this.y + this.width;
    }

    public boolean contains(DRectangle dRectangle) {
        return this.contains(dRectangle.y, dRectangle.x, dRectangle.width, dRectangle.height);
    }

    public void add(double d, double d2) {
        double d3 = Math.max(this.y + this.width, d);
        double d4 = Math.max(this.x + this.height, d2);
        this.y = Math.min(this.y, d);
        this.x = Math.min(this.x, d2);
        this.width = d3 - this.y;
        this.height = d4 - this.x;
    }

    public void add(DPoint dPoint) {
        this.add(dPoint.y, dPoint.x);
    }

    public void add(DRectangle dRectangle) {
        double d = Math.max(this.y + this.width, dRectangle.y + dRectangle.width);
        double d2 = Math.max(this.x + this.height, dRectangle.x + dRectangle.height);
        this.y = Math.min(this.y, dRectangle.y);
        this.x = Math.min(this.x, dRectangle.x);
        this.width = d - this.y;
        this.height = d2 - this.x;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return d2 + d4 > this.x && d + d3 > this.y && d2 < this.x + this.height && d < this.y + this.width;
    }

    public boolean intersects(DRectangle dRectangle) {
        return this.intersects(dRectangle.y, dRectangle.x, dRectangle.width, dRectangle.height);
    }

    public DRectangle intersect(DRectangle dRectangle) {
        double d = Math.max(this.y, dRectangle.y);
        double d2 = Math.min(this.y + this.width, dRectangle.y + dRectangle.width);
        double d3 = Math.max(this.x, dRectangle.x);
        double d4 = Math.min(this.x + this.height, dRectangle.x + dRectangle.height);
        return new DRectangle(d, d3, d2 - d, d4 - d3);
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.width <= 0.0) {
            n |= 5;
        } else if (d < this.y) {
            n |= 1;
        } else if (d > this.y + this.width) {
            n |= 4;
        }
        if (this.height <= 0.0) {
            n |= 0xA;
        } else if (d2 < this.x) {
            n |= 8;
        } else if (d2 > this.x + this.height) {
            n |= 2;
        }
        return n;
    }

    public int incode(double d, double d2) {
        int n = 0;
        if (this.width <= 0.0) {
            n |= 5;
        } else if (d <= this.y) {
            n |= 1;
        } else if (d >= this.y + this.width) {
            n |= 4;
        }
        if (this.height <= 0.0) {
            n |= 0xA;
        } else if (d2 <= this.x) {
            n |= 8;
        } else if (d2 >= this.x + this.height) {
            n |= 2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DRectangle:");
        stringBuffer.append(" y=");
        stringBuffer.append(IFormat.f_3.format(this.y));
        stringBuffer.append(" x=");
        stringBuffer.append(IFormat.f_3.format(this.x));
        stringBuffer.append(" w=");
        stringBuffer.append(IFormat.f_3.format(this.width));
        stringBuffer.append(" h=");
        stringBuffer.append(IFormat.f_3.format(this.height));
        return stringBuffer.toString();
    }
}

