/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.Transform;
import java.awt.Point;

public final class GeoTransform
extends Transform {
    private double vx = 0.0;
    private double vy = 0.0;
    private double ox = 0.0;
    private double oy = 0.0;
    private double phi = 0.0;
    private double m = 1.0;
    private double msPhi;
    private double mcPhi;
    private double imsPhi;
    private double imcPhi;

    public GeoTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.vy = d;
        this.vx = d2;
        this.oy = d3;
        this.ox = d4;
        this.phi = this.getReduzedRotation(d5);
        this.m = d6;
        this.computeParam();
    }

    private void computeParam() {
        this.msPhi = Math.sin(-this.phi) * this.m;
        this.mcPhi = Math.cos(-this.phi) * this.m;
        this.imsPhi = Math.sin(-this.phi) / this.m;
        this.imcPhi = Math.cos(-this.phi) / this.m;
    }

    public void setTranslation(double d, double d2) {
        this.vx = d2;
        this.vy = d;
        this.computeParam();
    }

    public double getXTranslation() {
        return this.vx;
    }

    public double getYTranslation() {
        return this.vy;
    }

    public void setRotation(double d) {
        this.phi = this.getReduzedRotation(d);
        this.computeParam();
    }

    private double getReduzedRotation(double d) {
        while (d < -Math.PI) {
            d += Math.PI;
        }
        while (d > Math.PI) {
            d -= Math.PI;
        }
        return d;
    }

    @Override
    public double getRotation() {
        return this.phi;
    }

    public void setScale(double d) {
        this.m = d;
        this.computeParam();
    }

    @Override
    public double getScale() {
        return this.m;
    }

    @Override
    public Point transform(DPoint dPoint, Point point) {
        double d = dPoint.y + this.vy;
        double d2 = dPoint.x + this.vx;
        point.y = (int)Math.rint(this.oy - this.msPhi * d - this.mcPhi * d2);
        point.x = (int)Math.rint(this.ox + this.mcPhi * d - this.msPhi * d2);
        return point;
    }

    @Override
    public Point transform(double d, double d2, Point point) {
        point.y = (int)Math.rint(this.oy - this.msPhi * (d += this.vy) - this.mcPhi * (d2 += this.vx));
        point.x = (int)Math.rint(this.ox + this.mcPhi * d - this.msPhi * d2);
        return point;
    }

    @Override
    public Point transform(double d, double d2) {
        return new Point((int)Math.rint(this.ox + this.mcPhi * (d += this.vy) - this.msPhi * (d2 += this.vx)), (int)Math.rint(this.oy - this.msPhi * d - this.mcPhi * d2));
    }

    @Override
    public Point transform(DPoint dPoint) {
        double d = dPoint.y + this.vy;
        double d2 = dPoint.x + this.vx;
        return new Point((int)Math.rint(this.ox + this.mcPhi * d - this.msPhi * d2), (int)Math.rint(this.oy - this.msPhi * d - this.mcPhi * d2));
    }

    @Override
    public DPoint inverse(Point point, DPoint dPoint) {
        double d = (double)(-point.y) + this.oy;
        double d2 = (double)point.x - this.ox;
        dPoint.x = this.imcPhi * d - this.imsPhi * d2 - this.vx;
        dPoint.y = this.imsPhi * d + this.imcPhi * d2 - this.vy;
        return dPoint;
    }

    public String toString() {
        return this.getClass().getName() + "\nvx=" + this.vx + "\nvy=" + this.vy + "\nox=" + this.ox + "\noy=" + this.oy + "\nphi=" + this.phi + "\nm=" + this.m;
    }
}

