/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.GeomElement;
import de.geocalc.io.ErrConstants;
import de.geocalc.lang.ErrorMessage;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class GeomException
extends Exception
implements ErrorMessage {
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int MESSAGE = 4;
    private DPoint loc;
    private int typ = 2;
    private int id = 0;
    private GeomElement object;

    public GeomException() {
        this(2, null, null, "Geometriefehler");
    }

    public GeomException(String string) {
        this(2, null, null, string);
    }

    public GeomException(int n, String string) {
        this(n, null, null, string);
    }

    public GeomException(DPoint dPoint, GeomElement geomElement, String string) {
        this(2, dPoint, geomElement, string);
    }

    public GeomException(int n, DPoint dPoint, GeomElement geomElement, String string) {
        super(string);
        this.typ = n;
        this.loc = dPoint;
        this.object = geomElement;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public int getTyp() {
        return this.typ;
    }

    public DPoint getLocation() {
        return this.loc;
    }

    public GeomElement getObject() {
        return this.object;
    }

    @Override
    public String toFileMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.typ == 1) {
            stringBuffer.append("FATAL: ");
        } else if (this.typ == 2) {
            stringBuffer.append("ERROR: ");
        } else if (this.typ == 3) {
            stringBuffer.append("WARNING: ");
        } else if (this.typ == 4) {
            stringBuffer.append("MESSAGE: ");
        } else {
            stringBuffer.append("ERROR: ");
        }
        stringBuffer.append(IFormat.EOL);
        if (this.id != 0) {
            stringBuffer.append("ID:    ");
            stringBuffer.append(this.id);
            stringBuffer.append(IFormat.EOL);
        }
        if (this.loc != null) {
            stringBuffer.append("LOC:   ");
            stringBuffer.append(ErrConstants.toString(this.loc));
            stringBuffer.append(IFormat.EOL);
        }
        if (this.object != null) {
            if (this.object instanceof DCollection) {
                Enumeration enumeration = ((DCollection)this.object).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    stringBuffer.append("ELEM:  ");
                    if (e instanceof DPoint) {
                        stringBuffer.append(ErrConstants.toString((DPoint)e));
                    } else if (e instanceof DLine) {
                        stringBuffer.append(ErrConstants.toString((DLine)e));
                    } else if (e instanceof DPolygon) {
                        stringBuffer.append(ErrConstants.toString((DPolygon)e));
                    }
                    stringBuffer.append(IFormat.EOL);
                }
            } else {
                stringBuffer.append("ELEM:  ");
                if (this.object instanceof DPoint) {
                    stringBuffer.append(ErrConstants.toString((DPoint)this.object));
                } else if (this.object instanceof DLine) {
                    stringBuffer.append(ErrConstants.toString((DLine)this.object));
                } else if (this.object instanceof DPolygon) {
                    stringBuffer.append(ErrConstants.toString((DPolygon)this.object));
                }
                stringBuffer.append(IFormat.EOL);
            }
        }
        if (this.getMessage() != null) {
            stringBuffer.append("TEXT:  ");
            stringBuffer.append(ErrConstants.toString(this.getMessage()));
            stringBuffer.append(IFormat.EOL);
        }
        stringBuffer.append("END:   ");
        stringBuffer.append(IFormat.EOL);
        return stringBuffer.toString();
    }

    @Override
    public String toDialogMessage() {
        return this.getMessage();
    }
}

