/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom;

import de.geocalc.geom.DRectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GeomGrid {
    private DRectangle r = null;
    private Vector[][] V = null;
    private DRectangle[][] R = null;
    private int lines;
    private int cols;
    private int size = 0;

    public GeomGrid(DRectangle dRectangle, int n, int n2) {
        this.r = dRectangle;
        this.lines = n;
        this.cols = n2;
        this.V = new Vector[n][n2];
        this.R = new DRectangle[n][n2];
        double d = dRectangle.x;
        double d2 = dRectangle.y;
        double d3 = dRectangle.height / (double)n;
        double d4 = dRectangle.width / (double)n2;
        for (int i = 0; i < n; ++i) {
            d2 = dRectangle.y;
            for (int j = 0; j < n2; ++j) {
                this.R[i][j] = new DRectangle(d2, d, d4, d3);
                this.V[i][j] = new Vector();
                d2 += d4;
            }
            d += d3;
        }
    }

    public int size() {
        return this.size;
    }

    public void addElement(DRectangle dRectangle, Object object) throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (!this.R[i][j].intersects(dRectangle)) continue;
                this.V[i][j].addElement(object);
                bl = true;
            }
        }
        if (!bl) {
            throw new Exception("Rectangle " + String.valueOf(dRectangle) + " konnte nicht dem Bereich " + String.valueOf(this.r) + " hinzugef\u00fcgt werden");
        }
        ++this.size;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.R[i][j] = null;
                this.V[i][j].removeAllElements();
                this.V[i][j] = null;
            }
        }
    }

    public Enumeration elements(DRectangle dRectangle) {
        return new DRectEnumerator(dRectangle);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                stringBuffer.append(i + ":" + j + " = " + this.V[i][j].size() + " Elemente\n");
            }
        }
        return stringBuffer.toString();
    }

    class DRectEnumerator
    implements Enumeration {
        DRectangle sr;
        int l;
        int c;
        int i;
        int size;
        Vector vect = null;
        Object next = null;

        DRectEnumerator(DRectangle dRectangle) {
            this.sr = dRectangle;
            this.setNextVector();
        }

        void setNextVector() {
            this.next = null;
            this.i = 0;
            while (this.l < GeomGrid.this.lines) {
                while (this.c < GeomGrid.this.cols) {
                    if (GeomGrid.this.R[this.l][this.c].intersects(this.sr)) {
                        this.vect = GeomGrid.this.V[this.l][this.c];
                        this.size = this.vect.size();
                        if (this.size != 0) {
                            ++this.c;
                            this.i = 0;
                            this.next = this.vect.elementAt(0);
                            return;
                        }
                    }
                    ++this.c;
                }
                this.c = 0;
                ++this.l;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object object = this.next;
            ++this.i;
            if (this.i < this.size) {
                this.next = this.vect.elementAt(this.i);
            } else {
                this.setNextVector();
            }
            return object;
        }
    }
}

