/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom.algorithm;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;

public class Centroid {
    private DPoint baseP;
    private DPoint triangleP = new DPoint();
    private DPoint cg3 = new DPoint();
    private DPoint c = new DPoint();
    private double areasum2;

    public Centroid(DPolygon dPolygon) {
        this.addPolygon(dPolygon);
    }

    public DPoint getCentroid() {
        return this.c;
    }

    private void addPolygon(DPolygon dPolygon) {
        this.baseP = dPolygon.getPoint(0);
        boolean bl = dPolygon.getArea() > 0.0;
        for (int i = 0; i < dPolygon.npoints - 1; ++i) {
            this.addTriangle(this.baseP, dPolygon.getPoint(i), dPolygon.getPoint(i + 1), bl);
        }
        this.c.y = this.cg3.y / 3.0 / this.areasum2;
        this.c.x = this.cg3.x / 3.0 / this.areasum2;
    }

    private void addTriangle(DPoint dPoint, DPoint dPoint2, DPoint dPoint3, boolean bl) {
        double d = bl ? 1.0 : -1.0;
        Centroid.centroid3(dPoint, dPoint2, dPoint3, this.triangleP);
        double d2 = Centroid.area2(dPoint, dPoint2, dPoint3);
        this.cg3.y += d * d2 * this.triangleP.y;
        this.cg3.x += d * d2 * this.triangleP.x;
        this.areasum2 += d * d2;
    }

    private static void centroid3(DPoint dPoint, DPoint dPoint2, DPoint dPoint3, DPoint dPoint4) {
        dPoint4.y = dPoint.y + dPoint2.y + dPoint3.y;
        dPoint4.x = dPoint.x + dPoint2.x + dPoint3.x;
    }

    private static double area2(DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        return (dPoint2.x - dPoint.x) * (dPoint3.y - dPoint.y) - (dPoint3.x - dPoint.x) * (dPoint2.y - dPoint.y);
    }
}

