/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.geom.algorithm;

public class GaussianElimination {
    private static final double EPSILON = 1.0E-10;

    public static double[] solve(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            n = i;
            for (int j = i + 1; j < n2; ++j) {
                if (!(Math.abs(dArray[j][i]) > Math.abs(dArray[n][i]))) continue;
                n = j;
            }
            double[] dArray3 = dArray[i];
            dArray[i] = dArray[n];
            dArray[n] = dArray3;
            double d = dArray2[i];
            dArray2[i] = dArray2[n];
            dArray2[n] = d;
            if (Math.abs(dArray[i][i]) <= 1.0E-10) {
                throw new ArithmeticException("Matrix is singular or nearly singular");
            }
            for (int j = i + 1; j < n2; ++j) {
                double d2 = dArray[j][i] / dArray[i][i];
                int n3 = j;
                dArray2[n3] = dArray2[n3] - d2 * dArray2[i];
                for (int k = i; k < n2; ++k) {
                    double[] dArray4 = dArray[j];
                    int n4 = k;
                    dArray4[n4] = dArray4[n4] - d2 * dArray[i][k];
                }
            }
        }
        double[] dArray5 = new double[n2];
        for (n = n2 - 1; n >= 0; --n) {
            double d = 0.0;
            for (int i = n + 1; i < n2; ++i) {
                d += dArray[n][i] * dArray5[i];
            }
            dArray5[n] = (dArray2[n] - d) / dArray[n][n];
        }
        return dArray5;
    }

    public static void main(String[] stringArray) {
        int n = 3;
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 1.0}, {2.0, 4.0, -2.0}, {0.0, 3.0, 15.0}};
        double[] dArray = new double[]{4.0, 2.0, 36.0};
        double[] dArray2 = GaussianElimination.solve(dArrayArray, dArray);
        for (int i = 0; i < n; ++i) {
            System.out.println(dArray2[i]);
        }
    }
}

