/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.ggout.Katalog;
import de.geocalc.ggout.objects.ArtDefElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.Convertable;
import de.geocalc.ggout.objects.Coo2D;
import de.geocalc.ggout.objects.DG;
import de.geocalc.ggout.objects.DataElement;
import de.geocalc.ggout.objects.FTABLE;
import de.geocalc.ggout.objects.GA;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.GR;
import de.geocalc.ggout.objects.HNR;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.LI;
import de.geocalc.ggout.objects.MA;
import de.geocalc.ggout.objects.MR;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.OO;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.OVector;
import de.geocalc.ggout.objects.PK;
import de.geocalc.ggout.objects.ParameterElement;
import de.geocalc.ggout.objects.PlotElement;
import de.geocalc.ggout.objects.REF;
import de.geocalc.ggout.objects.Referenz;
import de.geocalc.ggout.objects.RulesElement;
import de.geocalc.ggout.objects.SCH;
import de.geocalc.ggout.objects.SPL;
import de.geocalc.ggout.objects.StackElement;
import de.geocalc.ggout.objects.SubElement;
import de.geocalc.ggout.objects.SuperElement;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TR;
import de.geocalc.ggout.objects.Table;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.VoidEnumerator;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Data {
    public static final int SORT_UP = 0;
    public static final int SORT_DOWN = 1;
    private int mKey;
    private int pKey;
    private int lKey;
    private int tKey;
    private int sKey;
    private int gKey;
    private int oKey;
    private int bKey;
    private int dKey;
    private int rKey;
    private int xKey;
    private int hKey;
    private int grKey;
    private Katalog aktKatalog = new Katalog();
    private File plotFile = null;
    private final Hashtable coords = new Hashtable();
    private final Hashtable horizonts = new Hashtable();
    private final Hashtable punkte = new Hashtable();
    private final Hashtable tabellen = new Hashtable();
    private final Hashtable zeichensaetze = new Hashtable();
    private final IntegerHashList arten = new IntegerHashList();
    private final IntegerHashList params = new IntegerHashList();
    private final IntegerHashList hash = new IntegerHashList();
    private final Vector kataloge = new Vector();
    private final Vector stack = new Vector();
    private final Vector plot = new Vector();
    private boolean hashNumbers = false;
    private boolean hashCoords = false;
    private boolean hasUuidElements = false;
    private boolean hasExtKeyElements = false;
    private boolean hasMengeElements = false;
    private boolean hasGroupElements = false;
    private String uuidConst = null;
    private int viewScale = 0;

    public String createMemoryInfo() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            HashElement hashElement = (HashElement)enumeration.nextElement();
            switch (hashElement.getMasterKey()) {
                case 0x1000000: {
                    ++n;
                    if (!hashElement.hasExtendAttributes()) break;
                    ++n6;
                    break;
                }
                case 0x2000000: {
                    ++n2;
                    if (!hashElement.hasExtendAttributes()) break;
                    ++n7;
                    break;
                }
                case 0x3000000: {
                    ++n3;
                    if (!hashElement.hasExtendAttributes()) break;
                    ++n8;
                    break;
                }
                case 0x4000000: {
                    ++n4;
                    if (!hashElement.hasExtendAttributes()) break;
                    ++n9;
                    break;
                }
                case 0xA000000: {
                    ++n5;
                    if (!hashElement.hasExtendAttributes()) break;
                    ++n10;
                }
            }
        }
        return "   Hash:     " + IFormat.i8.format(this.hash.size()) + " Elemente\n   Stack:    " + IFormat.i8.format(this.stack.size()) + " Elemente\n   Numbers:  " + IFormat.i8.format(this.punkte.size()) + " Elemente\n   Coords:   " + IFormat.i8.format(this.coords.size()) + " Elemente\n     PK: " + IFormat.i7.format(n) + " Elemente, " + IFormat.i6.format(n6) + " erweitert\n     LI: " + IFormat.i7.format(n2) + " Elemente, " + IFormat.i6.format(n7) + " erweitert\n     TE: " + IFormat.i7.format(n3) + " Elemente, " + IFormat.i6.format(n8) + " erweitert\n     SC: " + IFormat.i7.format(n4) + " Elemente, " + IFormat.i6.format(n9) + " erweitert\n     OO: " + IFormat.i7.format(n5) + " Elemente, " + IFormat.i6.format(n10) + " erweitert\n";
    }

    public Data() {
        this.kataloge.addElement(this.aktKatalog);
    }

    public Data(boolean bl, boolean bl2) {
        this();
        this.hashNumbers = bl;
        this.hashCoords = bl2;
    }

    void hasUuidElements(boolean bl) {
        this.hasUuidElements = bl;
    }

    public boolean hasUuidElements() {
        return this.hasUuidElements;
    }

    void hasExtKeyElements(boolean bl) {
        this.hasExtKeyElements = bl;
    }

    public boolean hasExtKeyElements() {
        return this.hasExtKeyElements;
    }

    public boolean hasMengeElements() {
        return this.hasMengeElements;
    }

    public boolean hasGroupElements() {
        return this.hasGroupElements;
    }

    public String getUuidConst() {
        return this.uuidConst;
    }

    public void setUuidConst(String string) {
        this.uuidConst = string != null ? string.toUpperCase() : null;
    }

    public int getViewScale() {
        return this.viewScale;
    }

    protected void setViewScale(int n) {
        this.viewScale = n;
    }

    public void flush() {
        this.kataloge.clear();
        this.arten.clear();
        this.params.clear();
        this.hash.clear();
    }

    public void clearCoords() {
        this.coords.clear();
    }

    public int size() {
        return this.params.size() + this.hash.size() + this.stack.size() + this.plot.size();
    }

    public int rulesSize() {
        int n = 0;
        for (int i = 0; i < this.kataloge.size(); ++i) {
            n += ((Katalog)this.kataloge.elementAt(i)).size();
        }
        return n;
    }

    public int plotSize() {
        return this.plot.size();
    }

    public GGElement put(GGElement gGElement) throws Exception {
        if (gGElement instanceof RulesElement) {
            return this.putRulesElement((RulesElement)gGElement);
        }
        if (gGElement instanceof ArtDefElement) {
            return this.putArtDefElement((ArtDefElement)((Object)gGElement));
        }
        if (gGElement instanceof HashElement) {
            return this.putHashElement((HashElement)gGElement);
        }
        if (gGElement instanceof StackElement) {
            return this.putStackElement((StackElement)gGElement);
        }
        if (gGElement instanceof ParameterElement) {
            return this.putParameterElement((ParameterElement)gGElement);
        }
        if (gGElement instanceof PlotElement) {
            return this.putPlotElement((PlotElement)gGElement);
        }
        throw new Exception("Ung\u00fcltiges Element wurde der Datenbank zugewiesen");
    }

    public boolean remove(GGElement gGElement) throws Exception {
        if (gGElement instanceof RulesElement) {
            return false;
        }
        if (gGElement instanceof ArtDefElement) {
            return this.arten.remove(((HashElement)gGElement).getKey()) != null;
        }
        if (gGElement instanceof HashElement) {
            if (((HashElement)gGElement).getMasterKey() == 0x1000000) {
                this.punkte.remove(((PK)gGElement).getName());
            }
            return this.hash.remove(((HashElement)gGElement).getKey()) != null;
        }
        if (gGElement instanceof StackElement) {
            return this.stack.removeElement(gGElement);
        }
        if (gGElement instanceof ParameterElement) {
            return this.params.remove(((ParameterElement)gGElement).intHashKey()) != null;
        }
        throw new Exception("Ung\u00fcltiges Element sollte aus der Datenbank gel\u00f6scht werden");
    }

    public Enumeration elements() {
        return new DataEnumeration(false);
    }

    public Enumeration elements(boolean bl) {
        return new DataEnumeration(bl);
    }

    public Enumeration elementsAndRules() {
        return new DataEnumeration(true);
    }

    public Enumeration getRulesElements() {
        return new RulesEnumerator();
    }

    public Enumeration getPlotElements() {
        return this.plot.elements();
    }

    public Enumeration getSortedRulesElements() {
        return new RulesEnumerator();
    }

    public Enumeration getArtDefElements() {
        return this.arten.elements();
    }

    public Enumeration getSortedArtDefElements() {
        return this.arten.sortedElements();
    }

    public Enumeration getParameters() {
        return this.params.elements();
    }

    public Enumeration getSortedParameters() {
        return this.params.sortedElements();
    }

    public Enumeration getStackElements() {
        return this.stack.elements();
    }

    public Enumeration getHashElements() {
        return this.hash.elements();
    }

    public Enumeration getSortedHashElements() {
        return this.hash.sortedElements();
    }

    public Enumeration getSortedHashElements(int n) {
        return this.hash.sortedElements(n);
    }

    public Enumeration getTriangles(int n) {
        return new HorizontEnumeration(this, n);
    }

    public Enumeration getMengen() {
        return new MengeEnumeration();
    }

    public Enumeration getElementMengen(int n) {
        return new ElementMengeEnumeration(n);
    }

    public Object getObject(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n >= 3) {
            if (string.charAt(0) == '#' && string.charAt(n - 1) == '#') {
                try {
                    return (HashElement)this.hash.get(Integer.parseInt(string.substring(1, n - 1), 16));
                }
                catch (Exception exception) {
                }
            } else if (string.charAt(2) == '=') {
                try {
                    return (HashElement)this.hash.get(Constants.parseKey(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.punkte.get(string);
    }

    public HashElement getObject(int n) {
        return (HashElement)this.hash.get(n);
    }

    public HashElement getObject(Referenz referenz) {
        return (HashElement)this.hash.get(referenz.getLink());
    }

    public Object getObject(Object object) {
        Object object2 = null;
        object2 = object instanceof Referenz ? this.getObject((Referenz)object) : (object instanceof Coo2D ? new PK(((Coo2D)object).getX(), ((Coo2D)object).getY()) : (object instanceof String ? this.getObject((String)object) : this.getObject(object.toString())));
        return object2;
    }

    public PK getPointOfPNR(Object object) {
        Object object2 = null;
        object2 = object instanceof Referenz ? this.getObject((Referenz)object) : (object instanceof Coo2D ? new PK(((Coo2D)object).getX(), ((Coo2D)object).getY()) : (object instanceof String ? this.getObject((String)object) : this.getObject(object.toString())));
        return object2 instanceof PK ? (PK)object2 : null;
    }

    public int getID(Object object) {
        if (object instanceof HashElement) {
            HashElement hashElement = (HashElement)object;
            int n = hashElement.getMasterKey();
            switch (n) {
                case 0xB000000: {
                    return ++this.mKey;
                }
                case 0x1000000: {
                    return ++this.pKey;
                }
                case 0x2000000: {
                    return ++this.lKey;
                }
                case 0x3000000: {
                    return ++this.tKey;
                }
                case 0x4000000: {
                    return ++this.sKey;
                }
                case 0x7000000: {
                    return ++this.gKey;
                }
                case 0xA000000: {
                    return ++this.oKey;
                }
                case 0x9000000: {
                    return ++this.bKey;
                }
                case 0xC000000: {
                    return ++this.dKey;
                }
                case 0x8000000: {
                    return ++this.rKey;
                }
                case 0xD000000: {
                    return ++this.xKey;
                }
            }
        } else if (object instanceof StackElement && object instanceof HNR) {
            return ++this.hKey;
        }
        return -1;
    }

    public Table getTable(String string) {
        Table table = (Table)this.tabellen.get(string);
        if (table == null && Character.isDigit(string.charAt(0))) {
            try {
                return this.getTable(Integer.parseInt(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return table;
    }

    public Table getTable(int n) {
        IntegerHashObject integerHashObject = this.arten.get(0xFA00000 + n);
        if (integerHashObject instanceof Table) {
            return (Table)integerHashObject;
        }
        return null;
    }

    public MA getMenge(String string) {
        Enumeration enumeration = this.stack.elements();
        while (enumeration.hasMoreElements()) {
            MA mA;
            Object e = enumeration.nextElement();
            if (!(e instanceof MA) || !string.equals((mA = (MA)e).getName())) continue;
            return mA;
        }
        return null;
    }

    public PK getPKFromHash(double d, double d2, double d3) {
        if (this.hashCoords) {
            return (PK)this.coords.get(new Coo(this, d, d2, d3));
        }
        return null;
    }

    public void putCooToHash(PK pK) {
        this.coords.put(new Coo(this, pK.getX(), pK.getY(), pK.getZ()), pK);
    }

    public HNR getHorizontFromHash(int n, String string) {
        HNR hNR;
        if (n != 0 && (hNR = (HNR)this.horizonts.get(new Integer(n))) != null) {
            return hNR;
        }
        if (string != null && (hNR = (HNR)this.horizonts.get(string)) != null) {
            return hNR;
        }
        return null;
    }

    public void putHorizontToHash(HNR hNR) {
        if (hNR.getNr() != 0) {
            this.horizonts.put(new Integer(hNR.getNr()), hNR);
        }
        if (hNR.getName() != null) {
            this.horizonts.put(hNR.getName(), hNR);
        }
    }

    public Katalog getKatalog() {
        return this.aktKatalog;
    }

    public boolean hasKatalog(int n) {
        for (int i = 0; i < this.kataloge.size(); ++i) {
            Katalog katalog = (Katalog)this.kataloge.elementAt(i);
            if (katalog.getNr() != n) continue;
            return true;
        }
        return false;
    }

    public Katalog getKatalog(int n) {
        for (int i = 0; i < this.kataloge.size(); ++i) {
            Katalog katalog = (Katalog)this.kataloge.elementAt(i);
            if (katalog.getNr() != n) continue;
            return katalog;
        }
        return null;
    }

    private GGElement putRulesElement(RulesElement rulesElement) {
        int n = rulesElement.getKatalog();
        if (n != this.aktKatalog.getNr() && (this.aktKatalog = this.getKatalog(n)) == null) {
            this.aktKatalog = new Katalog(n);
            this.kataloge.addElement(this.aktKatalog);
        }
        return this.aktKatalog.put(rulesElement);
    }

    public Object getArtDef(int n) {
        return this.arten.get(n);
    }

    private GGElement putArtDefElement(ArtDefElement artDefElement) {
        if (artDefElement instanceof FTABLE) {
            this.tabellen.put(((FTABLE)artDefElement).getName(), artDefElement);
        }
        return (GGElement)((Object)this.arten.put(artDefElement));
    }

    private StackElement putStackElement(StackElement stackElement) {
        if (stackElement instanceof HNR) {
            this.putHorizontToHash((HNR)stackElement);
        } else if (stackElement instanceof GA) {
            ((GA)stackElement).setKey(++this.grKey);
        }
        int n = this.stack.indexOf(stackElement);
        if (n >= 0) {
            StackElement stackElement2 = (StackElement)this.stack.elementAt(n);
            this.stack.setElementAt(stackElement, n);
            return stackElement2;
        }
        this.stack.addElement(stackElement);
        return null;
    }

    private ParameterElement putParameterElement(ParameterElement parameterElement) {
        return (ParameterElement)this.params.put(parameterElement);
    }

    public ParameterElement getParameter(int n) {
        return (ParameterElement)this.params.get(n);
    }

    public PlotElement putPlotElement(PlotElement plotElement) {
        this.plot.addElement(plotElement);
        return null;
    }

    private HashElement putHashElement(HashElement hashElement) {
        int n = hashElement.getMasterKey();
        int n2 = hashElement.getSubKey();
        if (n2 == 0) {
            hashElement.setKey(this.getID(hashElement));
        }
        switch (n) {
            case 0xB000000: {
                this.mKey = Math.max(this.mKey, hashElement.getKey());
                break;
            }
            case 0x1000000: {
                this.pKey = Math.max(this.pKey, hashElement.getKey());
                break;
            }
            case 0x2000000: {
                this.lKey = Math.max(this.lKey, hashElement.getKey());
                break;
            }
            case 0x3000000: {
                this.tKey = Math.max(this.tKey, hashElement.getKey());
                break;
            }
            case 0x4000000: {
                this.sKey = Math.max(this.sKey, hashElement.getKey());
                break;
            }
            case 0x7000000: {
                this.gKey = Math.max(this.gKey, hashElement.getKey());
                break;
            }
            case 0xA000000: {
                this.oKey = Math.max(this.oKey, hashElement.getKey());
                break;
            }
            case 0x9000000: {
                this.bKey = Math.max(this.bKey, hashElement.getKey());
                break;
            }
            case 0xC000000: {
                this.dKey = Math.max(this.dKey, hashElement.getKey());
                break;
            }
            case 0x8000000: {
                this.rKey = Math.max(this.rKey, hashElement.getKey());
                break;
            }
            case 0xD000000: {
                this.xKey = Math.max(this.xKey, hashElement.getKey());
            }
        }
        if (n == 0x1000000 && hashElement instanceof PK) {
            PK pK = (PK)hashElement;
            if (this.hashNumbers && pK.hasName()) {
                this.punkte.put(pK.getName(), hashElement);
            }
            if (this.hashCoords) {
                this.coords.put(new Coo(this, pK), pK);
            }
        }
        return (HashElement)this.hash.put(hashElement);
    }

    public int convert() {
        int n = 0;
        Vector<HashElement> vector = new Vector<HashElement>();
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            HashElement hashElement = (HashElement)enumeration.nextElement();
            if (!(hashElement instanceof Convertable)) continue;
            DataElement dataElement = ((Convertable)((Object)hashElement)).convert();
            if (dataElement != null) {
                try {
                    this.put(dataElement);
                    if (((HashElement)dataElement).getKey() != hashElement.getKey()) {
                        vector.addElement(hashElement);
                    }
                }
                catch (Exception exception) {
                    new Exception("Fehler beim konvertieren von veralteten Elementen, " + exception.getMessage()).printStackTrace();
                }
            }
            ++n;
        }
        for (int i = 0; i < vector.size(); ++i) {
            try {
                this.remove((GGElement)vector.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                new Exception("Fehler beim konvertieren von veralteten Elementen, " + exception.getMessage()).printStackTrace();
            }
        }
        return n;
    }

    public void rehash() {
        GGElement gGElement;
        Object object;
        Object object2;
        Object object3;
        Enumeration<Object> enumeration;
        PK pK = new PK();
        if (!this.hashNumbers) {
            enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (HashElement)enumeration.nextElement();
                if (object3 instanceof LI) {
                    object2 = (LI)object3;
                    if (LI.isNummer(((LI)object2).getName1())) {
                        this.punkte.put(((LI)object2).getName1(), pK);
                    }
                    if (LI.isNummer(((LI)object2).getName2())) {
                        this.punkte.put(((LI)object2).getName2(), pK);
                    }
                    if (!LI.isNummer(((LI)object2).getName3())) continue;
                    this.punkte.put(((LI)object2).getName3(), pK);
                    continue;
                }
                if (!(object3 instanceof DG)) continue;
                object2 = (DG)object3;
                if (DG.isNummer(((DG)object2).getName1())) {
                    this.punkte.put(((DG)object2).getName1(), pK);
                }
                if (DG.isNummer(((DG)object2).getName2())) {
                    this.punkte.put(((DG)object2).getName2(), pK);
                }
                if (!DG.isNummer(((DG)object2).getName3())) continue;
                this.punkte.put(((DG)object2).getName3(), pK);
            }
            enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (HashElement)enumeration.nextElement();
                if (!(object3 instanceof PK) || !((PK)(object2 = (PK)object3)).hasName() || !this.punkte.containsKey(((PK)object2).getName())) continue;
                this.punkte.put(((PK)object2).getName(), object2);
            }
            enumeration = this.punkte.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                if (this.punkte.get(object3) != pK) continue;
                this.punkte.remove(object3);
                new Exception("Punktnummer " + (String)object3 + " nicht im Speicher").printStackTrace();
            }
        }
        enumeration = this.hash.elements();
        block3: while (enumeration.hasMoreElements()) {
            int n;
            HashElement hashElement;
            object3 = (HashElement)enumeration.nextElement();
            if (object3 instanceof PK) {
                object2 = (PK)object3;
                Enumeration enumeration2 = ((OList)object2).elements();
                while (enumeration2.hasMoreElements()) {
                    object = (SubElement)enumeration2.nextElement();
                    if (!(object instanceof GR)) continue;
                    ((HashElement)object2).setGroup(true);
                    gGElement = this.getObject(((GR)object).getLink());
                    if (gGElement == null) continue;
                    ((HashElement)gGElement).setUsedByGroup(true);
                }
                continue;
            }
            if (object3 instanceof LI) {
                object2 = (LI)object3;
                PK pK2 = null;
                pK2 = this.getPointOfPNR(((LI)object2).getName1());
                if (pK2 != null) {
                    pK2.setUsedByLine(true);
                }
                if ((pK2 = this.getPointOfPNR(((LI)object2).getName2())) != null) {
                    pK2.setUsedByLine(true);
                }
                if (((LI)object2).getName3() != null && (pK2 = this.getPointOfPNR(((LI)object2).getName3())) != null) {
                    pK2.setUsedByLine(true);
                }
                object = ((OList)object2).elements();
                while (object.hasMoreElements()) {
                    gGElement = (SubElement)object.nextElement();
                    if (!(gGElement instanceof GR)) continue;
                    ((HashElement)object2).setGroup(true);
                    hashElement = this.getObject(((GR)gGElement).getLink());
                    if (hashElement == null) continue;
                    hashElement.setUsedByGroup(true);
                }
                continue;
            }
            if (object3 instanceof TE) {
                object2 = (TE)object3;
                Enumeration enumeration3 = ((OList)object2).elements();
                while (enumeration3.hasMoreElements()) {
                    object = (SubElement)enumeration3.nextElement();
                    if (object instanceof TR) {
                        gGElement = this.getObject(((TR)object).getLink());
                        if (gGElement == null) continue;
                        ((HashElement)gGElement).setUsedByText(true);
                        ((HashElement)object2).setDescription(true);
                        continue block3;
                    }
                    if (!(object instanceof GR)) continue;
                    ((HashElement)object2).setGroup(true);
                    gGElement = this.getObject(((GR)object).getLink());
                    if (gGElement == null) continue;
                    ((HashElement)gGElement).setUsedByGroup(true);
                }
                continue;
            }
            if (object3 instanceof SCH || object3 instanceof SPL) {
                object2 = (SuperElement)object3;
                Enumeration enumeration4 = ((SuperElement)object2).elements();
                while (enumeration4.hasMoreElements()) {
                    object = (SubElement)enumeration4.nextElement();
                    if (!(object instanceof REF)) continue;
                    gGElement = this.getObject(((REF)object).getLink());
                    if (gGElement instanceof PK) {
                        hashElement = (PK)gGElement;
                        if (hashElement == null) continue;
                        hashElement.setUsedByLine(true);
                        continue;
                    }
                    if (!(gGElement instanceof LI) || !(object3 instanceof SPL) || (hashElement = (LI)gGElement) == null) continue;
                    hashElement.setHidden(true);
                }
                continue;
            }
            if (!(object3 instanceof OOX)) continue;
            object2 = (OOX)object3;
            Enumeration enumeration5 = ((OVector)object2).elements();
            while (enumeration5.hasMoreElements()) {
                SCH sCH;
                object = (SubElement)enumeration5.nextElement();
                if (!(object instanceof OR) || (hashElement = this.getObject(((OR)(gGElement = (OR)object)).getLink())) == null) continue;
                if (((OR)gGElement).getTyp() == 2) {
                    hashElement.setUsedByObjectDef(true);
                } else {
                    hashElement.setUsedByObjectAus(true);
                }
                if (hashElement instanceof LI) {
                    if (((OR)gGElement).getTyp() == 2) {
                        ((OOX)object2).setAreaType(true);
                    }
                    ((OOX)object2).setLineType(true);
                    continue;
                }
                if (hashElement instanceof SPL) {
                    ((OOX)object2).setLineType(true);
                    continue;
                }
                if (!(hashElement instanceof SCH) || (sCH = (SCH)hashElement).getTyp() == 0 || sCH.getTyp() == 10) continue;
                ((OOX)object2).setLineType(true);
            }
            if (!(object2 instanceof OO) || (n = ((OO)object2).getOberObject()) <= 0 || (object = this.getObject(n)) == null) continue;
            ((HashElement)object).setUsedByObjectDef(true);
        }
        enumeration = this.stack.elements();
        while (enumeration.hasMoreElements()) {
            GGElement gGElement2;
            object3 = enumeration.nextElement();
            if (object3 instanceof MA) {
                this.hasMengeElements = true;
                object2 = ((MA)object3).elements();
                while (object2.hasMoreElements()) {
                    gGElement2 = (MR)object2.nextElement();
                    object = this.getObject(((MR)gGElement2).getLink());
                    if (object == null) continue;
                    ((HashElement)object).setUsedByMenge(true);
                }
                continue;
            }
            if (!(object3 instanceof GA)) continue;
            this.hasGroupElements = true;
            object2 = (GA)object3;
            gGElement2 = this.getObject(((GA)object2).getLink());
            ((HashElement)gGElement2).setGroup(true);
            object = ((GA)object2).elements();
            while (object.hasMoreElements()) {
                gGElement = (GR)object.nextElement();
                gGElement2 = this.getObject(((GR)gGElement).getLink());
                if (gGElement2 == null) continue;
                ((HashElement)gGElement2).setUsedByGroup(true);
            }
        }
    }

    private class DataEnumeration
    implements Enumeration {
        Enumeration el;
        int i;
        int maxI;

        public DataEnumeration(boolean bl) {
            this.el = Data.this.plot.elements();
            this.i = 0;
            this.maxI = 4;
            this.maxI = bl ? 4 : 3;
        }

        @Override
        public boolean hasMoreElements() {
            if (!this.el.hasMoreElements()) {
                this.setNextEnumeration();
            }
            return this.el.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.el.nextElement();
            }
            throw new NoSuchElementException("Data Enumeration");
        }

        private void setNextEnumeration() {
            if (this.i > this.maxI) {
                return;
            }
            if (this.i == 0) {
                Data.this.params.sortedElements();
            } else if (this.i == 1) {
                this.el = Data.this.arten.sortedElements();
            } else if (this.i == 2) {
                this.el = Data.this.hash.sortedElements();
            } else if (this.i == 3) {
                this.el = Data.this.stack.elements();
            } else if (this.i == 4) {
                this.el = new RulesEnumerator();
            }
            ++this.i;
            if (!this.el.hasMoreElements()) {
                this.setNextEnumeration();
            }
        }
    }

    private class RulesEnumerator
    implements Enumeration {
        Enumeration el;
        Enumeration z = null;
        int i = 0;
        int j = 0;

        public RulesEnumerator() {
            this.z = Data.this.zeichensaetze.elements();
            this.setNextEnumeration();
        }

        @Override
        public boolean hasMoreElements() {
            if (!this.el.hasMoreElements()) {
                this.setNextEnumeration();
            }
            return this.el.hasMoreElements();
        }

        public Object nextElement() {
            return this.el.nextElement();
        }

        private void setNextEnumeration() {
            while (this.i < Data.this.kataloge.size()) {
                this.el = ((Katalog)Data.this.kataloge.elementAt(this.i)).elements();
                ++this.i;
                if (!this.el.hasMoreElements()) continue;
                return;
            }
            this.el = VoidEnumerator.instance();
        }
    }

    private class HorizontEnumeration
    implements Enumeration {
        int hnr;
        Enumeration el;
        Object nextDg = null;

        public HorizontEnumeration(Data data, int n) {
            this.hnr = n;
            this.el = data.hash.elements();
            this.setNext();
        }

        private Object setNext() {
            Object object = this.nextDg;
            this.nextDg = null;
            while (this.el.hasMoreElements()) {
                Object e = this.el.nextElement();
                if (!(e instanceof DG) || ((DG)e).getHorizont() != this.hnr) continue;
                this.nextDg = e;
                break;
            }
            return object;
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextDg != null;
        }

        public Object nextElement() {
            if (this.nextDg != null) {
                return this.setNext();
            }
            throw new NoSuchElementException("Horizonz Enumeration");
        }
    }

    private class MengeEnumeration
    implements Enumeration {
        Enumeration el;
        MA ma;

        public MengeEnumeration() {
            this.el = Data.this.stack.elements();
            this.ma = null;
            this.ma = this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.ma != null;
        }

        public Object nextElement() {
            if (this.ma != null) {
                MA mA = this.ma;
                this.ma = this.next();
                return mA;
            }
            throw new NoSuchElementException("Data Enumeration");
        }

        private MA next() {
            while (this.el.hasMoreElements()) {
                Object e = this.el.nextElement();
                if (!(e instanceof MA)) continue;
                return (MA)e;
            }
            return null;
        }
    }

    private class ElementMengeEnumeration
    implements Enumeration {
        Enumeration el;
        MA ma;
        int key;

        public ElementMengeEnumeration(int n) {
            this.el = Data.this.stack.elements();
            this.ma = null;
            this.key = 0;
            this.key = n;
            this.ma = this.next(n);
        }

        @Override
        public boolean hasMoreElements() {
            return this.ma != null;
        }

        public Object nextElement() {
            if (this.ma != null) {
                MA mA = this.ma;
                this.ma = this.next(this.key);
                return mA;
            }
            throw new NoSuchElementException("Data Enumeration");
        }

        private MA next(int n) {
            while (this.el.hasMoreElements()) {
                MA mA;
                Object e = this.el.nextElement();
                if (!(e instanceof MA) || !(mA = (MA)e).contains(n)) continue;
                return mA;
            }
            return null;
        }
    }

    class Coo {
        long x;
        long y;
        long z;

        public Coo(Data data, double d, double d2, double d3) {
            this.x = Constants.roundCoo(d);
            this.y = Constants.roundCoo(d2);
            this.z = Constants.roundCoo(d3);
        }

        public Coo(Data data, PK pK) {
            this(data, pK.getX(), pK.getY(), pK.getZ());
        }

        public int hashCode() {
            return (int)(this.x ^ this.x >>> 32) + (int)(this.y ^ this.y >>> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof Coo) {
                Coo coo = (Coo)object;
                return this.x == coo.x && this.y == coo.y && (this.z == coo.z || this.z == 0L || coo.z == 0L);
            }
            return false;
        }
    }
}

