/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.text.IFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class GeografFileTyp {
    public static final int UNKNOWN = 0;
    public static final int GRAFBAT = 1;
    public static final int ARTBAT = 2;
    public static final int SYMBAT = 3;
    public static final int GEOPLOT = 4;
    public static final int PEN = 11;
    public static final int LEVEL = 31;
    public static final int KOR = 41;
    public static final int ART = 91;
    public static final int ARI = 92;
    public static final int SYM = 93;
    public static final int COLOR = 94;
    public static final int STZ = 95;
    public static final int MSDOS = 1;
    public static final int WINDOWS = 2;
    public static final int MAX_SCAN_LINES = 100;
    public static final String ASCII_ENCODING = "cp850";
    public static final String ANSI_ENCODING = "cp1252";
    public static final String STANDARD_ENCODING = "cp1252";
    int typ = 0;
    int sys = 0;
    int major = 0;
    int minor = -1;
    float plotVersion = 0.0f;

    public int getFileTyp() {
        return this.typ;
    }

    public String getFileTypString() {
        if (this.typ == 1) {
            return this.version("GRAFBAT", this.major);
        }
        if (this.typ == 2) {
            return this.version("ARTBAT", this.major);
        }
        if (this.typ == 3) {
            return this.version("SYMBAT", this.major);
        }
        if (this.typ == 4) {
            return this.version("GEOPLOT", this.major);
        }
        if (this.typ == 11) {
            return "Stiftdatei";
        }
        if (this.typ == 94) {
            return "Farbdatei";
        }
        if (this.typ == 31) {
            return "Stufendatei";
        }
        if (this.typ == 41) {
            return "Koordinatendatei";
        }
        if (this.typ == 91) {
            return "Artendatei";
        }
        if (this.typ == 92) {
            return "ArtenIndexdatei";
        }
        if (this.typ == 93) {
            return "Symboldatei";
        }
        if (this.typ == 95) {
            return "Zeichensatzdatei";
        }
        return "unknown";
    }

    private String version(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n > 0) {
            if (this.sys == 1) {
                stringBuffer.append(" f\u00fcr MS-DOS ");
            } else {
                stringBuffer.append(" V");
            }
            stringBuffer.append(n);
            if (this.minor >= 0) {
                stringBuffer.append("." + this.minor);
            }
        }
        return stringBuffer.toString();
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getOperatingSystem() {
        return this.sys;
    }

    public String getOperatingSystemAsString() {
        if (this.sys == 1) {
            return "MS-DOS";
        }
        if (this.sys == 2) {
            return "MS Windows";
        }
        return "unknown";
    }

    public boolean isStandardEncoding() {
        return "cp1252".equals(this.getEncoding());
    }

    public static boolean isStandardEncoding(String string) {
        return "cp1252".equals(string);
    }

    public String getEncoding() {
        if (this.typ == 1 || this.typ == 2 || this.typ == 3 || this.typ == 4) {
            if (this.sys == 1) {
                return ASCII_ENCODING;
            }
            if (this.typ == 4 && this.plotVersion > 0.0f && this.plotVersion < 8.0f) {
                return ASCII_ENCODING;
            }
            if (this.major == 0) {
                return "cp1252";
            }
            if (this.major <= 3) {
                return ASCII_ENCODING;
            }
            if (this.major >= 4) {
                return "cp1252";
            }
        }
        return "cp1252";
    }

    private int testBinFile(File file, String string) {
        int n = 0;
        string = string.toLowerCase();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n2 = ((InputStream)fileInputStream).read();
            int n3 = ((InputStream)fileInputStream).read();
            int n4 = ((InputStream)fileInputStream).read();
            if (string.equals("sym") && n2 == 10 && n3 == 0 && n4 != 0) {
                n = 93;
            } else if (string.equals("art") && n2 == 0 && n3 == 0 && n4 == 140) {
                n = 91;
            } else if (string.equals("ari") && n2 == 0 && n3 == 0 && n4 == 4) {
                n = 92;
            } else if (string.equals("stz")) {
                n = 95;
            } else if (n2 == 10 && n3 == 0 && n4 != 0) {
                n = 93;
            } else if (n2 == 0 && n3 == 0 && n4 == 140) {
                n = 91;
            } else if (n2 == 0 && n3 == 0 && n4 == 4) {
                n = 92;
            }
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return n;
    }

    public void testFile(File file) throws IOException {
        String string;
        String string2 = "";
        String string3 = file.getAbsolutePath();
        int n = string3.lastIndexOf(".") + 1;
        if (n > 0) {
            string2 = string3.substring(n).toLowerCase();
        }
        if (string2.equals("art") || string2.equals("idx") || string2.equals("sym") || string2.equals("stz")) {
            this.typ = this.testBinFile(file, string2);
        }
        if (this.typ != 0) {
            return;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), "cp1252"));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            ++n2;
            string = string.trim().toUpperCase();
            if (this.typ == 0 && (string.startsWith("* FRAMEGEN") || string.startsWith("* PLOTMANAGER") || string.startsWith("* PLOTMIX") || string.startsWith("* GEOPLOT") || string.startsWith("* SYMBOLDATEI ") || string.startsWith("* SYMBOLDEFINITION") || string.startsWith("*SYMBOLDEFINITION"))) {
                this.typ = 4;
                int n5 = string.indexOf("VERSION");
                if (n5 <= 0) continue;
                this.parseVersionNumbers(string.substring(n5 + 7).trim());
                continue;
            }
            if (string.startsWith("*") || string.length() == 0) continue;
            ++n3;
            try {
                if (string.startsWith("TYP:")) {
                    String string4;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    String string7 = string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                    if (string6.equals("GRAFBAT")) {
                        this.typ = 1;
                    } else if (string6.equals("ARTBAT")) {
                        this.typ = 2;
                    } else if (string6.equals("SYMBAT")) {
                        this.typ = 3;
                    } else {
                        if (!string6.equals("GEOPLOT")) continue;
                        this.typ = 4;
                    }
                    if (string4.startsWith("V")) {
                        this.sys = 2;
                        this.parseVersionNumbers(string4.substring(1));
                        break;
                    }
                    this.sys = 1;
                    this.parseVersionNumbers(string4);
                    break;
                }
                if (this.typ == 4 && string.startsWith("103")) {
                    try {
                        this.plotVersion = Float.parseFloat(string.substring(3).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.typ == 0) {
                    if (string.startsWith("SPMODE ") || string.startsWith("FA ") || string.startsWith("PEN ")) {
                        this.typ = 11;
                        break;
                    }
                    if (string.startsWith("[PUNKTE]") || string.startsWith("[LINIEN]") || string.startsWith("[TEXTE]") || string.startsWith("[FLAECHEN]") || string.startsWith("[OBJEKTE]")) {
                        this.typ = 31;
                        break;
                    }
                    if (this.is(string, "PK") || this.is(string, "LI") || this.is(string, "TE") || this.is(string, "SCH") || this.is(string, "SPL") || this.is(string, "OO")) {
                        this.typ = 1;
                    } else if (string.startsWith("FILE: ") || string.startsWith("VIEW: ") || string.startsWith("PA: ") || string.startsWith("LL: ") || string.startsWith("AA: ") || string.startsWith("OA: ")) {
                        this.typ = 2;
                    } else if (this.is(string, "FE")) {
                        this.typ = 3;
                    } else if ((this.typ == 0 || this.typ == 41) && this.isKorLine(string)) {
                        if (++n4 > 10 && n4 == n3) {
                            this.typ = 41;
                            break;
                        }
                        if (n3 > 100 && (double)n4 > (double)n3 * 0.9) {
                            this.typ = 41;
                            break;
                        }
                    }
                }
                if (this.typ == 0 || this.sys == 0 || n3 <= 100) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        lineNumberReader.close();
        if (this.typ == 0 && file.length() == 768L) {
            this.typ = 94;
        }
        if (this.typ == 0) {
            this.typ = this.testBinFile(file, string2);
        }
    }

    private void parseVersionNumbers(String string) {
        try {
            int n = string.indexOf(46);
            if (n < 0) {
                this.major = Integer.parseInt(IFormat.getFirstNumbers(string));
            } else {
                this.major = Integer.parseInt(string.substring(0, n));
                this.minor = Integer.parseInt(IFormat.getFirstNumbers(string.substring(n + 1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isKorLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl3 = this.isArt(string2);
                    break;
                }
                case 2: {
                    bl4 = this.isKoo(string2);
                    break;
                }
                case 3: {
                    bl5 = this.isKoo(string2);
                    break;
                }
                case 4: {
                    if (this.isKoo(string2)) break;
                    return false;
                }
            }
            ++n;
        }
        return bl2 && bl3 && bl4 && bl5;
    }

    private boolean isArt(String string) {
        boolean bl = false;
        int n = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl = true;
                    continue block4;
                }
                case '.': {
                    ++n;
                }
                default: {
                    return false;
                }
            }
        }
        return bl && n <= 2;
    }

    private boolean isKoo(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean is(String string, String string2) {
        if (string.startsWith(string2)) {
            int n;
            int n2 = string.indexOf(",");
            int n3 = Math.min(n2, n = string.indexOf(":"));
            return n3 > 0 && IFormat.isNumber(string.substring(string2.length(), n3));
        }
        return false;
    }
}

