/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.ggout.objects.AMT;
import de.geocalc.ggout.objects.APP;
import de.geocalc.ggout.objects.ARTEN;
import de.geocalc.ggout.objects.ARTPLUS;
import de.geocalc.ggout.objects.AUFID;
import de.geocalc.ggout.objects.BBOX;
import de.geocalc.ggout.objects.BE;
import de.geocalc.ggout.objects.BLATT;
import de.geocalc.ggout.objects.BN;
import de.geocalc.ggout.objects.BO;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.DA;
import de.geocalc.ggout.objects.DART;
import de.geocalc.ggout.objects.DATA;
import de.geocalc.ggout.objects.DDEF;
import de.geocalc.ggout.objects.DE;
import de.geocalc.ggout.objects.DEL;
import de.geocalc.ggout.objects.DG;
import de.geocalc.ggout.objects.DOC;
import de.geocalc.ggout.objects.DTXT;
import de.geocalc.ggout.objects.EB;
import de.geocalc.ggout.objects.FATTR;
import de.geocalc.ggout.objects.FINFO;
import de.geocalc.ggout.objects.FTABLE;
import de.geocalc.ggout.objects.FTEXT;
import de.geocalc.ggout.objects.FTYPES;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.GR;
import de.geocalc.ggout.objects.HNR;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.KATALOG;
import de.geocalc.ggout.objects.KEY;
import de.geocalc.ggout.objects.KS;
import de.geocalc.ggout.objects.LAND;
import de.geocalc.ggout.objects.LEGENDE;
import de.geocalc.ggout.objects.LI;
import de.geocalc.ggout.objects.MA;
import de.geocalc.ggout.objects.MODEL;
import de.geocalc.ggout.objects.MR;
import de.geocalc.ggout.objects.OA;
import de.geocalc.ggout.objects.OAX;
import de.geocalc.ggout.objects.OD;
import de.geocalc.ggout.objects.OE;
import de.geocalc.ggout.objects.OO;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.OPT;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.OS;
import de.geocalc.ggout.objects.OT;
import de.geocalc.ggout.objects.PA;
import de.geocalc.ggout.objects.PAR;
import de.geocalc.ggout.objects.PB;
import de.geocalc.ggout.objects.PK;
import de.geocalc.ggout.objects.PKNUM;
import de.geocalc.ggout.objects.PLOT;
import de.geocalc.ggout.objects.PNR;
import de.geocalc.ggout.objects.POLAR;
import de.geocalc.ggout.objects.POLZUG;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.PRJ;
import de.geocalc.ggout.objects.RA;
import de.geocalc.ggout.objects.RECH;
import de.geocalc.ggout.objects.REF;
import de.geocalc.ggout.objects.SC;
import de.geocalc.ggout.objects.SCH;
import de.geocalc.ggout.objects.SI;
import de.geocalc.ggout.objects.SIZ;
import de.geocalc.ggout.objects.SN;
import de.geocalc.ggout.objects.SNZ;
import de.geocalc.ggout.objects.SP;
import de.geocalc.ggout.objects.SPL;
import de.geocalc.ggout.objects.SPZ;
import de.geocalc.ggout.objects.STEMPEL;
import de.geocalc.ggout.objects.SU;
import de.geocalc.ggout.objects.SYSTEM;
import de.geocalc.ggout.objects.TA;
import de.geocalc.ggout.objects.TB;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TF;
import de.geocalc.ggout.objects.TR;
import de.geocalc.ggout.objects.TT;
import de.geocalc.ggout.objects.TX;
import de.geocalc.ggout.objects.TYP;
import de.geocalc.ggout.objects.UuidKey;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GeografOutLine {
    private static final char MACRO_START = '$';
    private static final char MACRO_DEF_END = ':';
    private static final char MACRO_USE_END = '$';
    private static final Hashtable MACROS = new Hashtable();
    private static boolean hasMacros = false;
    public static boolean readUuid = false;
    private boolean hasUuid = false;
    protected String line;
    protected int length;

    public GeografOutLine() {
        this.line = null;
        this.length = 0;
    }

    public GeografOutLine(String string) {
        this.setLine(string);
    }

    public void setLine(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '$') {
            int n = string.indexOf(58);
            if (n > 0) {
                String string2 = string.substring(0, n) + "$";
                String string3 = string.substring(n + 1).trim();
                MACROS.put(string2, string3);
                hasMacros = true;
            }
        } else if (hasMacros && string.indexOf(36) > 0) {
            Enumeration enumeration = MACROS.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = (String)MACROS.get(string4);
                string = string.replace(string4, string5);
            }
        }
        this.line = string;
        this.length = this.line.length();
    }

    public String getLine() {
        return this.line;
    }

    public int length() {
        return this.length;
    }

    public boolean hasUuid() {
        return this.hasUuid;
    }

    public boolean isSubLine() {
        return this.length > 3 && this.line.charAt(0) == ' ' && this.line.charAt(1) == ' ' && this.line.charAt(2) != ' ';
    }

    public int getKennung() {
        if (this.length == 0 || this.line.charAt(0) == '*' || this.line.charAt(0) == '$') {
            return 0;
        }
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < this.length; ++i) {
            switch (this.line.charAt(i)) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!bl) {
                        return -2;
                    }
                }
                case ':': {
                    n2 = i;
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    if (bl) break;
                    n = i;
                    bl = true;
                }
            }
            if (n2 >= 0) break;
        }
        return Constants.getIdentifier(this.line.substring(n, n2));
    }

    public int getKey() {
        int n = 0;
        int n2 = this.line.indexOf(58);
        int n3 = this.line.indexOf(44);
        if (n2 < 0) {
            return 0;
        }
        if (n3 > 0 && n3 < n2) {
            n2 = n3;
            this.hasUuid = true;
        }
        while (n < n2 && !Character.isDigit(this.line.charAt(n))) {
            ++n;
        }
        if (n == n2) {
            return 0;
        }
        return Integer.parseInt(this.line.substring(n, n2));
    }

    public boolean hasValues() {
        return this.getValueString().trim().length() > 0;
    }

    public GGElement getTemplateElement() {
        GGElement gGElement = null;
        switch (this.getKennung()) {
            case 0: {
                break;
            }
            case 11: {
                gGElement = OPT.parseOutLine(this);
                break;
            }
            case 12: {
                gGElement = TYP.parseOutLine(this);
                break;
            }
            case 17: {
                gGElement = SYSTEM.parseOutLine(this);
                break;
            }
            case 13: {
                gGElement = PAR.parseOutLine(this);
                break;
            }
            case 14: {
                gGElement = BLATT.parseOutLine(this);
                break;
            }
            case 15: {
                gGElement = AUFID.parseOutLine(this);
                break;
            }
            case 16: {
                gGElement = PRJ.parseOutLine(this);
                break;
            }
            case 18: {
                gGElement = ARTPLUS.parseOutLine(this);
                break;
            }
            case 19: {
                gGElement = LAND.parseOutLine(this);
                break;
            }
            case 31: {
                gGElement = RECH.parseOutLine(this);
                break;
            }
            case 32: {
                gGElement = POLAR.parseOutLine(this);
                break;
            }
            case 33: {
                gGElement = POLZUG.parseOutLine(this);
                break;
            }
            case 40: {
                gGElement = PLOT.parseOutLine(this);
                break;
            }
            case 41: {
                gGElement = AMT.parseOutLine(this);
                break;
            }
            case 42: {
                gGElement = STEMPEL.parseOutLine(this);
                break;
            }
            case 43: {
                gGElement = LEGENDE.parseOutLine(this);
                break;
            }
            case 44: {
                gGElement = ARTEN.parseOutLine(this);
                break;
            }
            case -2: {
                gGElement = DATA.parseOutLine(this);
                break;
            }
            case 801: {
                gGElement = DDEF.parseOutLine(this);
                break;
            }
            case 802: {
                gGElement = DART.parseOutLine(this);
                break;
            }
            case 803: {
                gGElement = DTXT.parseOutLine(this);
                break;
            }
            case 800: {
                gGElement = DA.parseOutLine(this);
                break;
            }
            case 809: {
                gGElement = DE.parseOutLine(this);
                break;
            }
            case 810: {
                gGElement = FINFO.parseOutLine(this);
                break;
            }
            case 811: {
                gGElement = FTABLE.parseOutLine(this);
                break;
            }
            case 812: {
                gGElement = FTYPES.parseOutLine(this);
                break;
            }
            case 813: {
                gGElement = FTEXT.parseOutLine(this);
                break;
            }
            case 814: {
                gGElement = FATTR.parseOutLine(this);
            }
        }
        return gGElement;
    }

    public GGElement getElement() throws NoSuchElementException {
        this.hasUuid = false;
        GGElement gGElement = null;
        switch (this.getKennung()) {
            case 0: {
                break;
            }
            case 11: {
                gGElement = OPT.parseOutLine(this);
                break;
            }
            case 12: {
                gGElement = TYP.parseOutLine(this);
                break;
            }
            case 17: {
                gGElement = SYSTEM.parseOutLine(this);
                break;
            }
            case 13: {
                gGElement = PAR.parseOutLine(this);
                break;
            }
            case 14: {
                gGElement = BLATT.parseOutLine(this);
                break;
            }
            case 15: {
                gGElement = AUFID.parseOutLine(this);
                break;
            }
            case 16: {
                gGElement = PRJ.parseOutLine(this);
                break;
            }
            case 18: {
                gGElement = ARTPLUS.parseOutLine(this);
                break;
            }
            case 19: {
                gGElement = LAND.parseOutLine(this);
                break;
            }
            case 20: {
                gGElement = BBOX.parseOutLine(this);
                break;
            }
            case 31: {
                gGElement = RECH.parseOutLine(this);
                break;
            }
            case 32: {
                gGElement = POLAR.parseOutLine(this);
                break;
            }
            case 33: {
                gGElement = POLZUG.parseOutLine(this);
                break;
            }
            case 40: {
                gGElement = PLOT.parseOutLine(this);
                break;
            }
            case 41: {
                gGElement = AMT.parseOutLine(this);
                break;
            }
            case 42: {
                gGElement = STEMPEL.parseOutLine(this);
                break;
            }
            case 43: {
                gGElement = LEGENDE.parseOutLine(this);
                break;
            }
            case 44: {
                gGElement = ARTEN.parseOutLine(this);
                break;
            }
            case 45: {
                break;
            }
            case 65: {
                gGElement = PKNUM.parseOutLine(this);
                break;
            }
            case 50: {
                gGElement = KATALOG.parseOutLine(this);
                break;
            }
            case 51: {
                gGElement = APP.parseOutLine(this);
                break;
            }
            case 62: {
                break;
            }
            case 64: {
                gGElement = DEL.parseOutLine(this);
                break;
            }
            case 91: {
                gGElement = HNR.parseOutLine(this);
                break;
            }
            case 52: {
                gGElement = EB.parseOutLine(this);
                break;
            }
            case 82: {
                gGElement = MODEL.parseOutLine(this);
                break;
            }
            case 61: {
                gGElement = KEY.parseOutLine(this);
                break;
            }
            case 100: {
                gGElement = PK.parseOutLine(this);
                break;
            }
            case 112: {
                gGElement = KS.parseOutLine(this);
                break;
            }
            case 113: {
                gGElement = PA.parseOutLine(this);
                break;
            }
            case 200: {
                gGElement = LI.parseOutLine(this);
                break;
            }
            case 300: {
                gGElement = TE.parseOutLine(this);
                break;
            }
            case 301: {
                gGElement = TA.parseOutLine(this);
                break;
            }
            case 302: {
                gGElement = TF.parseOutLine(this);
                break;
            }
            case 303: {
                gGElement = TX.parseOutLine(this);
                break;
            }
            case 304: {
                gGElement = TT.parseOutLine(this);
                break;
            }
            case 305: {
                gGElement = TR.parseOutLine(this);
                break;
            }
            case 306: {
                gGElement = TB.parseOutLine(this);
                break;
            }
            case 307: {
                break;
            }
            case 400: {
                gGElement = SC.parseOutLine(this);
                break;
            }
            case 401: {
                gGElement = SU.parseOutLine(this);
                break;
            }
            case 410: {
                gGElement = BO.parseOutLine(this);
                break;
            }
            case 411: {
                gGElement = BN.parseOutLine(this);
                break;
            }
            case 415: {
                gGElement = SCH.parseOutLine(this);
                break;
            }
            case 416: {
                gGElement = POS.parseOutLine(this);
                break;
            }
            case 417: {
                gGElement = PNR.parseOutLine(this);
                break;
            }
            case 420: {
                gGElement = SP.parseOutLine(this);
                break;
            }
            case 421: {
                gGElement = SPZ.parseOutLine(this);
                break;
            }
            case 422: {
                gGElement = SPL.parseOutLine(this);
                break;
            }
            case 432: {
                gGElement = SI.parseOutLine(this);
                break;
            }
            case 433: {
                gGElement = SIZ.parseOutLine(this);
                break;
            }
            case 444: {
                gGElement = SN.parseOutLine(this);
                break;
            }
            case 445: {
                gGElement = SNZ.parseOutLine(this);
                break;
            }
            case 500: {
                gGElement = DG.parseOutLine(this);
                break;
            }
            case 600: {
                gGElement = OO.parseOutLine(this);
                break;
            }
            case 601: {
                gGElement = OOX.parseOutLine(this);
                break;
            }
            case 602: {
                gGElement = OR.parseOutLine(this);
                break;
            }
            case 603: {
                gGElement = OS.parseOutLine(this);
                break;
            }
            case 690: {
                gGElement = OA.parseOutLine(this);
                break;
            }
            case 691: {
                gGElement = OAX.parseOutLine(this);
                break;
            }
            case 692: {
                gGElement = OD.parseOutLine(this);
                break;
            }
            case 693: {
                gGElement = OT.parseOutLine(this);
                break;
            }
            case 699: {
                gGElement = OE.parseOutLine(this);
                break;
            }
            case 63: {
                gGElement = REF.parseOutLine(this);
                break;
            }
            case 700: {
                gGElement = BE.parseOutLine(this);
                break;
            }
            case 900: {
                gGElement = RA.parseOutLine(this);
                break;
            }
            case 910: {
                gGElement = DOC.parseOutLine(this);
                break;
            }
            case 81: {
                gGElement = PB.parseOutLine(this);
                break;
            }
            case -2: {
                gGElement = DATA.parseOutLine(this);
                break;
            }
            case 801: {
                gGElement = DDEF.parseOutLine(this);
                break;
            }
            case 802: {
                gGElement = DART.parseOutLine(this);
                break;
            }
            case 803: {
                gGElement = DTXT.parseOutLine(this);
                break;
            }
            case 800: {
                gGElement = DA.parseOutLine(this);
                break;
            }
            case 809: {
                gGElement = DE.parseOutLine(this);
                break;
            }
            case 810: {
                gGElement = FINFO.parseOutLine(this);
                break;
            }
            case 811: {
                gGElement = FTABLE.parseOutLine(this);
                break;
            }
            case 812: {
                gGElement = FTYPES.parseOutLine(this);
                break;
            }
            case 813: {
                break;
            }
            case 814: {
                gGElement = FATTR.parseOutLine(this);
                break;
            }
            case 850: {
                gGElement = MA.parseOutLine(this);
                break;
            }
            case 851: {
                gGElement = MR.parseOutLine(this);
                break;
            }
            case 859: {
                break;
            }
            case 861: {
                gGElement = GR.parseOutLine(this);
                break;
            }
            case 1999: 
            case 2110: 
            case 2111: 
            case 2112: 
            case 2113: 
            case 2199: {
                break;
            }
            default: {
                int n = this.line.indexOf(":");
                if (n < 0) {
                    n = Math.min(this.line.length(), 10);
                }
                throw new NoSuchElementException("Unbekannter Typ: " + this.line.substring(0, n));
            }
        }
        if (this.hasUuid) {
            if (gGElement instanceof HashElement) {
                this.setUuid((HashElement)gGElement);
            } else if (gGElement instanceof DEL) {
                this.setUuid((DEL)gGElement);
            }
        }
        return gGElement;
    }

    private void setUuid(HashElement hashElement) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.line.substring(0, this.line.indexOf(58)), ",");
        stringTokenizer.nextToken();
        String string = null;
        if (stringTokenizer.hasMoreTokens()) {
            if (readUuid) {
                string = stringTokenizer.nextToken();
                if (Constants.isQuotedUuid(string)) {
                    string = Constants.getUnquotedUuid(string);
                }
                hashElement.setUuid(string);
            } else {
                string = stringTokenizer.nextToken();
                hashElement.setUuid("");
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("0x") && string != null) {
                Constants.putUuidReference(new UuidKey(string), hashElement.getMasterKey() + this.getKey());
            } else {
                hashElement.setTopicality(Integer.parseInt(string2));
            }
        }
    }

    private void setUuid(DEL dEL) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.line.substring(0, this.line.indexOf(58)), ",");
        stringTokenizer.nextToken();
        String string = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (Constants.isQuotedUuid(string)) {
                string = Constants.getUnquotedUuid(string);
            }
            dEL.setKey(string);
        }
    }

    public String getValueString() {
        try {
            return this.line.substring(this.line.indexOf(":") + 1).trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Enumeration values() {
        return new ValueEnumerator(this, this.getValueString());
    }

    final class ValueEnumerator
    implements Enumeration {
        private static final String DELIM = ",";
        private int elements;
        private int count;
        private int sIdx;
        private String valueString;

        ValueEnumerator(GeografOutLine geografOutLine, String string) {
            this.valueString = string;
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"' && (i == 0 || string.charAt(i - 1) != '\\')) {
                    bl = !bl;
                    continue;
                }
                if (c != ',' || bl) continue;
                ++n;
            }
            this.elements = string.length() == 0 ? 0 : n + 1;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < this.elements;
        }

        public Object nextElement() {
            if (this.count >= this.elements - 1) {
                ++this.count;
                return this.valueString.substring(this.sIdx).trim();
            }
            String string = null;
            boolean bl = false;
            for (int i = this.sIdx; i < this.valueString.length(); ++i) {
                char c = this.valueString.charAt(i);
                if (c == '\"' && (i == 0 || this.valueString.charAt(i - 1) != '\\')) {
                    bl = !bl;
                    continue;
                }
                if (c != ',' || bl) continue;
                this.sIdx = i;
                string = this.valueString.substring(this.sIdx, this.sIdx);
                break;
            }
            ++this.sIdx;
            ++this.count;
            return string.trim();
        }
    }
}

