/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.awt.IProgressView;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.GeografReader;
import de.geocalc.ggout.objects.APP;
import de.geocalc.ggout.objects.AUFID;
import de.geocalc.ggout.objects.ArtDefElement;
import de.geocalc.ggout.objects.Attribute;
import de.geocalc.ggout.objects.AttributedSingleElement;
import de.geocalc.ggout.objects.BLATT;
import de.geocalc.ggout.objects.DA;
import de.geocalc.ggout.objects.DAAtt;
import de.geocalc.ggout.objects.DATA;
import de.geocalc.ggout.objects.DataEntryElement;
import de.geocalc.ggout.objects.EB;
import de.geocalc.ggout.objects.EbeneElement;
import de.geocalc.ggout.objects.FATTR;
import de.geocalc.ggout.objects.FINFO;
import de.geocalc.ggout.objects.GA;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.GR;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.KATALOG;
import de.geocalc.ggout.objects.KEY;
import de.geocalc.ggout.objects.KatalogElement;
import de.geocalc.ggout.objects.MasterElement;
import de.geocalc.ggout.objects.OA;
import de.geocalc.ggout.objects.OAX;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.SubElement;
import de.geocalc.ggout.objects.SuperElement;
import de.geocalc.ggout.objects.TA;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TF;
import de.geocalc.ggout.objects.Table;
import de.geocalc.ggout.objects.TableAtt;
import de.geocalc.ggout.objects.TableRow;
import de.geocalc.ggout.objects.TableText;
import de.geocalc.ggout.objects.TableType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Vector;

public class GeografOutReader
implements GeografReader {
    private static final String STANDARD_ENCODING = "cp1252";
    private String encoding = "cp1252";
    private int PROGRESS_BREAK = 4;
    private File file = null;
    private IProgressView progressView;
    private Data data;
    private Vector warnings = new Vector();
    private Vector errors = new Vector();
    private boolean continueOnError = false;
    private LineNumberReader in = null;

    public GeografOutReader() {
    }

    public GeografOutReader(File file) {
        this.file = file;
    }

    public GeografOutReader(File file, String string) {
        this.file = file;
        this.setEncoding(string);
    }

    @Override
    public void readUuid(boolean bl) {
        GeografOutLine.readUuid = bl;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getFileSize() {
        return this.file.length();
    }

    @Override
    public void setData(Data data) {
        this.data = data;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public void setEncoding(String string) {
        if (string != null) {
            this.encoding = string;
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void detectIncludeEncoding(boolean bl) {
    }

    @Override
    public boolean detectIncludeEncoding() {
        return false;
    }

    @Override
    public void setContinueOnError(boolean bl) {
        this.continueOnError = bl;
    }

    @Override
    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    @Override
    public void setProgressView(IProgressView iProgressView) {
        this.progressView = iProgressView;
    }

    @Override
    public void setProgressBreak(int n) {
        this.PROGRESS_BREAK = n;
    }

    public void userAbort() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IOException("Fehler beim Schlie\u00dfen der Datei: " + this.file.getName());
        }
    }

    @Override
    public void read() throws IOException {
        String string;
        this.in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.file.getAbsolutePath()), this.encoding));
        GeografOutLine geografOutLine = new GeografOutLine();
        MasterElement masterElement = null;
        Object object = null;
        MasterElement masterElement2 = null;
        int n = 2;
        boolean bl = false;
        Vector<GGElement> vector = new Vector<GGElement>(10);
        int n2 = 0;
        int n3 = 0;
        long l = this.file.length();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l / (long)this.PROGRESS_BREAK;
        if (this.progressView != null) {
            this.progressView.setProgress(0);
            this.sleep();
        }
        block20: while ((string = this.in.readLine()) != null) {
            try {
                Object object2;
                l2 += (long)(string.length() + 1);
                geografOutLine.setLine(string);
                GGElement gGElement = null;
                try {
                    gGElement = geografOutLine.getElement();
                }
                catch (Exception exception) {
                    this.addWarning(this.in.getLineNumber(), exception.getMessage());
                }
                if (gGElement == null) continue;
                if (gGElement instanceof DataEntryElement) {
                    if (gGElement instanceof TableRow) {
                        Object object3;
                        Enumeration enumeration;
                        object2 = (TableRow)gGElement;
                        Table table = this.data.getTable(((TableRow)object2).getName());
                        if (object2 instanceof DA && table != null) {
                            if (((HashElement)object2).getSubKey() != 0) {
                                table.setTyp('P');
                            }
                            Enumeration enumeration2 = table.attributes();
                            enumeration = ((AttributedSingleElement)object2).attributes();
                            while (enumeration2.hasMoreElements() && enumeration.hasMoreElements()) {
                                TableAtt tableAtt = (TableAtt)enumeration2.nextElement();
                                object3 = (DAAtt)enumeration.nextElement();
                                ((Attribute)object3).setName(tableAtt.getName());
                            }
                            int n4 = 0;
                            while (enumeration.hasMoreElements()) {
                                object3 = (DAAtt)enumeration.nextElement();
                                ((Attribute)object3).setName("autoName" + n4);
                            }
                        }
                        if (table == null) {
                            if (((TableRow)object2).isUndef()) {
                                if (object2 instanceof FINFO) {
                                    ((TableRow)object2).setArt(9999);
                                }
                            } else {
                                boolean bl2 = false;
                                if (object2 instanceof FINFO) {
                                    enumeration = ((AttributedSingleElement)object2).attributes();
                                    while (enumeration.hasMoreElements()) {
                                        Attribute attribute = (Attribute)enumeration.nextElement();
                                        object3 = attribute.getName();
                                        if (object3 == null || !((String)object3).contains(".") || !((String)object3).contains("[") || !((String)object3).contains("]")) continue;
                                        ((TableRow)object2).setArt(9999);
                                        bl2 = true;
                                    }
                                }
                                if (!bl2) {
                                    this.addWarning(this.in.getLineNumber(), "Sachdatum '" + ((TableRow)object2).getName() + "' ohne Tabellendefinition");
                                }
                            }
                            if (object != null) {
                                ((HashElement)object).addData((DataEntryElement)object2);
                            } else {
                                this.addWarning(this.in.getLineNumber(), "keine Zuordnung f\u00fcr Sachdateneintrag " + String.valueOf(object2) + " gefunden");
                            }
                        } else if (table.isSubTyp()) {
                            table.addData((DataEntryElement)object2);
                        } else if (object != null) {
                            ((HashElement)object).addData((DataEntryElement)object2);
                        } else {
                            this.addWarning(this.in.getLineNumber(), "keine Zuordnung f\u00fcr Sachdateneintrag " + String.valueOf(object2) + " gefunden");
                        }
                        if (table == null) continue;
                        ((TableRow)object2).setArt(table.getArt());
                        continue;
                    }
                    if (!(gGElement instanceof TableType) && !(gGElement instanceof TableText) && !(gGElement instanceof FATTR)) continue;
                    object2 = (ArtDefElement)((Object)gGElement);
                    Table table = this.data.getTable(object2.getName());
                    if (table != null) {
                        table.addElement(object2);
                        continue;
                    }
                    this.addWarning(this.in.getLineNumber(), "Tabelleneigenschaft " + object2.getOutKey() + "' ohne Tabellendefinition");
                    continue;
                }
                if (gGElement instanceof ArtDefElement) {
                    this.data.put(gGElement);
                } else {
                    switch (gGElement.typ()) {
                        case 6: {
                            if (masterElement != null) {
                                masterElement.trimToSize();
                            }
                            if (masterElement2 != null) {
                                masterElement2.addElement(new OR(((HashElement)gGElement).getKey(), n));
                                if (((HashElement)gGElement).isOnlyReference()) continue block20;
                            }
                            if (gGElement instanceof OA || gGElement instanceof OAX) {
                                if (((HashElement)gGElement).isOnlyReference()) {
                                    bl = true;
                                    continue block20;
                                }
                                masterElement2 = (MasterElement)((Object)gGElement);
                                n = 2;
                            } else if (gGElement instanceof OOX) {
                                object2 = this.data.getObject(((HashElement)gGElement).getKey());
                                if (object2 != null && object2 instanceof OOX) {
                                    masterElement = (MasterElement)object2;
                                    object = object2;
                                    break;
                                }
                            } else if (gGElement instanceof TE) {
                                object2 = (TE)gGElement;
                                for (int i = 0; i < vector.size(); ++i) {
                                    ((OList)object2).addElement(vector.elementAt(i));
                                }
                                vector.clear();
                            }
                            masterElement = (MasterElement)((Object)gGElement);
                            object = (HashElement)gGElement;
                            this.data.put(gGElement);
                            break;
                        }
                        case 5: {
                            if (masterElement2 != null) {
                                masterElement2.addElement(new OR(((HashElement)gGElement).getKey(), n));
                                if (((HashElement)gGElement).isOnlyReference()) continue block20;
                            }
                            object = (HashElement)gGElement;
                            this.data.put(gGElement);
                            break;
                        }
                        case 4: {
                            if (gGElement instanceof MasterElement) {
                                if (masterElement != null) {
                                    masterElement.trimToSize();
                                }
                                masterElement = (MasterElement)((Object)gGElement);
                            }
                            this.data.put(gGElement);
                            break;
                        }
                        case 1: {
                            if (gGElement instanceof AUFID) {
                                this.data.setUuidConst(((AUFID)gGElement).getUuidConst());
                            } else if (gGElement instanceof BLATT) {
                                this.data.setViewScale(((BLATT)gGElement).getMasstab());
                            }
                            this.data.put(gGElement);
                            break;
                        }
                        case 2: {
                            switch (gGElement.getIdentifier()) {
                                case 51: {
                                    n3 = ((APP)gGElement).getKatalog();
                                    continue block20;
                                }
                                case 50: {
                                    n3 = ((KATALOG)gGElement).getKatalog();
                                    continue block20;
                                }
                                case 52: {
                                    n2 = ((EB)gGElement).getEbene();
                                    continue block20;
                                }
                                case 61: {
                                    object2 = (KEY)gGElement;
                                    if (object != null) {
                                        String string2 = ((KEY)object2).getName();
                                        if (string2.indexOf(44) > 0) {
                                            string2 = string2.replace(',', '_');
                                            this.addWarning(this.in.getLineNumber(), String.valueOf(object2) + " enth\u00e4lt ung\u00fcltiges Zeichen ',', wird ersetzt durch '_'");
                                        }
                                        ((HashElement)object).addExtKey(string2);
                                        if (((KEY)object2).getAkt() != 0 && ((HashElement)object).getTopicality() != 0 && ((KEY)object2).getAkt() != ((HashElement)object).getTopicality()) {
                                            this.addWarning(this.in.getLineNumber(), "Aktualit\u00e4t des " + String.valueOf(object2) + " passt nicht zum \u00fcbergeordneten Element, h\u00f6chste Aktualit\u00e4t wird \u00fcbernommen");
                                        }
                                        ((HashElement)object).setTopicality(Math.max(((HashElement)object).getTopicality(), ((KEY)object2).getAkt()));
                                        if (((KEY)object2).getLink() != 0 && ((KEY)object2).getLink() != ((HashElement)object).getKey()) {
                                            this.addWarning(this.in.getLineNumber(), "Link des " + String.valueOf(object2) + " passt nicht zum \u00fcbergeordneten Element, Link ignoriert");
                                        }
                                        this.data.hasExtKeyElements(true);
                                        continue block20;
                                    }
                                    this.addWarning(this.in.getLineNumber(), String.valueOf(object2) + " hat kein \u00fcbergeordnetes Element, Zuordnung nicht erfolgt");
                                    continue block20;
                                }
                                case 692: 
                                case 693: {
                                    n = 1;
                                    continue block20;
                                }
                                case 699: {
                                    if (!bl) {
                                        masterElement2 = null;
                                    }
                                    bl = false;
                                    continue block20;
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (gGElement instanceof DATA && masterElement instanceof SuperElement) {
                                ((SuperElement)masterElement).addOutLine(geografOutLine);
                                break;
                            }
                            if (!geografOutLine.isSubLine()) {
                                if (gGElement instanceof GR) {
                                    if (masterElement != null) {
                                        masterElement.trimToSize();
                                    }
                                    gGElement = new GA((GR)gGElement);
                                    masterElement = (MasterElement)((Object)gGElement);
                                    this.data.put(gGElement);
                                    break;
                                }
                                if (!(gGElement instanceof TA) && !(gGElement instanceof TF)) break;
                                vector.addElement(gGElement);
                                break;
                            }
                            masterElement.addElement((SubElement)gGElement);
                        }
                    }
                    if (n2 > 0 && gGElement instanceof EbeneElement && (object2 = (EbeneElement)((Object)gGElement)).getEbene() <= 0) {
                        object2.setEbene(n2);
                    }
                    if (n3 > 0 && gGElement instanceof KatalogElement && (object2 = (KatalogElement)((Object)gGElement)).getKatalog() <= 0) {
                        object2.setKatalog(n3);
                    }
                    if (GeografOutLine.readUuid && gGElement instanceof HashElement) {
                        ((HashElement)gGElement).trimUuid(this.data.getUuidConst());
                    }
                }
                if (geografOutLine.hasUuid()) {
                    this.data.hasUuidElements(true);
                }
                if (l2 - l3 <= l4 || this.progressView == null) continue;
                this.progressView.setProgress((int)(100L * l2 / l));
                l3 = l2;
                this.sleep();
            }
            catch (Exception exception) {
                this.addError(this.in.getLineNumber(), exception);
                if (this.continueOnError) continue;
                throw new IOException(exception);
            }
        }
        this.in.close();
        GeografOutLine.readUuid = false;
        if (this.progressView != null) {
            this.progressView.setProgress(100);
            this.sleep();
        }
    }

    public void readTemplate() throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.file.getAbsolutePath()), STANDARD_ENCODING));
        GeografOutLine geografOutLine = new GeografOutLine();
        long l = this.file.length();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l / (long)this.PROGRESS_BREAK;
        if (this.progressView != null) {
            this.progressView.setProgress(0);
            this.sleep();
        }
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                geografOutLine.setLine(string);
                GGElement gGElement = geografOutLine.getTemplateElement();
                if (gGElement == null) continue;
                if (gGElement instanceof DataEntryElement) {
                    if (gGElement instanceof TableRow) {
                        var13_10 = (TableRow)gGElement;
                        var14_11 = this.data.getTable(((TableRow)var13_10).getName());
                        if (var14_11 == null) {
                            if (((TableRow)var13_10).getName().equals("<NN>")) continue;
                            this.addWarning(lineNumberReader.getLineNumber(), "Sachdatum '" + ((TableRow)var13_10).getName() + "' ohne Tabellendefinition");
                            continue;
                        }
                        if (var14_11.isSubTyp()) {
                            var14_11.addData((DataEntryElement)((Object)var13_10));
                        }
                        ((TableRow)var13_10).setArt(var14_11.getArt());
                    } else if (gGElement instanceof TableType || gGElement instanceof TableText || gGElement instanceof FATTR) {
                        var13_10 = (ArtDefElement)((Object)gGElement);
                        var14_11 = this.data.getTable(var13_10.getName());
                        if (var14_11 != null) {
                            var14_11.addElement(var13_10);
                        } else {
                            this.addWarning(lineNumberReader.getLineNumber(), "Tabelleneigenschaft " + var13_10.getOutKey() + "' ohne Tabellendefinition");
                        }
                    }
                } else {
                    this.data.put(gGElement);
                }
                if ((l2 += (long)(string.length() + 1)) - l3 <= l4 || this.progressView == null) continue;
                this.progressView.setProgress((int)(100L * l2 / l));
                l3 = l2;
                this.sleep();
            }
            catch (Exception exception) {
                this.addError(lineNumberReader.getLineNumber(), exception);
                if (this.continueOnError) continue;
                throw new IOException(exception);
            }
        }
        lineNumberReader.close();
        if (this.progressView != null) {
            this.progressView.setProgress(100);
            this.sleep();
        }
    }

    private void addWarning(int n, String string) {
        String string2 = "Warnung beim Lesen der Zeile: " + n + ", " + string;
        if (!this.continueOnError) {
            System.out.println(string2);
        }
        this.warnings.addElement(string2);
    }

    @Override
    public boolean hasMessages() {
        return this.warnings.size() > 0;
    }

    @Override
    public Enumeration messages() {
        return this.warnings.elements();
    }

    private void addError(int n, Exception exception) {
        String string = "Warnung beim Lesen der Zeile: " + n + ", " + exception.getMessage();
        if (!this.continueOnError) {
            System.out.println(string);
            exception.printStackTrace();
        }
        this.errors.addElement(new IOException(string));
    }

    @Override
    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    @Override
    public int errorCount() {
        return this.errors.size();
    }

    @Override
    public Enumeration errors() {
        return this.errors.elements();
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

