/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.awt.IProgressView;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.OO;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.OutFileElement;
import de.geocalc.ggout.objects.OutFileHashElement;
import de.geocalc.ggout.objects.SubElement;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TR;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class GeografOutWriter {
    private static final String STANDARD_DECODING = "ISO-8859-1";
    private static final String VERSION = "1.01";
    private String decoding = "ISO-8859-1";
    private static final int PROGRESS_BREAK = 4;
    private File file = null;
    private IProgressView progressView;
    private Data data;
    private int writedElements = 0;
    private String creator = null;
    private String info = null;
    BufferedWriter out = null;

    public GeografOutWriter() {
        this(null);
    }

    public GeografOutWriter(File file) {
        this.file = file;
        this.creator = this.getClass().getName() + " - Version: 1.01";
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file != null ? this.file.getName() : "";
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Data getData() {
        return this.data;
    }

    public void setDecoding(String string) {
        this.decoding = string;
    }

    private String getDecoding() {
        return this.decoding != null ? this.decoding : STANDARD_DECODING;
    }

    public void setProgressView(IProgressView iProgressView) {
        this.progressView = iProgressView;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getCreator() {
        return this.creator != null ? this.creator : "";
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public int writedCount() {
        return this.writedElements;
    }

    public void open() throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file.getAbsolutePath()), "cp1252"));
        this.out.write("Typ: GRAFBAT V10\n");
        this.out.write("*\n");
        this.out.write("* GRAFBAT - D A T E I  GEOgraf\n");
        this.out.write("*\n");
        if (this.creator != null) {
            this.writeComment(this.out, "erstellt mit: " + this.getCreator());
        }
        if (this.info != null) {
            this.writeComment(this.out, this.info);
        }
        this.out.write("* Erstellung: " + new Date().toLocaleString() + "\n");
        this.out.write("*\n");
        this.writedElements = 0;
    }

    public void writeData() throws IOException {
        int n = this.data.size();
        int n2 = 0;
        int n3 = n / 100 * 4;
        if (this.progressView != null) {
            this.progressView.setProgress(0);
            this.sleep();
        }
        try {
            HashElement hashElement;
            Object object;
            Object object2;
            this.write(this.data.getSortedParameters());
            this.write(this.data.getSortedArtDefElements());
            Enumeration enumeration = this.data.getHashElements();
            while (enumeration.hasMoreElements()) {
                object2 = (HashElement)enumeration.nextElement();
                ((HashElement)object2).setTempFlag1(false);
                ((HashElement)object2).setTempFlag2(false);
            }
            boolean bl = false;
            object2 = this.data.getSortedHashElements();
            while (object2.hasMoreElements()) {
                object = (HashElement)object2.nextElement();
                if (!(object instanceof OutFileHashElement)) continue;
                if (!this.writeResolved((HashElement)object)) {
                    bl = true;
                }
                if (this.writedElements - n2 <= n3 || this.progressView == null) continue;
                this.progressView.setProgress(100 * this.writedElements / n);
                n2 = this.writedElements;
                this.sleep();
            }
            for (int i = 0; bl && i < 3; ++i) {
                bl = false;
                object = this.data.getHashElements();
                while (object.hasMoreElements()) {
                    hashElement = (HashElement)object.nextElement();
                    if (!(hashElement instanceof OutFileHashElement) || hashElement.isTempFlag1() || this.writeResolved(hashElement)) continue;
                    bl = true;
                }
            }
            if (bl) {
                object = this.data.getHashElements();
                while (object.hasMoreElements()) {
                    hashElement = (HashElement)object.nextElement();
                    if (!(hashElement instanceof OutFileHashElement) || hashElement.isTempFlag1()) continue;
                    this.writeData(hashElement);
                }
            }
            this.write(this.data.getStackElements());
            if (this.progressView != null) {
                this.progressView.setProgress(100);
            }
            this.sleep();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private boolean writeResolved(HashElement hashElement) throws IOException {
        if (this.isResolved(hashElement)) {
            this.out.write(((OutFileHashElement)hashElement).toOutLine());
            this.out.newLine();
            hashElement.setTempFlag1(true);
            return true;
        }
        return false;
    }

    private boolean isResolved(HashElement hashElement) {
        if (hashElement instanceof TE) {
            TE tE = (TE)hashElement;
            Enumeration enumeration = tE.elements();
            while (enumeration.hasMoreElements()) {
                HashElement hashElement2;
                SubElement subElement = (SubElement)enumeration.nextElement();
                if (!(subElement instanceof TR) || (hashElement2 = this.data.getObject(((TR)subElement).getLink())) == null || hashElement2.isTempFlag1()) continue;
                return false;
            }
        } else if (hashElement instanceof OOX) {
            int n;
            GGElement gGElement;
            OOX oOX = (OOX)hashElement;
            Enumeration enumeration = oOX.elements();
            while (enumeration.hasMoreElements()) {
                OR oR;
                HashElement hashElement3;
                gGElement = (SubElement)enumeration.nextElement();
                if (!(gGElement instanceof OR) || (hashElement3 = this.data.getObject((oR = (OR)gGElement).getLink())) == null || hashElement3.isTempFlag1()) continue;
                return false;
            }
            if (oOX instanceof OO && (n = ((OO)oOX).getOberObject()) > 0 && (gGElement = this.data.getObject(n)) != null && !((HashElement)gGElement).isTempFlag1()) {
                return false;
            }
        }
        return true;
    }

    private void write(Enumeration enumeration) throws IOException {
        while (enumeration.hasMoreElements()) {
            this.writeData((GGElement)enumeration.nextElement());
        }
    }

    public void writeData(GGElement gGElement) throws IOException {
        try {
            if (gGElement instanceof OutFileElement) {
                this.out.write(((OutFileElement)((Object)gGElement)).toOutLine());
                this.out.newLine();
                ++this.writedElements;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public boolean close() throws IOException {
        this.out.close();
        if (this.progressView != null) {
            this.progressView.setProgress(100);
            this.sleep();
        }
        return true;
    }

    public void write() throws IOException {
        this.open();
        this.writeData();
        this.close();
    }

    private void writeComment(BufferedWriter bufferedWriter, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            bufferedWriter.write("* " + stringTokenizer.nextToken() + "\n");
        }
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

