/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.ART_EB;
import de.geocalc.ggout.objects.ART_GIS_Kat;
import de.geocalc.ggout.objects.ART_GIS_View;
import de.geocalc.ggout.objects.ART_LL;
import de.geocalc.ggout.objects.ART_LM;
import de.geocalc.ggout.objects.ART_LP;
import de.geocalc.ggout.objects.ART_OA;
import de.geocalc.ggout.objects.ART_PA;
import de.geocalc.ggout.objects.ART_TA;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;

public class GeografisArtLine
extends GeografOutLine {
    public GeografisArtLine() {
    }

    public GeografisArtLine(String string) {
        super(string);
    }

    @Override
    public int getKennung() {
        if (this.length == 0 || this.line.charAt(0) == '*') {
            return 0;
        }
        int n = this.line.indexOf("=");
        return Constants.getIdentifier("GFIS_" + this.line.substring(0, n).trim());
    }

    @Override
    public String getValueString() {
        try {
            return this.line.substring(this.line.indexOf("=") + 1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public GGElement getElement() {
        GGElement gGElement = null;
        switch (this.getKennung()) {
            case 0: {
                break;
            }
            case 9001: {
                break;
            }
            case 9202: {
                return ART_GIS_View.parseOutLine(this);
            }
            case 9002: {
                return ART_GIS_Kat.parseOutLine(this);
            }
            case 9051: {
                break;
            }
            case 9052: {
                break;
            }
            case 9201: {
                return ART_EB.parseOutLine(this);
            }
            case 9301: {
                return ART_PA.parseOutLine(this);
            }
            case 9401: {
                return ART_LL.parseOutLine(this);
            }
            case 9411: {
                return ART_LP.parseOutLine(this);
            }
            case 9601: {
                return ART_LM.parseOutLine(this);
            }
            case 9701: {
                return ART_TA.parseOutLine(this);
            }
            case 9711: {
                break;
            }
            case 9901: {
                return ART_OA.parseOutLine(this);
            }
            default: {
                System.out.println(new Exception("Ungueltiger Typ " + this.getKennung()));
                System.out.println(this.line);
            }
        }
        return gGElement;
    }
}

