/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout;

import de.geocalc.ggout.objects.ART_VIEW;
import de.geocalc.ggout.objects.RulesElement;
import de.geocalc.util.IntegerHashList;
import java.util.Enumeration;

public class View
extends IntegerHashList {
    private int nr = 0;
    private ART_VIEW view = new ART_VIEW();

    public View() {
    }

    public View(int n) {
        this.nr = n;
    }

    public View(ART_VIEW aRT_VIEW) {
        this.view = aRT_VIEW;
        this.nr = aRT_VIEW.getNr();
    }

    public int getNr() {
        return this.nr;
    }

    public boolean hasScale(int n) {
        return n >= this.view.getMinMasstab() && n <= this.view.getMaxMasstab();
    }

    public int scaleDist(int n) {
        return Math.abs((this.view.getMaxMasstab() - this.view.getMinMasstab()) / 2 - n);
    }

    public RulesElement put(RulesElement rulesElement) {
        if (rulesElement instanceof ART_VIEW) {
            this.view = (ART_VIEW)rulesElement;
        }
        return (RulesElement)super.put(rulesElement);
    }

    @Override
    public RulesElement get(int n) {
        return (RulesElement)super.get(n);
    }

    public String toString() {
        return "View:" + this.nr + ": " + this.size() + " Elements, " + this.view.getMinMasstab() + "-" + this.view.getMaxMasstab() + ", " + this.view.getFactor();
    }

    public String getContentString() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        Enumeration enumeration = this.sortedElements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            stringBuffer.append(((RulesElement)enumeration.nextElement()).getContentString());
        }
        return stringBuffer.toString();
    }
}

