/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografArtLine;
import de.geocalc.ggout.GeografisArtLine;
import de.geocalc.ggout.objects.ART_GIS_Kat;
import de.geocalc.ggout.objects.ART_GIS_View;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.RulesColorElement;
import de.geocalc.ggout.objects.RulesEbeneElement;
import de.geocalc.ggout.objects.RulesNameElement;
import de.geocalc.ggout.objects.RulesSuperElement;
import de.geocalc.ggout.objects.RulesViewElement;
import java.util.Enumeration;

public final class ART_LL
extends RulesSuperElement
implements RulesViewElement,
RulesNameElement,
RulesEbeneElement,
RulesColorElement {
    private short view;
    private short color;
    private short ebene;
    private short stufe;
    private Byte drawMode;
    private Byte dispMode;
    private String bez;
    private String alias;
    private boolean displaceable;

    @Override
    public int getView() {
        return this.view;
    }

    @Override
    public void setView(int n) {
        this.view = (short)n;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public int getMode() {
        return this.drawMode.byteValue();
    }

    public int getDrawMode() {
        return this.drawMode.byteValue();
    }

    public int getDispMode() {
        return this.dispMode.byteValue();
    }

    @Override
    public int getEbene() {
        return this.ebene;
    }

    @Override
    public int getStufe() {
        return this.stufe;
    }

    public boolean isDisplaceable() {
        return this.displaceable;
    }

    @Override
    public String getName() {
        return this.bez != null ? this.bez : "";
    }

    public String getAlias() {
        return this.alias != null ? this.alias : "";
    }

    @Override
    public final int getIdentifier() {
        return 1401;
    }

    @Override
    public final int getMasterKey() {
        return 0xEA00000;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        super.setAttribute(n, object);
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Integer.toString(this.getSubKey()));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.color));
        stringBuffer.append(',');
        stringBuffer.append("\"" + this.bez + "\"");
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.drawMode.byteValue()));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.ebene));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.stufe));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.dispMode.byteValue()));
    }

    public static ART_LL parseOutLine(GeografArtLine geografArtLine) {
        ART_LL aRT_LL = new ART_LL();
        int n = 0;
        Enumeration enumeration = geografArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_LL.setKey(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        aRT_LL.color = (short)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        aRT_LL.bez = Constants.parseString(string);
                        break;
                    }
                    case 3: {
                        aRT_LL.drawMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 4: {
                        aRT_LL.ebene = (short)Integer.parseInt(string);
                        break;
                    }
                    case 5: {
                        aRT_LL.stufe = (short)Integer.parseInt(string);
                        break;
                    }
                    case 6: {
                        aRT_LL.dispMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 7: {
                        aRT_LL.alias = Constants.parseString(string);
                        break;
                    }
                    case 8: {
                        aRT_LL.displaceable = Integer.parseInt(string) > 0;
                    }
                }
            }
            ++n;
        }
        return aRT_LL;
    }

    public static ART_LL parseOutLine(GeografisArtLine geografisArtLine) {
        ART_LL aRT_LL = new ART_LL();
        int n = 0;
        Enumeration enumeration = geografisArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_LL.setKey(Integer.parseInt(string));
                    }
                }
            }
            ++n;
        }
        return aRT_LL;
    }

    @Override
    public void setGeografisKat(ART_GIS_Kat aRT_GIS_Kat) {
        this.bez = aRT_GIS_Kat.getBezeichnung();
    }

    @Override
    public void setGeografisView(ART_GIS_View aRT_GIS_View) {
        this.color = aRT_GIS_View.getColor();
    }
}

