/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografArtLine;
import de.geocalc.ggout.GeografisArtLine;
import de.geocalc.ggout.objects.ART_GIS_Kat;
import de.geocalc.ggout.objects.ART_GIS_View;
import de.geocalc.ggout.objects.ART_LF;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.RulesNameElement;
import de.geocalc.ggout.objects.RulesSuperElement;
import de.geocalc.ggout.objects.RulesViewElement;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class ART_LM
extends RulesSuperElement
implements RulesViewElement,
RulesNameElement {
    public static final int LOC_A = 0;
    public static final int LOC_M = 1;
    public static final int LOC_AE = 2;
    public static final int LOC_E = 3;
    public static final int SCALE_AUTO = 0;
    public static final int SCALE_NO = 1;
    public static final int SCALE_LENGTH = 2;
    public static final int SCALE_WIDTH = 3;
    public static final int SCALE_BOTH = 4;
    private short view;
    private byte locMode;
    private byte scaleMode;
    private String bez;
    private String alias;
    private float factor;

    @Override
    public int getView() {
        return this.view;
    }

    @Override
    public void setView(int n) {
        this.view = (short)n;
    }

    public int getMode() {
        return this.locMode;
    }

    public int getLocMode() {
        return this.locMode;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public float getFactor() {
        return this.factor;
    }

    @Override
    public String getName() {
        return this.bez != null ? this.bez : "";
    }

    public String getAlias() {
        return this.alias != null ? this.alias : "";
    }

    @Override
    public final int getIdentifier() {
        return 1601;
    }

    @Override
    public final int getMasterKey() {
        return 0xEC00000;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        super.setAttribute(n, object);
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Integer.toString(this.getSubKey()));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.locMode));
        stringBuffer.append(',');
        stringBuffer.append("\"" + this.bez + "\"");
        stringBuffer.append(',');
        stringBuffer.append(Float.toString(this.factor));
    }

    public static ART_LM parseOutLine(GeografArtLine geografArtLine) {
        ART_LM aRT_LM = new ART_LM();
        int n = 0;
        Enumeration enumeration = geografArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_LM.setKey(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        aRT_LM.locMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        aRT_LM.bez = Constants.parseString(string);
                        break;
                    }
                    case 3: {
                        aRT_LM.factor = new Double(string).floatValue();
                        break;
                    }
                    case 4: {
                        aRT_LM.alias = Constants.parseString(string);
                        break;
                    }
                    case 5: {
                        aRT_LM.scaleMode = (byte)Integer.parseInt(string);
                    }
                }
            }
            ++n;
        }
        return aRT_LM;
    }

    public static ART_LM parseOutLine(GeografisArtLine geografisArtLine) {
        ART_LM aRT_LM = new ART_LM();
        int n = 0;
        String string = null;
        Enumeration enumeration = geografisArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_LM.setKey(Integer.parseInt(string2));
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        string = string2;
                        break;
                    }
                    case 3: {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(1, string2.length() - 1), ",");
                        ART_LF aRT_LF = new ART_LF();
                        while (stringTokenizer.hasMoreTokens()) {
                            int n2;
                            Number number;
                            String string3 = stringTokenizer.nextToken();
                            Number number2 = number = string3.indexOf(".") >= 0 ? (Number)new Float(string3) : (Number)new Integer(string3);
                            if (number instanceof Integer && (n2 = ((Integer)number).intValue()) <= -100000) {
                                number = new Integer(n2 + 100000);
                            }
                            aRT_LF.addElement(number);
                        }
                        aRT_LM.addElement(aRT_LF);
                    }
                }
            }
            ++n;
        }
        if (string.equals("AW")) {
            aRT_LM.locMode = 0;
        } else if (string.equals("MW")) {
            aRT_LM.locMode = 1;
        } else if (string.equals("AE")) {
            aRT_LM.locMode = (byte)2;
        } else if (string.equals("ME")) {
            aRT_LM.locMode = (byte)3;
        }
        return aRT_LM;
    }

    @Override
    public void setGeografisKat(ART_GIS_Kat aRT_GIS_Kat) {
        this.bez = aRT_GIS_Kat.getBezeichnung();
    }

    @Override
    public void setGeografisView(ART_GIS_View aRT_GIS_View) {
    }
}

