/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografArtLine;
import de.geocalc.ggout.objects.ART_GIS_Kat;
import de.geocalc.ggout.objects.ART_GIS_View;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.RulesAngleElement;
import de.geocalc.ggout.objects.RulesNameElement;
import de.geocalc.ggout.objects.RulesPenElement;
import de.geocalc.ggout.objects.RulesSingleElement;
import de.geocalc.ggout.objects.RulesSizeElement;
import de.geocalc.ggout.objects.RulesSymbolElement;
import de.geocalc.ggout.objects.RulesViewElement;
import de.geocalc.ggout.objects.SizePropElement;
import java.util.Enumeration;

public final class ART_LS
extends RulesSingleElement
implements RulesViewElement,
RulesNameElement,
RulesPenElement,
RulesSymbolElement,
RulesSizeElement,
RulesAngleElement,
SizePropElement {
    private short view;
    private short symbol;
    private short pen;
    private byte drawMode;
    private float size;
    private float size2;
    private float angle;
    private String bez;
    private boolean absolut;
    private boolean sizeAbsolut;

    public ART_LS() {
    }

    public ART_LS(short s, short s2, float f, float f2, String string, boolean bl, byte by) {
        this.symbol = s;
        this.pen = s2;
        this.size = f;
        this.angle = f2;
        this.bez = string;
        this.absolut = bl;
        this.drawMode = by;
    }

    @Override
    public int getView() {
        return this.view;
    }

    @Override
    public void setView(int n) {
        this.view = (short)n;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public int getPen() {
        return this.pen;
    }

    public int getMode() {
        return this.drawMode;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void setSize(double d) {
        this.size = (float)d;
    }

    @Override
    public double getSize2() {
        return this.size2;
    }

    @Override
    public void setSize2(double d) {
        this.size2 = (float)d;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolut;
    }

    @Override
    public String getName() {
        return this.bez != null ? this.bez : "";
    }

    @Override
    public boolean isSizeIsFactor() {
        return !this.sizeAbsolut;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
        this.sizeAbsolut = !bl;
    }

    @Override
    public final int getIdentifier() {
        return 1501;
    }

    @Override
    public final int getMasterKey() {
        return 0xEB00000;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        super.setAttribute(n, object);
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Integer.toString(this.getSubKey()));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.symbol));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.pen));
        stringBuffer.append(',');
        stringBuffer.append(Float.toString(this.size));
        stringBuffer.append(',');
        stringBuffer.append(Float.toString(this.angle));
        stringBuffer.append(',');
        stringBuffer.append("\"" + this.bez + "\"");
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.absolut ? 1 : 0));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.drawMode));
    }

    public static ART_LS parseOutLine(GeografArtLine geografArtLine) {
        ART_LS aRT_LS = new ART_LS();
        int n = 0;
        Enumeration enumeration = geografArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_LS.setKey(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        aRT_LS.symbol = (short)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        aRT_LS.pen = (short)Integer.parseInt(string);
                        break;
                    }
                    case 3: {
                        aRT_LS.size = Float.parseFloat(string);
                        break;
                    }
                    case 4: {
                        aRT_LS.angle = Float.parseFloat(string);
                        break;
                    }
                    case 5: {
                        aRT_LS.bez = Constants.parseString(string);
                        break;
                    }
                    case 6: {
                        aRT_LS.absolut = Integer.parseInt(string) > 0;
                        break;
                    }
                    case 7: {
                        aRT_LS.drawMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 8: {
                        aRT_LS.size2 = Float.parseFloat(string);
                        break;
                    }
                    case 9: {
                        aRT_LS.sizeAbsolut = Integer.parseInt(string) > 0;
                    }
                }
            }
            ++n;
        }
        return aRT_LS;
    }

    @Override
    public void setGeografisKat(ART_GIS_Kat aRT_GIS_Kat) {
        this.bez = aRT_GIS_Kat.getBezeichnung();
    }

    @Override
    public void setGeografisView(ART_GIS_View aRT_GIS_View) {
        this.pen = aRT_GIS_View.getPen();
    }
}

