/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografArtLine;
import de.geocalc.ggout.GeografisArtLine;
import de.geocalc.ggout.objects.ART_GIS_Kat;
import de.geocalc.ggout.objects.ART_GIS_View;
import de.geocalc.ggout.objects.ART_LS;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.KatalogElement;
import de.geocalc.ggout.objects.RulesAngleElement;
import de.geocalc.ggout.objects.RulesColorPenElement;
import de.geocalc.ggout.objects.RulesEbeneElement;
import de.geocalc.ggout.objects.RulesNameElement;
import de.geocalc.ggout.objects.RulesSingleElement;
import de.geocalc.ggout.objects.RulesSizeElement;
import de.geocalc.ggout.objects.RulesSymbolElement;
import de.geocalc.ggout.objects.RulesViewElement;
import de.geocalc.ggout.objects.SizePropElement;
import java.util.Enumeration;

public final class ART_PA
extends RulesSingleElement
implements KatalogElement,
RulesViewElement,
RulesNameElement,
RulesEbeneElement,
RulesColorPenElement,
RulesSymbolElement,
RulesSizeElement,
RulesAngleElement,
SizePropElement {
    private short view;
    private short symbol;
    private short pen;
    private short color;
    private short ebene;
    private short stufe;
    private byte drawMode;
    private byte pnrMode;
    private byte dispMode;
    private float size;
    private float size2;
    private float angle;
    private String bez;
    private String nbz;
    private boolean absolut;
    private boolean displaceable;
    private boolean sizeAbsolut;

    @Override
    public int getView() {
        return this.view;
    }

    @Override
    public void setView(int n) {
        this.view = (short)n;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public int getPen() {
        return this.pen;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public int getMode() {
        return this.drawMode;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    @Override
    public int getEbene() {
        return this.ebene;
    }

    @Override
    public int getStufe() {
        return this.stufe;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void setSize(double d) {
        this.size = (float)d;
    }

    @Override
    public double getSize2() {
        return this.size2;
    }

    @Override
    public void setSize2(double d) {
        this.size2 = (float)d;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolut;
    }

    public int getPnrMode() {
        return this.pnrMode;
    }

    public int getDispMode() {
        return this.dispMode;
    }

    public String getNbz() {
        return this.nbz != null ? this.nbz : "";
    }

    public boolean isDisplaceable() {
        return this.displaceable;
    }

    @Override
    public String getName() {
        return this.bez != null ? this.bez : "";
    }

    @Override
    public boolean isSizeIsFactor() {
        return !this.sizeAbsolut;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
        this.sizeAbsolut = !bl;
    }

    @Override
    public final int getIdentifier() {
        return 1301;
    }

    @Override
    public final int getMasterKey() {
        return 0xE900000;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        super.setAttribute(n, object);
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Integer.toString(this.getSubKey()));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.symbol));
        stringBuffer.append(',');
        stringBuffer.append(Float.toString(this.size));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.pen));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.color));
        stringBuffer.append(',');
        stringBuffer.append("\"" + this.bez + "\"");
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.absolut ? 1 : 0));
        stringBuffer.append(',');
        stringBuffer.append(Float.toString(this.angle));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.drawMode));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.ebene));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.stufe));
    }

    public static ART_PA parseOutLine(GeografArtLine geografArtLine) {
        ART_PA aRT_PA = new ART_PA();
        int n = 0;
        Enumeration enumeration = geografArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_PA.setKey(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        aRT_PA.symbol = (short)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        aRT_PA.size = Float.parseFloat(string);
                        break;
                    }
                    case 3: {
                        aRT_PA.pen = (short)Integer.parseInt(string);
                        break;
                    }
                    case 4: {
                        aRT_PA.color = (short)Integer.parseInt(string);
                        break;
                    }
                    case 5: {
                        aRT_PA.bez = Constants.parseString(string);
                        break;
                    }
                    case 6: {
                        aRT_PA.absolut = Integer.parseInt(string) > 0;
                        break;
                    }
                    case 7: {
                        aRT_PA.angle = new Double(string).floatValue();
                        break;
                    }
                    case 8: {
                        aRT_PA.drawMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 9: {
                        aRT_PA.ebene = (short)Integer.parseInt(string);
                        break;
                    }
                    case 10: {
                        aRT_PA.stufe = (short)Integer.parseInt(string);
                        break;
                    }
                    case 11: {
                        aRT_PA.pnrMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 12: {
                        aRT_PA.dispMode = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 13: {
                        aRT_PA.nbz = Constants.parseString(string);
                        break;
                    }
                    case 14: {
                        aRT_PA.displaceable = Integer.parseInt(string) > 0;
                        break;
                    }
                    case 15: {
                        aRT_PA.size2 = Float.parseFloat(string);
                        break;
                    }
                    case 16: {
                        aRT_PA.sizeAbsolut = Integer.parseInt(string) > 0;
                    }
                }
            }
            ++n;
        }
        return aRT_PA;
    }

    public static ART_PA parseOutLine(GeografisArtLine geografisArtLine) {
        ART_PA aRT_PA = new ART_PA();
        int n = 0;
        Enumeration enumeration = geografisArtLine.values();
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).trim();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aRT_PA.setKey(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        aRT_PA.symbol = (short)Integer.parseInt(string);
                        break;
                    }
                    case 5: {
                        aRT_PA.angle = new Double(string).floatValue();
                        break;
                    }
                    case 6: {
                        aRT_PA.size = new Double(string).floatValue();
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
            }
            ++n;
        }
        return aRT_PA;
    }

    @Override
    public void setGeografisKat(ART_GIS_Kat aRT_GIS_Kat) {
        this.bez = aRT_GIS_Kat.getBezeichnung();
    }

    @Override
    public void setGeografisView(ART_GIS_View aRT_GIS_View) {
        this.pen = aRT_GIS_View.getPen();
        this.color = aRT_GIS_View.getColor();
    }

    public ART_LS toART_LS() {
        ART_LS aRT_LS = new ART_LS(this.symbol, this.pen, this.size, this.angle, this.bez, this.absolut, this.drawMode);
        aRT_LS.setKey(this.getSubKey() - 100000);
        return aRT_LS;
    }
}

