/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.OutFileParameterElement;
import java.util.Enumeration;

public final class AUFID
extends OutFileParameterElement {
    private String name;
    private String server;
    private byte mode;

    @Override
    public final int getIdentifier() {
        return 15;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getUuidConst() {
        if (this.name != null) {
            if (this.name.length() == 38 && this.name.charAt(0) == '{' && this.name.charAt(9) == '-' && this.name.charAt(37) == '}') {
                return this.name.substring(10, 37);
            }
            if (this.name.length() == 36 && this.name.charAt(8) == '-') {
                return this.name.substring(9);
            }
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = (byte)n;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        AUFID aUFID = new AUFID();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        aUFID.setName(Constants.parseString(string));
                        break;
                    }
                    case 1: {
                        aUFID.setMode(Integer.parseInt(string));
                        break;
                    }
                    case 2: {
                        aUFID.setServer(Constants.parseString(string));
                    }
                }
            }
            ++n;
        }
        return aUFID;
    }

    @Override
    public String toOutLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.quotedString(this.name));
        stringBuffer.append(',');
        stringBuffer.append(this.mode);
        stringBuffer.append(',');
        return stringBuffer.toString();
    }

    @Override
    public String getContentString() {
        return this.getName() + "," + this.getMode();
    }
}

