/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.Convertable;
import de.geocalc.ggout.objects.DVector;
import de.geocalc.ggout.objects.EbeneArtElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.SCH;
import java.util.Enumeration;

public class BO
extends DVector
implements EbeneArtElement,
Convertable {
    protected int art;

    public BO() {
        super(2);
    }

    @Override
    public SCH convert() {
        SCH sCH = new SCH();
        sCH.copy(this);
        sCH.setArt(this.art);
        sCH.setTyp(5);
        for (int i = 1; i < this.size(); i += 2) {
            sCH.addElement(new POS((Double)this.elementAt(i - 1), (Double)this.elementAt(i)));
        }
        return sCH;
    }

    @Override
    public int getIdentifier() {
        return 410;
    }

    @Override
    public final int getMasterKey() {
        return 0x4000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public int outLineColumns() {
        return 4;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                return new Integer(this.getArt());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getArt());
        stringBuffer.append(',');
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        BO bO = new BO();
        bO.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        bO.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        bO.setArt(Integer.parseInt(string));
                    }
                }
            }
            ++n;
        }
        return bO;
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt() + "[" + this.size() + "]";
    }
}

