/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.objects.Coo2D;
import de.geocalc.ggout.objects.EbeneArtElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.Referenz;
import de.geocalc.ggout.objects.UuidKey;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.IFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Constants {
    public static final double COO_ROUND_FACTOR = 10000.0;
    public static final char UNDERLINE_CHAR = '\u02fd';
    public static final char UNDERSCORE_CHAR = '_';
    public static final char REPLACEMENT_CHAR = '\ufffd';
    public static final String UNDERLINE_STRING = Character.toString('\u02fd');
    private static final Hashtable IDENTIFIERS = new Hashtable();
    private static final Hashtable KEYS = new Hashtable();
    private static final Hashtable ATTS = new Hashtable();
    private static final Hashtable<String, Integer> STZ_FILE_KEYS = new Hashtable();
    private static int STZ_LAST_FILE_KEY = 0;
    private static final Hashtable<UuidKey, Integer> UUIDS = new Hashtable();
    private static DecimalFormat doubleFormat = IFormat.f_4;
    public static final int UUID_TOTAL_LENGTH = 36;
    public static final int UUID_LOCAL_LENGTH = 8;
    public static final int UUID_CONST_LENGTH = 27;
    public static final int PLT_KAT_OFFSET = 100000;
    public static final char UUID_PART_DELIM = '-';
    public static final int PARAMETER = 1;
    public static final int VARIABLE = 2;
    public static final int SUB = 3;
    public static final int STACK = 4;
    public static final int SINGLE = 5;
    public static final int SUPER = 6;
    public static final int ARTDEF = 10;
    public static final int DATA = -2;
    public static final int NODEF = -1;
    public static final int COMMENT = 0;
    public static final int HIDDEN_CMD = 1;
    public static final int OPT = 11;
    public static final int TYP = 12;
    public static final int PAR = 13;
    public static final int BLATT = 14;
    public static final int AUFID = 15;
    public static final int PRJ = 16;
    public static final int SYSTEM = 17;
    public static final int ARTPLUS = 18;
    public static final int LAND = 19;
    public static final int BBOX = 20;
    public static final int RECH = 31;
    public static final int POLAR = 32;
    public static final int POLZUG = 33;
    public static final int PLOT = 40;
    public static final int AMT = 41;
    public static final int STEMPEL = 42;
    public static final int LEGENDE = 43;
    public static final int ARTEN = 44;
    public static final int ATTR = 45;
    public static final int KATALOG = 50;
    public static final int APP = 51;
    public static final int EB = 52;
    public static final int KEY = 61;
    public static final int ELNUM = 62;
    public static final int REF = 63;
    public static final int DEL = 64;
    public static final int PKNUM = 65;
    public static final int PB = 81;
    public static final int MODEL = 82;
    public static final int HNR = 91;
    public static final int PK = 100;
    public static final int KO = 111;
    public static final int KS = 112;
    public static final int PA = 113;
    public static final int LI = 200;
    public static final int TE = 300;
    public static final int TA = 301;
    public static final int TF = 302;
    public static final int TX = 303;
    public static final int TT = 304;
    public static final int TR = 305;
    public static final int TB = 306;
    public static final int TP = 307;
    public static final int SC = 400;
    public static final int SU = 401;
    public static final int BO = 410;
    public static final int BN = 411;
    public static final int SCH = 415;
    public static final int POS = 416;
    public static final int PNR = 417;
    public static final int SP = 420;
    public static final int SPZ = 421;
    public static final int SPL = 422;
    public static final int SI = 432;
    public static final int SIZ = 433;
    public static final int SN = 444;
    public static final int SNZ = 445;
    public static final int DG = 500;
    public static final int OO = 600;
    public static final int OOX = 601;
    public static final int OR = 602;
    public static final int OS = 603;
    public static final int OA = 690;
    public static final int OAX = 691;
    public static final int OD = 692;
    public static final int OT = 693;
    public static final int OE = 699;
    public static final int BE = 700;
    public static final int DA = 800;
    public static final int DDEF = 801;
    public static final int DART = 802;
    public static final int DTXT = 803;
    public static final int DE = 809;
    public static final int FINFO = 810;
    public static final int FTABLE = 811;
    public static final int FTYPES = 812;
    public static final int FTEXT = 813;
    public static final int FATTR = 814;
    public static final int MA = 850;
    public static final int MR = 851;
    public static final int ME = 859;
    public static final int GA = 860;
    public static final int GR = 861;
    public static final int RA = 900;
    public static final int DOC = 910;
    public static final int ART_TYP = 1001;
    public static final int ART_KATALOG = 1002;
    public static final int ART_FILE = 1003;
    public static final int ART_VIEW = 1004;
    public static final int ART_EB = 1101;
    public static final int ART_GR = 1201;
    public static final int ART_PA = 1301;
    public static final int ART_LL = 1401;
    public static final int ART_LP = 1411;
    public static final int ART_LS = 1501;
    public static final int ART_LM = 1601;
    public static final int ART_LF = 1611;
    public static final int ART_TA = 1701;
    public static final int ART_AA = 1801;
    public static final int ART_OA = 1901;
    public static final int ART_GRAF = 1998;
    public static final int ART_STYLE = 1999;
    public static final int SYM_TYP = 2100;
    public static final int SYM_PAR = 2101;
    public static final int SYM_SA = 2110;
    public static final int SYM_FA = 2111;
    public static final int SYM_GRAF = 2112;
    public static final int SYM_TS = 2113;
    public static final int SYM_FE = 2198;
    public static final int SYM_SE = 2199;
    public static final int ART_FA = 3001;
    public static final int ART_PEN = 3002;
    public static final int ART_COL = 3101;
    public static final int ART_LVL = 3201;
    public static final int ART_STZ = 3301;
    public static final int PLT_CMD = 6001;
    public static final int PLT_DATA = 6002;
    public static final int G_TYP = 9001;
    public static final int G_ART_KAT = 9002;
    public static final int G_ART_PEN = 9051;
    public static final int G_ART_COL = 9052;
    public static final int G_ART_EBENE = 9201;
    public static final int G_ART_VIEW = 9202;
    public static final int G_ART_DOT = 9301;
    public static final int G_ART_LIN = 9401;
    public static final int G_ART_LIN_PAR = 9411;
    public static final int G_ART_LFORM = 9601;
    public static final int G_ART_TXT = 9701;
    public static final int G_ART_TFORM = 9711;
    public static final int G_ART_OBJ = 9901;
    public static final int MIN_MASTER_KEY = 0x1000000;
    public static final int P_KEY = 0x1000000;
    public static final int L_KEY = 0x2000000;
    public static final int T_KEY = 0x3000000;
    public static final int S_KEY = 0x4000000;
    public static final int F_KEY = 0x5000000;
    public static final int H_KEY = 0x6000000;
    public static final int G_KEY = 0x7000000;
    public static final int R_KEY = 0x8000000;
    public static final int B_KEY = 0x9000000;
    public static final int O_KEY = 0xA000000;
    public static final int M_KEY = 0xB000000;
    public static final int D_KEY = 0xC000000;
    public static final int X_KEY = 0xD000000;
    public static final int ART_KATALOG_KEY = 0xE000000;
    public static final int ART_FILE_KEY = 0xE100000;
    public static final int ART_VIEW_KEY = 0xE200000;
    public static final int ART_FA_KEY = 0xE300000;
    public static final int ART_PEN_KEY = 0xE400000;
    public static final int ART_COL_KEY = 0xE500000;
    public static final int ART_LVL_KEY = 0xE600000;
    public static final int ART_EB_KEY = 0xE700000;
    public static final int ART_GR_KEY = 0xE800000;
    public static final int ART_PA_KEY = 0xE900000;
    public static final int ART_LL_KEY = 0xEA00000;
    public static final int ART_LS_KEY = 0xEB00000;
    public static final int ART_LM_KEY = 0xEC00000;
    public static final int ART_TA_KEY = 0xED00000;
    public static final int ART_AA_KEY = 0xEE00000;
    public static final int ART_OA_KEY = 0xEF00000;
    public static final int ART_STZ_KEY = 0xF000000;
    public static final int SYM_SA_KEY = 0xF100000;
    public static final int DD_KEY = 0xFA00000;
    public static final int DA_KEY = 0xFB00000;
    public static final int DT_KEY = 0xFC00000;
    public static final int DX_KEY = 0xFD00000;
    public static final int DP_KEY = 0xFE00000;
    public static final int ART_FILE_SYM_KEY = 0;
    public static final int ART_FILE_PEN_KEY = 1;
    public static final int ART_FILE_COL_KEY = 2;
    public static final int ART_FILE_LVL_KEY = 3;
    public static final int ART_FILE_MDE_KEY = 4;
    static final int I_HASHKEY = 1000;
    static final int I_SUBKEY = 1001;
    static final int I_UUID = 1050;
    static final int I_UUID_FLAG = 1051;
    static final int I_NAME = 1100;
    static final int I_NAME1 = 1101;
    static final int I_NAME2 = 1102;
    static final int I_NAME3 = 1103;
    static final int I_NAME4 = 1104;
    static final int I_TEXT = 1200;
    static final int I_ALL_TEXT = 1201;
    static final int I_KATALOG = 1501;
    static final int I_EBENE = 1502;
    static final int I_ART = 1503;
    static final int I_EXT_KEY = 1511;
    static final int I_TYP = 1521;
    static final int I_X = 2001;
    static final int I_Y = 2002;
    static final int I_XLU = 2011;
    static final int I_YLU = 2012;
    static final int I_XRU = 2021;
    static final int I_YRU = 2022;
    static final int I_X_BEZ = 2051;
    static final int I_Y_BEZ = 2052;
    static final int I_X_OFF = 2101;
    static final int I_Y_OFF = 2102;
    static final int I_X_VER = 2201;
    static final int I_Y_VER = 2202;
    static final int I_L_STAT = 2501;
    static final int I_L_GEW = 2601;
    static final int I_L_CTRL = 2602;
    static final int I_L_GEN = 2603;
    static final int I_L_ENT = 2604;
    static final int I_DIG_GEW = 2701;
    static final int I_DIG_TRAFO = 2901;
    static final int I_DIG_DOT = 2902;
    static final int I_DIG_AUS = 2903;
    static final int I_DIG_RAND = 2904;
    static final int I_DIG_SOLL = 2905;
    static final int I_DIG_FLAG = 2911;
    static final int I_OFF_FLAG = 2912;
    static final int I_Z = 3001;
    static final int I_Z_OFF = 3101;
    static final int I_Z_VER = 3201;
    static final int I_H_STAT = 3501;
    static final int I_H_GEW = 3601;
    static final int I_H_CTRL = 3602;
    static final int I_H_ENT = 3604;
    static final int I_ANGLE = 4001;
    static final int I_SIZE = 4011;
    static final int I_R1 = 4101;
    static final int I_R2 = 4102;
    static final int I_A = 4151;
    static final int I_ANGLE_OFF = 4201;
    static final int I_GEO_LUX = 4301;
    static final int I_GEO_LUY = 4302;
    static final int I_GEO_ROX = 4311;
    static final int I_GEO_ROY = 4312;
    static final int I_DOC_LUX = 4321;
    static final int I_DOC_LUY = 4322;
    static final int I_DOC_ROX = 4331;
    static final int I_DOC_ROY = 4332;
    static final int I_PAT_SIDE = 5001;
    static final int I_PAT_START = 5002;
    static final int I_PAT_DIST = 5004;
    static final int I_RAHMEN = 5011;
    static final int I_FREI = 5012;
    static final int I_POSI = 5013;
    static final int I_SUB_TYP = 5021;
    static final int I_COLOR = 5031;
    static final int I_PEN = 5032;
    static final int I_ANSATZ = 9001;
    static final int I_HOR = 9002;
    static final int I_DATUM = 9011;
    static final int I_AKT = 9012;
    static final int I_DATA_KEY = 9013;
    static final int I_OBEROBJEKT = 9021;
    static final int I_LINK = 9022;
    static final int I_N1 = 9031;
    static final int I_N2 = 9032;
    static final int I_N3 = 9033;
    public static final String HASHKEY = "key";
    public static final String SUBKEY = "subkey";
    public static final String UUID = "uuid";
    public static final String UUID_FLAG = "uuidFlag";
    public static final String NAME = "name";
    public static final String NAME1 = "name1";
    public static final String NAME2 = "name2";
    public static final String NAME3 = "name3";
    public static final String NAME4 = "name4";
    public static final String TEXT = "text";
    public static final String ALL_TEXT = "allText";
    public static final String EBENE = "ebene";
    public static final String ART = "art";
    public static final String EXT_KEY = "extKey";
    public static final String ITYP = "typ";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String XLU = "xlu";
    public static final String YLU = "ylu";
    public static final String XRU = "xru";
    public static final String YRU = "yru";
    public static final String X_BEZ = "xBez";
    public static final String Y_BEZ = "yBez";
    public static final String X_OFF = "xOff";
    public static final String Y_OFF = "yOff";
    public static final String X_VER = "xVer";
    public static final String Y_VER = "yVer";
    public static final String L_STAT = "lStat";
    public static final String L_GEW = "lGew";
    public static final String L_CTRL = "lCtrl";
    public static final String L_GEN = "lGen";
    public static final String L_ENT = "lEnt";
    public static final String DIG_GEW = "digGew";
    public static final String DIG_TRAFO = "digTrafo";
    public static final String DIG_DOT = "digDot";
    public static final String DIG_AUS = "digAus";
    public static final String DIG_RAND = "digRand";
    public static final String DIG_SOLL = "digSoll";
    public static final String DIG_FLAG = "digFlag";
    public static final String OFF_FLAG = "relFlag";
    public static final String Z = "z";
    public static final String Z_OFF = "zOff";
    public static final String Z_VER = "zVer";
    public static final String H_STAT = "hStat";
    public static final String H_GEW = "hGew";
    public static final String H_CTRL = "hCtrl";
    public static final String H_ENT = "hEnt";
    public static final String ANGLE = "angle";
    public static final String SIZE = "size";
    public static final String R1 = "r1";
    public static final String R2 = "r2";
    public static final String A = "a";
    public static final String ANGLE_OFF = "angleRel";
    public static final String GEO_LUX = "geoLUx";
    public static final String GEO_LUY = "geoLUy";
    public static final String GEO_ROX = "geoROx";
    public static final String GEO_ROY = "geoROy";
    public static final String DOC_LUX = "docLUx";
    public static final String DOC_LUY = "docLUy";
    public static final String DOC_ROX = "docROx";
    public static final String DOC_ROY = "docROy";
    public static final String PAT_SIDE = "patSide";
    public static final String PAT_START = "patStart";
    public static final String PAT_DIST = "patDist";
    public static final String RAHMEN = "rahmen";
    public static final String FREI = "frei";
    public static final String POSI = "pos";
    public static final String SUB_TYP = "subTyp";
    public static final String COLOR = "color";
    public static final String PEN = "pen";
    public static final String ANSATZ = "ansatz";
    public static final String HOR = "hor";
    public static final String DATUM = "datum";
    public static final String AKT = "akt";
    public static final String DATA_KEY = "dataKey";
    public static final String OBEROBJEKT = "ober";
    public static final String LINK = "link";
    public static final String N1 = "n1";
    public static final String N2 = "n2";
    public static final String N3 = "n3";
    private static final char TEMP_UNDERSCORE_CHAR = '\u02f7';
    private static final String OUT_UNDERSCORE_STRING = "\\\\_";
    private static final String TEMP_UNDERSCORE_STRING;
    private static final String UNDERSCORE_STRING;
    private static final Pattern UNICODE_PATTERN;

    public static final long roundCoo(double d) {
        return Math.round(d * 10000.0);
    }

    public static final String getIdentifierString(int n) {
        return (String)IDENTIFIERS.get(new Integer(n));
    }

    public static final int getIdentifier(String string) {
        Integer n = (Integer)KEYS.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static final int getAttributeKey(String string) {
        return (Integer)ATTS.get(string);
    }

    public static final String getAttributeName(int n) {
        Enumeration enumeration = ATTS.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ((Integer)ATTS.get(string) != n) continue;
            return string;
        }
        return null;
    }

    public static Object createElement(String string) throws Exception {
        String string2 = "de.geocalc.ggout.objects." + string;
        try {
            return Class.forName(string2).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Exception("Die Klasse '" + string2 + "' ist kein erzeugbares Objekt");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new Exception("Die Klasse '" + string2 + "' wurde nicht gefunden, Gro\u00df- und Kleinschreibung beachten");
        }
        catch (Exception exception) {
            throw new Exception("Die Klasse '" + string2 + "' wurde nicht gefunden");
        }
        catch (Error error) {
            throw new Exception("Ein Objekt der Klasse '" + string2 + "' konnte nicht erzeugt werden");
        }
    }

    public static int getStzFileKey(String string) {
        Integer n = STZ_FILE_KEYS.get(string = string.toLowerCase());
        if (n == null) {
            STZ_FILE_KEYS.put(string, ++STZ_LAST_FILE_KEY);
            return STZ_LAST_FILE_KEY;
        }
        return n;
    }

    public static String getStzFileName(int n) {
        Enumeration<String> enumeration = STZ_FILE_KEYS.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (STZ_FILE_KEYS.get(string) != n) continue;
            return string;
        }
        return null;
    }

    public static boolean isQuotedUuid(String string) {
        return string != null && string.startsWith("{") && string.endsWith("}");
    }

    public static String getUnquotedUuid(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static boolean isUnquotedUuid(String string) {
        return string != null && string.length() == 36 && string.charAt(8) == '-';
    }

    public static Integer putUuidReference(UuidKey uuidKey, int n) {
        return UUIDS.put(uuidKey, n);
    }

    public static int getUuidReference(UuidKey uuidKey) {
        Integer n = UUIDS.get(uuidKey);
        if (n == null) {
            System.out.println("Element zu Uuid " + String.valueOf(uuidKey) + " nicht gefunden!");
        }
        return n == null ? 0 : n;
    }

    public static int getUuidReference(String string) {
        return Constants.getUuidReference(new UuidKey(string));
    }

    public static boolean isTextable(GGElement gGElement) {
        if (gGElement instanceof HashElement) {
            HashElement hashElement = (HashElement)gGElement;
            switch (hashElement.getMasterKey()) {
                case 0x1000000: 
                case 0x2000000: 
                case 0x4000000: 
                case 0xA000000: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isObjectable(GGElement gGElement) {
        if (gGElement instanceof HashElement) {
            HashElement hashElement = (HashElement)gGElement;
            switch (hashElement.getMasterKey()) {
                case 0x1000000: 
                case 0x2000000: 
                case 0x3000000: 
                case 0x4000000: 
                case 0xA000000: {
                    return true;
                }
            }
        }
        return false;
    }

    public static void parseArts(String string, KatalogEbeneArtElement katalogEbeneArtElement) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n == 3) {
            katalogEbeneArtElement.setKatalog(Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (n >= 2) {
            katalogEbeneArtElement.setEbene(Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (n >= 1) {
            katalogEbeneArtElement.setArt(Integer.parseInt(stringTokenizer.nextToken()));
        }
    }

    public static void parseArts(String string, EbeneArtElement ebeneArtElement) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n == 3) {
            stringTokenizer.nextToken();
        }
        if (n >= 2) {
            ebeneArtElement.setEbene(Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (n >= 1) {
            ebeneArtElement.setArt(Integer.parseInt(stringTokenizer.nextToken()));
        }
    }

    static String toArtsString(KatalogEbeneArtElement katalogEbeneArtElement) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (katalogEbeneArtElement.getKatalog() > 0) {
            stringBuffer.append(Math.max(0, katalogEbeneArtElement.getKatalog()));
        }
        stringBuffer.append('.');
        if (katalogEbeneArtElement.getEbene() > 0) {
            stringBuffer.append(Math.max(0, katalogEbeneArtElement.getEbene()));
        }
        stringBuffer.append('.');
        stringBuffer.append(Math.max(0, katalogEbeneArtElement.getArt()));
        return stringBuffer.toString();
    }

    static String toArtsString(EbeneArtElement ebeneArtElement) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (ebeneArtElement.getEbene() > 0) {
            stringBuffer.append(Math.max(0, ebeneArtElement.getEbene()));
        }
        stringBuffer.append('.');
        stringBuffer.append(Math.max(0, ebeneArtElement.getArt()));
        return stringBuffer.toString();
    }

    public static final Object parsePNR(String string) {
        int n = string.indexOf(",");
        int n2 = string.length();
        if (n2 < 3) {
            return string;
        }
        if (n > 0) {
            return new Coo2D(Double.parseDouble(string.substring(1, n)), Double.parseDouble(string.substring(n + 1, n2 - 1)));
        }
        if (string.charAt(0) == '#' && string.charAt(n2 - 1) == '#') {
            return new Referenz(Integer.parseInt(string.substring(1, n2 - 1), 16));
        }
        if (string.charAt(2) == '=') {
            return new Referenz(string);
        }
        if (Constants.isQuotedUuid(string)) {
            return new Referenz(Constants.getUuidReference(string));
        }
        return string;
    }

    public static boolean isValidPointNumber(String string) {
        return string != null && string.length() > 0 && string.length() <= 15;
    }

    public static int parseColor(String string) {
        if (string != null) {
            try {
                int n = Integer.parseInt(string, 16);
                int n2 = n >> 0 & 0xFF;
                int n3 = n >> 8 & 0xFF;
                int n4 = n >> 16 & 0xFF;
                return 0xFF000000 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String toColorString(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 0 & 0xFF;
        int n5 = (n4 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n2 & 0xFF) << 0;
        return IFormat.getRightString(Integer.toHexString(n5), 6, '0');
    }

    public static int parseKey(String string) {
        char c = string.charAt(0);
        if (c == '{') {
            return Constants.getUuidReference(new UuidKey(string));
        }
        if (Character.isUpperCase(c)) {
            int n = 0;
            if (c == 'P') {
                n = 0x1000000;
            } else if (c == 'L') {
                n = 0x2000000;
            } else if (c == 'T') {
                n = 0x3000000;
            } else if (c == 'S') {
                n = 0x4000000;
            } else if (c == 'O') {
                n = 0xA000000;
            } else if (c == 'D') {
                n = 0x8000000;
            } else {
                new Exception("unbekannter KeyString:" + string).printStackTrace();
            }
            int n2 = string.indexOf("=") + 1;
            return n + Integer.parseInt(string.substring(n2));
        }
        return Integer.parseInt(string, 16);
    }

    public static String toKeyString(int n) {
        return Constants.toKeyString(n, true);
    }

    public static String toFileKeyString(int n) {
        return Constants.toKeyString(n, false);
    }

    private static String toKeyString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n2 = n % 0x1000000;
        int n3 = n - n2;
        if (n3 == 0x1000000) {
            stringBuffer.append("PK");
        } else if (n3 == 0x2000000) {
            stringBuffer.append("LI");
        } else if (n3 == 0x3000000) {
            stringBuffer.append("TE");
        } else if (n3 == 0x4000000) {
            stringBuffer.append("SCH");
        } else if (n3 == 0x7000000) {
            stringBuffer.append("DG");
        } else if (n3 == 0xA000000) {
            stringBuffer.append("OO");
        } else if (n3 == 0x9000000) {
            stringBuffer.append("BE");
        } else if (n3 == 0x8000000) {
            stringBuffer.append("DOC");
        } else {
            return "#" + Integer.toString(n2, 16) + "#";
        }
        if (bl) {
            stringBuffer.append("=");
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public static int getMasterKey(int n) {
        return n - n % 0x1000000;
    }

    static String parseString(Object object) {
        String string = object.toString();
        return string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    static String parseTextString(Object object) {
        String string = object.toString();
        if (string.startsWith("\" ") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.indexOf("\\u") >= 0) {
            string = Constants.decodeANSI(string);
        }
        if (string.indexOf(95) >= 0) {
            string = Constants.decodeUnderscore(string);
        }
        if (string.indexOf("\\\\") >= 0) {
            string = Constants.decodeBackslash(string);
        }
        return string;
    }

    static String toTextString(Object object) {
        Object object2 = object.toString();
        if (((String)object2).startsWith(" ")) {
            object2 = "\"" + (String)object2 + "\"";
        }
        object2 = Constants.encodeBackslash((String)object2);
        object2 = Constants.encodeUnderscore((String)object2);
        object2 = Constants.encodeANSI((String)object2);
        return object2;
    }

    static String quotedString(String string) {
        if (string == null) {
            return "";
        }
        return string.startsWith("\"") && string.endsWith("\"") ? string : "\"" + string + "\"";
    }

    static boolean parseBoolean(Object object) throws NumberFormatException {
        return object instanceof Number ? ((Number)object).intValue() != 0 : new Boolean(object.toString());
    }

    static int parseInt(Object object) throws NumberFormatException {
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
    }

    static double parseDouble(Object object) throws NumberFormatException {
        return object instanceof Number ? ((Number)object).doubleValue() : new Double(object.toString()).doubleValue();
    }

    static char parseChar(Object object) {
        return object.toString().charAt(0);
    }

    static String doubleString(double d) {
        return doubleFormat.format(d);
    }

    private static String decodeBackslash(String string) {
        return string.replace("\\\\", "\\");
    }

    private static String encodeBackslash(String string) {
        return string.replace("\\", "\\\\");
    }

    public static String decodeUnderscore(String string) {
        string = string.replace(OUT_UNDERSCORE_STRING, TEMP_UNDERSCORE_STRING);
        string = string.replace('_', '\u02fd');
        string = string.replace('\u02f7', '_');
        return string;
    }

    public static String encodeUnderscore(String string) {
        string = string.replace(UNDERSCORE_STRING, OUT_UNDERSCORE_STRING);
        string = string.replace('\u02fd', '_');
        return string;
    }

    public static String decodeANSI(String string) {
        Matcher matcher = UNICODE_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, String.valueOf((char)Integer.parseInt(matcher.group(1), 16)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String encodeANSI(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                stringBuffer.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static char encodeASCII(char c) {
        if (c >= '\u007f' && c <= '\u009f') {
            switch (c) {
                case '\u007f': {
                    c = (char)65533;
                    break;
                }
                case '\u0080': {
                    c = (char)8364;
                    break;
                }
                case '\u0081': {
                    c = (char)65533;
                    break;
                }
                case '\u0082': {
                    c = (char)8218;
                    break;
                }
                case '\u0083': {
                    c = (char)402;
                    break;
                }
                case '\u0084': {
                    c = (char)8222;
                    break;
                }
                case '\u0085': {
                    c = (char)8230;
                    break;
                }
                case '\u0086': {
                    c = (char)8224;
                    break;
                }
                case '\u0087': {
                    c = (char)8225;
                    break;
                }
                case '\u0088': {
                    c = (char)710;
                    break;
                }
                case '\u0089': {
                    c = (char)8240;
                    break;
                }
                case '\u008a': {
                    c = (char)352;
                    break;
                }
                case '\u008b': {
                    c = (char)8249;
                    break;
                }
                case '\u008c': {
                    c = (char)338;
                    break;
                }
                case '\u008d': {
                    c = (char)8309;
                    break;
                }
                case '\u008e': {
                    c = (char)381;
                    break;
                }
                case '\u008f': {
                    c = (char)8804;
                    break;
                }
                case '\u0090': {
                    c = (char)8805;
                    break;
                }
                case '\u0091': {
                    c = (char)8216;
                    break;
                }
                case '\u0092': {
                    c = (char)8217;
                    break;
                }
                case '\u0093': {
                    c = (char)8220;
                    break;
                }
                case '\u0094': {
                    c = (char)8221;
                    break;
                }
                case '\u0095': {
                    c = (char)8226;
                    break;
                }
                case '\u0096': {
                    c = (char)8211;
                    break;
                }
                case '\u0097': {
                    c = (char)8212;
                    break;
                }
                case '\u0098': {
                    c = (char)732;
                    break;
                }
                case '\u0099': {
                    c = (char)8482;
                    break;
                }
                case '\u009a': {
                    c = (char)353;
                    break;
                }
                case '\u009b': {
                    c = (char)8250;
                    break;
                }
                case '\u009c': {
                    c = (char)339;
                    break;
                }
                case '\u009d': {
                    c = (char)8734;
                    break;
                }
                case '\u009e': {
                    c = (char)382;
                    break;
                }
                case '\u009f': {
                    c = (char)376;
                }
            }
        } else if (c > '\u00ff') {
            c = (char)65533;
        }
        return c;
    }

    public static char encodeVisibleASCII(char c) {
        if (c < ' ') {
            return '\ufffd';
        }
        return Constants.encodeASCII(c);
    }

    public static String _decodeASCII(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Constants.decodeASCII(cArray[i]);
        }
        return new String(cArray);
    }

    public static char decodeASCII(char c) {
        if (c > '\u00ff') {
            switch (c) {
                case '\u20ac': {
                    c = (char)128;
                    break;
                }
                case '\u0081': {
                    c = (char)129;
                    break;
                }
                case '\u201a': {
                    c = (char)130;
                    break;
                }
                case '\u0192': {
                    c = (char)131;
                    break;
                }
                case '\u201e': {
                    c = (char)132;
                    break;
                }
                case '\u2026': {
                    c = (char)133;
                    break;
                }
                case '\u2020': {
                    c = (char)134;
                    break;
                }
                case '\u2021': {
                    c = (char)135;
                    break;
                }
                case '\u02c6': {
                    c = (char)136;
                    break;
                }
                case '\u2030': {
                    c = (char)137;
                    break;
                }
                case '\u0160': {
                    c = (char)138;
                    break;
                }
                case '\u2039': {
                    c = (char)139;
                    break;
                }
                case '\u0152': {
                    c = (char)140;
                    break;
                }
                case '\u2075': {
                    c = (char)141;
                    break;
                }
                case '\u017d': {
                    c = (char)142;
                    break;
                }
                case '\u2264': {
                    c = (char)143;
                    break;
                }
                case '\u2265': {
                    c = (char)144;
                    break;
                }
                case '\u2018': {
                    c = (char)145;
                    break;
                }
                case '\u2019': {
                    c = (char)146;
                    break;
                }
                case '\u201c': {
                    c = (char)147;
                    break;
                }
                case '\u201d': {
                    c = (char)148;
                    break;
                }
                case '\u2022': {
                    c = (char)149;
                    break;
                }
                case '\u2013': {
                    c = (char)150;
                    break;
                }
                case '\u2014': {
                    c = (char)151;
                    break;
                }
                case '\u02dc': {
                    c = (char)152;
                    break;
                }
                case '\u2122': {
                    c = (char)153;
                    break;
                }
                case '\u0161': {
                    c = (char)154;
                    break;
                }
                case '\u203a': {
                    c = (char)155;
                    break;
                }
                case '\u0153': {
                    c = (char)156;
                    break;
                }
                case '\u221e': {
                    c = (char)157;
                    break;
                }
                case '\u017e': {
                    c = (char)158;
                    break;
                }
                case '\u0178': {
                    c = (char)159;
                    break;
                }
                default: {
                    c = (char)63;
                }
            }
        }
        return c;
    }

    static {
        ATTS.put(HASHKEY, new Integer(1000));
        ATTS.put(SUBKEY, new Integer(1001));
        ATTS.put(UUID, new Integer(1050));
        ATTS.put(UUID_FLAG, new Integer(1051));
        ATTS.put(NAME, new Integer(1100));
        ATTS.put(NAME1, new Integer(1101));
        ATTS.put(NAME2, new Integer(1102));
        ATTS.put(NAME3, new Integer(1103));
        ATTS.put(NAME4, new Integer(1104));
        ATTS.put(TEXT, new Integer(1200));
        ATTS.put(ALL_TEXT, new Integer(1201));
        ATTS.put(EBENE, new Integer(1502));
        ATTS.put(ART, new Integer(1503));
        ATTS.put(EXT_KEY, new Integer(1511));
        ATTS.put(ITYP, new Integer(1521));
        ATTS.put(X, new Integer(2001));
        ATTS.put(Y, new Integer(2002));
        ATTS.put(XLU, new Integer(2011));
        ATTS.put(YLU, new Integer(2012));
        ATTS.put(XRU, new Integer(2021));
        ATTS.put(YRU, new Integer(2022));
        ATTS.put(X_BEZ, new Integer(2051));
        ATTS.put(Y_BEZ, new Integer(2052));
        ATTS.put(X_OFF, new Integer(2101));
        ATTS.put(Y_OFF, new Integer(2102));
        ATTS.put(X_VER, new Integer(2201));
        ATTS.put(Y_VER, new Integer(2202));
        ATTS.put(L_STAT, new Integer(2501));
        ATTS.put(L_GEW, new Integer(2601));
        ATTS.put(L_CTRL, new Integer(2602));
        ATTS.put(L_GEN, new Integer(2603));
        ATTS.put(L_ENT, new Integer(2604));
        ATTS.put(DIG_GEW, new Integer(2701));
        ATTS.put(DIG_TRAFO, new Integer(2901));
        ATTS.put(DIG_DOT, new Integer(2902));
        ATTS.put(DIG_AUS, new Integer(2903));
        ATTS.put(DIG_RAND, new Integer(2904));
        ATTS.put(DIG_SOLL, new Integer(2905));
        ATTS.put(DIG_FLAG, new Integer(2911));
        ATTS.put(OFF_FLAG, new Integer(2912));
        ATTS.put(Z, new Integer(3001));
        ATTS.put(Z_OFF, new Integer(3101));
        ATTS.put(Z_VER, new Integer(2202));
        ATTS.put(H_STAT, new Integer(3501));
        ATTS.put(H_GEW, new Integer(3601));
        ATTS.put(H_CTRL, new Integer(3602));
        ATTS.put(H_ENT, new Integer(3604));
        ATTS.put(ANGLE, new Integer(4001));
        ATTS.put(SIZE, new Integer(4011));
        ATTS.put(R1, new Integer(4101));
        ATTS.put(R2, new Integer(4102));
        ATTS.put(A, new Integer(4151));
        ATTS.put(ANGLE_OFF, new Integer(4201));
        ATTS.put(GEO_LUX, new Integer(4301));
        ATTS.put(GEO_LUY, new Integer(4302));
        ATTS.put(GEO_ROX, new Integer(4311));
        ATTS.put(GEO_ROY, new Integer(4312));
        ATTS.put(DOC_LUX, new Integer(4321));
        ATTS.put(DOC_LUY, new Integer(4322));
        ATTS.put(DOC_ROX, new Integer(4331));
        ATTS.put(DOC_ROY, new Integer(4332));
        ATTS.put(PAT_SIDE, new Integer(5001));
        ATTS.put(PAT_START, new Integer(5002));
        ATTS.put(PAT_DIST, new Integer(5004));
        ATTS.put(RAHMEN, new Integer(5011));
        ATTS.put(FREI, new Integer(5012));
        ATTS.put(POSI, new Integer(5013));
        ATTS.put(SUB_TYP, new Integer(5021));
        ATTS.put(COLOR, new Integer(5031));
        ATTS.put(PEN, new Integer(5032));
        ATTS.put(ANSATZ, new Integer(9001));
        ATTS.put(HOR, new Integer(9002));
        ATTS.put(DATUM, new Integer(9011));
        ATTS.put(AKT, new Integer(9012));
        ATTS.put(DATA_KEY, new Integer(9013));
        ATTS.put(OBEROBJEKT, new Integer(9021));
        ATTS.put(LINK, new Integer(9022));
        ATTS.put(N1, new Integer(9031));
        ATTS.put(N2, new Integer(9032));
        ATTS.put(N3, new Integer(9033));
        IDENTIFIERS.put(new Integer(11), "OPT");
        IDENTIFIERS.put(new Integer(12), "TYP");
        IDENTIFIERS.put(new Integer(13), "PAR");
        IDENTIFIERS.put(new Integer(14), "BLATT");
        IDENTIFIERS.put(new Integer(15), "AUFID");
        IDENTIFIERS.put(new Integer(16), "PRJ");
        IDENTIFIERS.put(new Integer(17), "System");
        IDENTIFIERS.put(new Integer(18), "ARTPLUS");
        IDENTIFIERS.put(new Integer(19), "LAND");
        IDENTIFIERS.put(new Integer(20), "BBox");
        IDENTIFIERS.put(new Integer(31), "RECH");
        IDENTIFIERS.put(new Integer(32), "POLAR");
        IDENTIFIERS.put(new Integer(33), "POLZUG");
        IDENTIFIERS.put(new Integer(40), "PLOT");
        IDENTIFIERS.put(new Integer(41), "AMT");
        IDENTIFIERS.put(new Integer(42), "STEMPEL");
        IDENTIFIERS.put(new Integer(43), "LEGENDE");
        IDENTIFIERS.put(new Integer(44), "ARTEN");
        IDENTIFIERS.put(new Integer(45), "ATTR");
        IDENTIFIERS.put(new Integer(50), "KATALOG");
        IDENTIFIERS.put(new Integer(51), "APP");
        IDENTIFIERS.put(new Integer(52), "EB");
        IDENTIFIERS.put(new Integer(61), "KEY");
        IDENTIFIERS.put(new Integer(62), "ELNUM");
        IDENTIFIERS.put(new Integer(63), "REF");
        IDENTIFIERS.put(new Integer(64), "DEL");
        IDENTIFIERS.put(new Integer(65), "PKNUM");
        IDENTIFIERS.put(new Integer(500), "DG");
        IDENTIFIERS.put(new Integer(81), "PB");
        IDENTIFIERS.put(new Integer(82), "MODEL");
        IDENTIFIERS.put(new Integer(91), "HNR");
        IDENTIFIERS.put(new Integer(91), "HORDEF");
        IDENTIFIERS.put(new Integer(100), "PK");
        IDENTIFIERS.put(new Integer(111), "KO");
        IDENTIFIERS.put(new Integer(112), "KS");
        IDENTIFIERS.put(new Integer(113), "PA");
        IDENTIFIERS.put(new Integer(200), "LI");
        IDENTIFIERS.put(new Integer(301), "TA");
        IDENTIFIERS.put(new Integer(303), "TX");
        IDENTIFIERS.put(new Integer(302), "TF");
        IDENTIFIERS.put(new Integer(304), "TT");
        IDENTIFIERS.put(new Integer(305), "TR");
        IDENTIFIERS.put(new Integer(306), "TB");
        IDENTIFIERS.put(new Integer(307), "TP");
        IDENTIFIERS.put(new Integer(300), "TE");
        IDENTIFIERS.put(new Integer(420), "SP");
        IDENTIFIERS.put(new Integer(421), "SPZ");
        IDENTIFIERS.put(new Integer(422), "SPL");
        IDENTIFIERS.put(new Integer(432), "SI");
        IDENTIFIERS.put(new Integer(433), "SIZ");
        IDENTIFIERS.put(new Integer(444), "SN");
        IDENTIFIERS.put(new Integer(445), "SNZ");
        IDENTIFIERS.put(new Integer(400), "SC");
        IDENTIFIERS.put(new Integer(401), "SU");
        IDENTIFIERS.put(new Integer(415), "SCH");
        IDENTIFIERS.put(new Integer(416), "POS");
        IDENTIFIERS.put(new Integer(417), "PNR");
        IDENTIFIERS.put(new Integer(410), "BO");
        IDENTIFIERS.put(new Integer(411), "BN");
        IDENTIFIERS.put(new Integer(600), "OO");
        IDENTIFIERS.put(new Integer(601), "OOX");
        IDENTIFIERS.put(new Integer(602), "OR");
        IDENTIFIERS.put(new Integer(603), "OS");
        IDENTIFIERS.put(new Integer(690), "OA");
        IDENTIFIERS.put(new Integer(691), "OAX");
        IDENTIFIERS.put(new Integer(692), "OD");
        IDENTIFIERS.put(new Integer(693), "OT");
        IDENTIFIERS.put(new Integer(699), "OE");
        IDENTIFIERS.put(new Integer(63), "REF");
        IDENTIFIERS.put(new Integer(700), "BE");
        IDENTIFIERS.put(new Integer(800), "DA");
        IDENTIFIERS.put(new Integer(801), "DDEF");
        IDENTIFIERS.put(new Integer(802), "DART");
        IDENTIFIERS.put(new Integer(803), "DTXT");
        IDENTIFIERS.put(new Integer(809), "DE");
        IDENTIFIERS.put(new Integer(810), "FInfo");
        IDENTIFIERS.put(new Integer(811), "FTable");
        IDENTIFIERS.put(new Integer(812), "FTypes");
        IDENTIFIERS.put(new Integer(814), "FAttr");
        IDENTIFIERS.put(new Integer(813), "FText");
        IDENTIFIERS.put(new Integer(850), "MA");
        IDENTIFIERS.put(new Integer(851), "MR");
        IDENTIFIERS.put(new Integer(859), "ME");
        IDENTIFIERS.put(new Integer(860), "GA");
        IDENTIFIERS.put(new Integer(861), "GR");
        IDENTIFIERS.put(new Integer(900), "RA");
        IDENTIFIERS.put(new Integer(910), "DOC");
        IDENTIFIERS.put(new Integer(1001), "TYP");
        IDENTIFIERS.put(new Integer(1002), "KATALOG");
        IDENTIFIERS.put(new Integer(1003), "FILE");
        IDENTIFIERS.put(new Integer(1004), "VIEW");
        IDENTIFIERS.put(new Integer(1201), "GR");
        IDENTIFIERS.put(new Integer(1101), "EB");
        IDENTIFIERS.put(new Integer(1301), "PA");
        IDENTIFIERS.put(new Integer(1401), "LL");
        IDENTIFIERS.put(new Integer(1411), "LP");
        IDENTIFIERS.put(new Integer(1501), "LS");
        IDENTIFIERS.put(new Integer(1601), "LM");
        IDENTIFIERS.put(new Integer(1611), "LF");
        IDENTIFIERS.put(new Integer(1701), "TA");
        IDENTIFIERS.put(new Integer(1801), "AA");
        IDENTIFIERS.put(new Integer(1901), "OA");
        IDENTIFIERS.put(new Integer(1999), "STYLE");
        IDENTIFIERS.put(new Integer(3001), "FA");
        IDENTIFIERS.put(new Integer(3002), "PEN");
        IDENTIFIERS.put(new Integer(3101), "COL");
        IDENTIFIERS.put(new Integer(3201), "LVL");
        IDENTIFIERS.put(new Integer(3301), "STZ");
        IDENTIFIERS.put(new Integer(6001), "PLT");
        IDENTIFIERS.put(new Integer(2100), "TYP");
        IDENTIFIERS.put(new Integer(2101), "PAR");
        IDENTIFIERS.put(new Integer(2110), "SA");
        IDENTIFIERS.put(new Integer(2111), "FA");
        IDENTIFIERS.put(new Integer(2112), "GRAF");
        IDENTIFIERS.put(new Integer(2113), "TS");
        IDENTIFIERS.put(new Integer(2198), "FE");
        IDENTIFIERS.put(new Integer(2199), "SE");
        IDENTIFIERS.put(new Integer(9001), "Typ");
        IDENTIFIERS.put(new Integer(9002), "ArtKat");
        IDENTIFIERS.put(new Integer(9051), "ArtPen");
        IDENTIFIERS.put(new Integer(9052), "ArtCol");
        IDENTIFIERS.put(new Integer(9201), "ArtEbene");
        IDENTIFIERS.put(new Integer(9202), "ArtView");
        IDENTIFIERS.put(new Integer(9301), "ArtDot");
        IDENTIFIERS.put(new Integer(9401), "ArtLin");
        IDENTIFIERS.put(new Integer(9411), "ArtLinPar");
        IDENTIFIERS.put(new Integer(9601), "ArtLForm");
        IDENTIFIERS.put(new Integer(9701), "ArtTxt");
        IDENTIFIERS.put(new Integer(9711), "ArtTForm");
        IDENTIFIERS.put(new Integer(9901), "ArtObj");
        KEYS.put("OPT", new Integer(11));
        KEYS.put("TYP", new Integer(12));
        KEYS.put("Typ", new Integer(12));
        KEYS.put("PAR", new Integer(13));
        KEYS.put("BLATT", new Integer(14));
        KEYS.put("AUFID", new Integer(15));
        KEYS.put("PRJ", new Integer(16));
        KEYS.put("System", new Integer(17));
        KEYS.put("ARTPLUS", new Integer(18));
        KEYS.put("LAND", new Integer(19));
        KEYS.put("BBox", new Integer(20));
        KEYS.put("RECH", new Integer(31));
        KEYS.put("POLAR", new Integer(32));
        KEYS.put("POLZUG", new Integer(33));
        KEYS.put("PLOT", new Integer(40));
        KEYS.put("AMT", new Integer(41));
        KEYS.put("STEMPEL", new Integer(42));
        KEYS.put("LEGENDE", new Integer(43));
        KEYS.put("ARTEN", new Integer(44));
        KEYS.put("ATTR", new Integer(45));
        KEYS.put("KATALOG", new Integer(50));
        KEYS.put("APP", new Integer(51));
        KEYS.put("EB", new Integer(52));
        KEYS.put("MODEL", new Integer(82));
        KEYS.put("KEY", new Integer(61));
        KEYS.put("ELNUM", new Integer(62));
        KEYS.put("REF", new Integer(63));
        KEYS.put("DEL", new Integer(64));
        KEYS.put("PKNUM", new Integer(65));
        KEYS.put("HNR", new Integer(91));
        KEYS.put("HORDEF", new Integer(91));
        KEYS.put("DG", new Integer(500));
        KEYS.put("PB", new Integer(81));
        KEYS.put("PK", new Integer(100));
        KEYS.put("KO", new Integer(111));
        KEYS.put("KS", new Integer(112));
        KEYS.put("PA", new Integer(113));
        KEYS.put("LI", new Integer(200));
        KEYS.put("TA", new Integer(301));
        KEYS.put("TX", new Integer(303));
        KEYS.put("TF", new Integer(302));
        KEYS.put("TT", new Integer(304));
        KEYS.put("TR", new Integer(305));
        KEYS.put("TB", new Integer(306));
        KEYS.put("TP", new Integer(307));
        KEYS.put("TE", new Integer(300));
        KEYS.put("SP", new Integer(420));
        KEYS.put("SPZ", new Integer(421));
        KEYS.put("SPL", new Integer(422));
        KEYS.put("SI", new Integer(432));
        KEYS.put("SIZ", new Integer(433));
        KEYS.put("SN", new Integer(444));
        KEYS.put("SNZ", new Integer(445));
        KEYS.put("SC", new Integer(400));
        KEYS.put("SU", new Integer(401));
        KEYS.put("SCH", new Integer(415));
        KEYS.put("POS", new Integer(416));
        KEYS.put("PNR", new Integer(417));
        KEYS.put("BO", new Integer(410));
        KEYS.put("BN", new Integer(411));
        KEYS.put("OO", new Integer(600));
        KEYS.put("OOX", new Integer(601));
        KEYS.put("OR", new Integer(602));
        KEYS.put("OS", new Integer(603));
        KEYS.put("OA", new Integer(690));
        KEYS.put("OAX", new Integer(691));
        KEYS.put("OD", new Integer(692));
        KEYS.put("OT", new Integer(693));
        KEYS.put("OE", new Integer(699));
        KEYS.put("BE", new Integer(700));
        KEYS.put("DA", new Integer(800));
        KEYS.put("DDEF", new Integer(801));
        KEYS.put("DART", new Integer(802));
        KEYS.put("DTXT", new Integer(803));
        KEYS.put("DE", new Integer(809));
        KEYS.put("FInfo", new Integer(810));
        KEYS.put("FTable", new Integer(811));
        KEYS.put("FTypes", new Integer(812));
        KEYS.put("FAttr", new Integer(814));
        KEYS.put("FText", new Integer(813));
        KEYS.put("MA", new Integer(850));
        KEYS.put("MR", new Integer(851));
        KEYS.put("ME", new Integer(859));
        KEYS.put("GA", new Integer(860));
        KEYS.put("GR", new Integer(861));
        KEYS.put("RA", new Integer(900));
        KEYS.put("DOC", new Integer(910));
        KEYS.put("STYLE", new Integer(1999));
        KEYS.put("SA", new Integer(2110));
        KEYS.put("FA", new Integer(2111));
        KEYS.put("GRAF", new Integer(2112));
        KEYS.put("TS", new Integer(2113));
        KEYS.put("FE", new Integer(2198));
        KEYS.put("SE", new Integer(2199));
        KEYS.put("ART_Typ", new Integer(1001));
        KEYS.put("ART_KATALOG", new Integer(1002));
        KEYS.put("ART_FILE", new Integer(1003));
        KEYS.put("ART_VIEW", new Integer(1004));
        KEYS.put("ART_GR", new Integer(1201));
        KEYS.put("ART_EB", new Integer(1101));
        KEYS.put("ART_PA", new Integer(1301));
        KEYS.put("ART_LL", new Integer(1401));
        KEYS.put("ART_LP", new Integer(1411));
        KEYS.put("ART_LS", new Integer(1501));
        KEYS.put("ART_LM", new Integer(1601));
        KEYS.put("ART_LF", new Integer(1611));
        KEYS.put("ART_TA", new Integer(1701));
        KEYS.put("ART_AA", new Integer(1801));
        KEYS.put("ART_OA", new Integer(1901));
        KEYS.put("ART_FA", new Integer(3001));
        KEYS.put("ART_PEN", new Integer(3002));
        KEYS.put("ART_COL", new Integer(3101));
        KEYS.put("ART_LVL", new Integer(3201));
        KEYS.put("ART_STZ", new Integer(3301));
        KEYS.put("PLT_CMD", new Integer(6001));
        KEYS.put("SYM_Typ", new Integer(2100));
        KEYS.put("SYM_PAR", new Integer(2101));
        KEYS.put("SYM_SA", new Integer(2110));
        KEYS.put("SYM_FA", new Integer(2111));
        KEYS.put("SYM_GRAF", new Integer(2112));
        KEYS.put("SYM_TS", new Integer(2113));
        KEYS.put("SYM_FE", new Integer(2198));
        KEYS.put("SYM_SE", new Integer(2199));
        KEYS.put("GFIS_Typ", new Integer(9001));
        KEYS.put("GFIS_ArtKat", new Integer(9002));
        KEYS.put("GFIS_ArtPen", new Integer(9051));
        KEYS.put("GFIS_ArtCol", new Integer(9052));
        KEYS.put("GFIS_ArtEbene", new Integer(9201));
        KEYS.put("GFIS_ArtView", new Integer(9202));
        KEYS.put("GFIS_ArtDot", new Integer(9301));
        KEYS.put("GFIS_ArtLin", new Integer(9401));
        KEYS.put("GFIS_ArtLinPar", new Integer(9411));
        KEYS.put("GFIS_ArtLForm", new Integer(9601));
        KEYS.put("GFIS_ArtTxt", new Integer(9701));
        KEYS.put("GFIS_ArtTForm", new Integer(9711));
        KEYS.put("GFIS_ArtObj", new Integer(9901));
        STZ_FILE_KEYS.put("zeichen.stz", ++STZ_LAST_FILE_KEY);
        STZ_FILE_KEYS.put("riss.stz", ++STZ_LAST_FILE_KEY);
        STZ_FILE_KEYS.put("fixed.stz", ++STZ_LAST_FILE_KEY);
        STZ_FILE_KEYS.put("script.stz", ++STZ_LAST_FILE_KEY);
        STZ_FILE_KEYS.put("roman.stz", ++STZ_LAST_FILE_KEY);
        TEMP_UNDERSCORE_STRING = Character.toString('\u02f7');
        UNDERSCORE_STRING = Character.toString('_');
        UNICODE_PATTERN = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    }
}

