/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.ArtElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.DAAtt;
import de.geocalc.ggout.objects.DataEntryElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.TableRow;
import java.util.Enumeration;

public class DA
extends TableRow
implements ArtElement,
DataEntryElement {
    private static final int UNDEF = 255;

    public DA() {
    }

    public DA(int n) {
        this.setArt(n);
    }

    @Override
    public String getName() {
        return Integer.toString(this.getArt());
    }

    @Override
    public int getIdentifier() {
        return 800;
    }

    @Override
    public final int getMasterKey() {
        return 0xC000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = (short)n;
    }

    @Override
    public boolean isTemporary() {
        return this.art >= 200 && !this.isUndef();
    }

    @Override
    public boolean isUndef() {
        return this.art == 255 || this.art == 9999;
    }

    @Override
    protected boolean isKeyAttributeName(String string) {
        return false;
    }

    @Override
    protected int getOutSubKey() {
        return this.getSubKey() % 4096;
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getArt());
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        DA dA = new DA();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        int n2 = geografOutLine.getKey();
                        dA.setArt(Integer.parseInt(string));
                        if (n2 == 0) break;
                        dA.setKey(4096 * dA.getArt() + n2);
                        break;
                    }
                    default: {
                        String string2 = Constants.parseString(string);
                        if (dA.getArt() == 255) {
                            int n3 = string2.indexOf(":");
                            DAAtt dAAtt = new DAAtt();
                            if (n3 >= 0) {
                                dAAtt.setName(string2.substring(0, n3));
                                dAAtt.setValue(string2.substring(n3 + 1));
                            } else {
                                dAAtt.setName("ATT" + n);
                                dAAtt.setValue(string2);
                            }
                            dA.addAttribute(dAAtt);
                            break;
                        }
                        dA.addAttribute(new DAAtt(string2));
                    }
                }
            }
            ++n;
        }
        dA.trimAttributesToSize();
        return dA;
    }

    public static int createDAKey(int n, int n2) {
        return 0xC000000 + 4096 * n + n2;
    }
}

