/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.SingleElement;
import java.util.Enumeration;

public final class DG
extends SingleElement {
    private short hor;
    private String d1;
    private String d2;
    private String d3;
    private int n1;
    private int n2;
    private int n3;

    public static boolean isNummer(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.length() > 0 && (!string.startsWith("#") || !string.endsWith("#")) && !string.startsWith("PK=");
        }
        return false;
    }

    @Override
    public final int getIdentifier() {
        return 500;
    }

    @Override
    public final int getMasterKey() {
        return 0x7000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    public int getHorizont() {
        return this.hor;
    }

    public void setHorizont(int n) {
        this.hor = (short)n;
    }

    public String getName1() {
        return this.d1;
    }

    public void setName1(String string) {
        this.d1 = string;
    }

    public void setRef1(int n) {
        this.d1 = "PK=" + n % 0x1000000;
    }

    public String getName2() {
        return this.d2;
    }

    public void setName2(String string) {
        this.d2 = string;
    }

    public void setRef2(int n) {
        this.d2 = "PK=" + n % 0x1000000;
    }

    public String getName3() {
        return this.d3;
    }

    public void setName3(String string) {
        this.d3 = string;
    }

    public void setRef3(int n) {
        this.d3 = "PK=" + n % 0x1000000;
    }

    public int getN() {
        return this.getOutSubKey();
    }

    public int getN1() {
        return this.n1;
    }

    public void setN1(int n) {
        this.n1 = n;
    }

    public int getN2() {
        return this.n2;
    }

    public void setN2(int n) {
        this.n2 = n;
    }

    public int getN3() {
        return this.n3;
    }

    public void setN3(int n) {
        this.n3 = n;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 9002: {
                return new Integer(this.getHorizont());
            }
            case 1101: {
                return this.getName1();
            }
            case 1102: {
                return this.getName2();
            }
            case 1103: {
                return this.getName3();
            }
            case 9031: {
                return new Integer(this.getN1());
            }
            case 9032: {
                return new Integer(this.getN2());
            }
            case 9033: {
                return new Integer(this.getN3());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 9002: {
                this.setHorizont(Constants.parseInt(object));
                break;
            }
            case 1101: {
                this.setName1(Constants.parseString(object));
                break;
            }
            case 1102: {
                this.setName2(Constants.parseString(object));
                break;
            }
            case 1103: {
                this.setName3(Constants.parseString(object));
                break;
            }
            case 9031: {
                this.setN1(Constants.parseInt(object));
                break;
            }
            case 9032: {
                this.setN2(Constants.parseInt(object));
                break;
            }
            case 9033: {
                this.setN3(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getHorizont());
        stringBuffer.append(',');
        stringBuffer.append(this.getName1());
        stringBuffer.append(',');
        stringBuffer.append(this.getName2());
        stringBuffer.append(',');
        stringBuffer.append(this.getName3());
        stringBuffer.append(',');
        if (this.n1 != 0) {
            stringBuffer.append(this.getN1());
        }
        stringBuffer.append(',');
        if (this.n2 != 0) {
            stringBuffer.append(this.getN2());
        }
        stringBuffer.append(',');
        if (this.n3 != 0) {
            stringBuffer.append(this.getN3());
        }
        stringBuffer.append(',');
    }

    public static DG parseOutLine(GeografOutLine geografOutLine) {
        DG dG = new DG();
        dG.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        dG.setHorizont(Integer.parseInt(string));
                        break;
                    }
                    case 1: {
                        dG.setName1(string);
                        break;
                    }
                    case 2: {
                        dG.setName2(string);
                        break;
                    }
                    case 3: {
                        dG.setName3(string);
                        break;
                    }
                    case 4: {
                        dG.setN1(Integer.parseInt(string));
                        break;
                    }
                    case 5: {
                        dG.setN2(Integer.parseInt(string));
                        break;
                    }
                    case 6: {
                        dG.setN3(Integer.parseInt(string));
                    }
                }
            }
            ++n;
        }
        return dG;
    }

    @Override
    public String getContentString() {
        return this.d1 + "-" + this.d2 + "-" + this.d3;
    }
}

