/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.RA;
import java.util.Enumeration;

public final class DOC
extends RA {
    protected byte typ;

    @Override
    public final int getIdentifier() {
        return 910;
    }

    @Override
    public int getTyp() {
        return this.typ;
    }

    @Override
    public void setTyp(int n) {
        this.typ = (byte)n;
    }

    @Override
    public int contentType() {
        switch (this.typ) {
            case 0: {
                return 100;
            }
            case 1: {
                return 201;
            }
            case 2: {
                return 900;
            }
            case 3: {
                return 190;
            }
            case 4: {
                return 202;
            }
            case 5: {
                return 302;
            }
            case 6: {
                return 301;
            }
        }
        return 0;
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.quotedString(this.fName));
        stringBuffer.append(',');
        stringBuffer.append(this.typ);
        stringBuffer.append(',');
        stringBuffer.append(this.pen);
        stringBuffer.append(',');
        stringBuffer.append(this.trans);
        stringBuffer.append(',');
        stringBuffer.append(this.geoLUX);
        stringBuffer.append(',');
        stringBuffer.append(this.geoLUY);
        stringBuffer.append(',');
        stringBuffer.append(this.geoROX);
        stringBuffer.append(',');
        stringBuffer.append(this.geoROY);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpLUX);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpLUY);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpROX);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpROY);
        stringBuffer.append(',');
        stringBuffer.append(this.stufe);
        stringBuffer.append(',');
        stringBuffer.append(this.dig);
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        DOC dOC = new DOC();
        dOC.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        dOC.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        dOC.fName = Constants.parseString(string);
                        break;
                    }
                    case 1: {
                        dOC.typ = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        dOC.pen = (short)Integer.parseInt(string);
                        break;
                    }
                    case 3: {
                        dOC.trans = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 4: {
                        dOC.geoLUX = new Double(string);
                        break;
                    }
                    case 5: {
                        dOC.geoLUY = new Double(string);
                        break;
                    }
                    case 6: {
                        dOC.geoROX = new Double(string);
                        break;
                    }
                    case 7: {
                        dOC.geoROY = new Double(string);
                        break;
                    }
                    case 8: {
                        dOC.bmpLUX = new Double(string);
                        break;
                    }
                    case 9: {
                        dOC.bmpLUY = new Double(string);
                        break;
                    }
                    case 10: {
                        dOC.bmpROX = new Double(string);
                        break;
                    }
                    case 11: {
                        dOC.bmpROY = new Double(string);
                        break;
                    }
                    case 12: {
                        dOC.stufe = (short)Integer.parseInt(string);
                        break;
                    }
                    case 13: {
                        dOC.dig = (short)Integer.parseInt(string);
                    }
                }
            }
            ++n;
        }
        return dOC;
    }
}

