/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.DVectorEnumerator;
import de.geocalc.ggout.objects.SuperElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class DVector
extends SuperElement
implements Cloneable {
    protected double[] elementData;
    protected int elementCount;

    public DVector(int n) {
        this.elementData = new double[n];
    }

    @Override
    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            double[] dArray = this.elementData;
            this.elementData = new double[this.elementCount];
            System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            double[] dArray = this.elementData;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new double[n3];
            System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = 0.0;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    @Override
    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public final synchronized Enumeration elements() {
        return new DVectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            for (int i = n; i < this.elementCount; ++i) {
                if (d != this.elementData[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return new Double(this.elementData[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    @Override
    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return new Double(this.elementData[0]);
    }

    @Override
    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return new Double(this.elementData[this.elementCount - 1]);
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = ((Number)object).doubleValue();
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0.0;
    }

    @Override
    public void removeFirstElement() {
        this.removeElementAt(0);
    }

    @Override
    public void removeLastElement() {
        this.removeElementAt(this.elementCount - 1);
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = ((Number)object).doubleValue();
        ++this.elementCount;
    }

    @Override
    public final synchronized void addElement(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = ((Number)object).doubleValue();
    }

    public final synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0.0;
        }
        this.elementCount = 0;
    }

    @Override
    public synchronized Object clone() {
        try {
            DVector dVector = (DVector)super.clone();
            dVector.elementData = new double[this.elementCount];
            System.arraycopy(this.elementData, 0, dVector.elementData, 0, this.elementCount);
            return dVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int elementCount() {
        return this.size();
    }

    public abstract int outLineColumns();

    @Override
    public final void appendToOutLine(StringBuffer stringBuffer) {
        this.appendDefToOutLine(stringBuffer);
        int n = this.outLineColumns();
        for (int i = 0; i < this.elementCount; ++i) {
            if (n == this.outLineColumns()) {
                stringBuffer.append("\n  ");
                n = 1;
            } else {
                ++n;
            }
            double d = this.elementData[i];
            if (Math.abs(d) >= 1.0E100) {
                stringBuffer.append(IFormat.e1.format(d));
            } else {
                stringBuffer.append(d);
            }
            stringBuffer.append(',');
        }
    }

    @Override
    public final void addOutLine(GeografOutLine geografOutLine) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(geografOutLine.getLine(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addElement(new Double(stringTokenizer.nextToken()));
        }
    }
}

