/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.GR;
import de.geocalc.ggout.objects.MasterElement;
import de.geocalc.ggout.objects.OutFileStackElement;
import de.geocalc.ggout.objects.OutFileSubElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class GA
extends OutFileStackElement
implements MasterElement {
    protected int key;
    private int elemlink;
    private Vector<GR> elements = new Vector();

    public GA() {
        this(0);
    }

    public final void setKey(int n) {
        this.key = n;
    }

    public final int getKey() {
        return this.key;
    }

    public GA(int n) {
        this.elemlink = n;
    }

    public GA(GR gR) {
        this.elemlink = gR.getLink();
    }

    @Override
    public final int getIdentifier() {
        return 861;
    }

    @Override
    public String getOutKey() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.getIdentifierString());
        stringBuffer.append(this.key);
        stringBuffer.append(": ");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GA) {
            return this.key == ((GA)object).key;
        }
        return false;
    }

    public final int getLink() {
        return this.elemlink;
    }

    public void setLink(int n) {
        this.elemlink = n;
    }

    public int getLinkMasterKey() {
        return this.elemlink / 0x1000000 * 0x1000000;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            default: 
        }
        super.setAttribute(n, object);
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        GA gA = new GA();
        gA.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        gA.setLink(Constants.parseKey(string));
                    }
                }
            }
            ++n;
        }
        return gA;
    }

    @Override
    public String toOutLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.toKeyString(this.getLink()));
        Enumeration<GR> enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n  ");
            ((OutFileSubElement)enumeration.nextElement()).appendToOutLine(stringBuffer, this.key);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getContentString() {
        return Integer.toString(this.getLink());
    }

    public boolean contains(int n) {
        Enumeration<GR> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().getLink() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public int elementCount() {
        return this.elements.size();
    }

    @Override
    public void addElement(Object object) {
        this.elements.addElement((GR)object);
    }

    @Override
    public Object elementAt(int n) throws NoSuchElementException {
        return this.elements.elementAt(n);
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public Enumeration<GR> elements() {
        return this.elements.elements();
    }

    public Object remove(int n) throws ArrayIndexOutOfBoundsException {
        return this.elements.remove(n);
    }
}

